/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.enterprise.springboot.embedded.BesConnectorCustomizer;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.crane.http11.AbstractHttp11Protocol;
import com.bes.enterprise.webtier.connector.Connector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.StringUtils;

class CompressionConnectorCustomizer
implements BesConnectorCustomizer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_MIN_RESPONSE_SIZE = 2048;
    private final Compression compression;

    CompressionConnectorCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public void customize(Connector connector) {
        ProtocolHandler handler;
        if (this.compression != null && this.compression.getEnabled() && (handler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol) {
            this.customize((AbstractHttp11Protocol)handler);
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol) {
        Compression compression = this.compression;
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize(compression));
        protocol.setCompressibleMimeType(StringUtils.arrayToCommaDelimitedString((Object[])compression.getMimeTypes()));
        if (this.compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(StringUtils.arrayToCommaDelimitedString((Object[])this.compression.getExcludedUserAgents()));
        }
    }

    private int getMinResponseSize(Compression compression) {
        Class<?> clazz = null;
        Object minResponseSize = null;
        try {
            clazz = compression.getClass();
            Method method = clazz.getMethod("getMinResponseSize", new Class[0]);
            minResponseSize = method.invoke(clazz.newInstance(), new Object[0]);
            if (minResponseSize instanceof Integer) {
                return (Integer)minResponseSize;
            }
            Class<?> cls = minResponseSize.getClass();
            Field field = cls.getDeclaredField("bytes");
            field.setAccessible(true);
            int value = Integer.parseInt(field.get(minResponseSize).toString());
            return value;
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error occurred when customizing connector :" + ex.getMessage()));
            return 2048;
        }
    }
}

