/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.enterprise.springboot.embedded.BesWebServer;
import com.bes.enterprise.springboot.embedded.GracefulShutdown;
import com.bes.enterprise.web.Embedded;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.boot.web.server.Shutdown;

public class GracefulBesWebServer
extends BesWebServer {
    private final GracefulShutdown gracefulShutdown;

    public GracefulBesWebServer(Embedded bes) {
        this(bes, true);
    }

    public GracefulBesWebServer(Embedded bes, boolean autoStart) {
        this(bes, autoStart, Shutdown.IMMEDIATE, false);
    }

    public GracefulBesWebServer(Embedded bes, boolean autoStart, Shutdown shutdown, boolean useNaming) {
        super(bes, autoStart, useNaming);
        this.gracefulShutdown = shutdown == Shutdown.GRACEFUL ? new GracefulShutdown(bes) : null;
    }

    @Override
    public void gracefulShutdownAbort() {
        if (this.gracefulShutdown != null) {
            this.gracefulShutdown.abort();
        }
    }

    public void shutDownGracefully(GracefulShutdownCallback callback) {
        if (this.gracefulShutdown == null) {
            callback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        this.gracefulShutdown.shutDownGracefully(callback);
    }
}

