/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.enterprise.web.Embedded;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;

final class GracefulShutdown {
    private static final Log logger = LogFactory.getLog(GracefulShutdown.class);
    private final Embedded bes;
    private volatile boolean aborted = false;

    GracefulShutdown(Embedded bes) {
        this.bes = bes;
    }

    void shutDownGracefully(GracefulShutdownCallback callback) {
        logger.info((Object)"Commencing graceful shutdown. Waiting for active requests to complete");
        new Thread(() -> this.doShutdown(callback), "bes-shutdown").start();
    }

    private void doShutdown(GracefulShutdownCallback callback) {
        List<Connector> connectors = this.getConnectors();
        connectors.forEach(this::close);
        try {
            for (Container host : this.bes.getEngine().findChildren()) {
                for (Container context : host.findChildren()) {
                    while (this.isActive(context)) {
                        if (this.aborted) {
                            logger.info((Object)"Graceful shutdown aborted with one or more requests still active");
                            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
                            return;
                        }
                        Thread.sleep(50L);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        logger.info((Object)"Graceful shutdown BES complete");
        callback.shutdownComplete(GracefulShutdownResult.IDLE);
    }

    private List<Connector> getConnectors() {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Service service : this.bes.getServer().findServices()) {
            Collections.addAll(connectors, service.findConnectors());
        }
        return connectors;
    }

    private void close(Connector connector) {
        connector.pause();
        connector.getProtocolHandler().closeServerSocketGraceful();
    }

    private boolean isActive(Container context) {
        try {
            for (Container wrapper : context.findChildren()) {
                if (((DefaultWrapper)wrapper).getCountAllocated() <= 0) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void abort() {
        this.aborted = true;
    }
}

