/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.appserv.lic.LicData;
import com.bes.appserv.lic.LicenseHelper;
import com.bes.enterprise.springboot.embedded.EmbeddedLifecycle;
import com.bes.enterprise.webtier.util.ServerInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.WebServerException;

public class StoreLicLifecycle
implements EmbeddedLifecycle {
    private static final Log logger = LogFactory.getLog(StoreLicLifecycle.class);
    private final int interval;
    private final File tempDir;
    private ScheduledExecutorService executor;

    public StoreLicLifecycle(File tempDir, int interval) {
        this.tempDir = tempDir;
        this.interval = interval;
    }

    @Override
    public void start() throws WebServerException {
        int coreSize = 1;
        this.executor = new ScheduledThreadPoolExecutor(coreSize, new StoreLicThreadFactory());
        this.executor.scheduleWithFixedDelay(new StoreLicenseProcessor(this.tempDir), 0L, this.interval, TimeUnit.MINUTES);
    }

    @Override
    public void stop() throws WebServerException {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private static final class StoreLicenseProcessor
    implements Runnable {
        private static final String LICENSE_INFO_FILE_NAME = "license-info.dat";
        private final File infoFile;

        StoreLicenseProcessor(File tempDir) {
            this.infoFile = new File(tempDir, LICENSE_INFO_FILE_NAME);
        }

        @Override
        public void run() {
            block26: {
                LicData licData = LicenseHelper.readLicData();
                try (OutputStreamWriter streamWriter = new OutputStreamWriter(Files.newOutputStream(this.infoFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
                     BufferedWriter writer = new BufferedWriter(streamWriter);){
                    writer.write("Version : ");
                    writer.write(ServerInfo.getServerNumber());
                    writer.newLine();
                    writer.write("Customer Name : ");
                    writer.write(licData.getCustomerName());
                    writer.newLine();
                    writer.write("Project Name : ");
                    writer.write(licData.getProjectName());
                    writer.newLine();
                    writer.write("License Type : ");
                    writer.write(licData.getRegisterType());
                    writer.newLine();
                    writer.write("Expiry Date : ");
                    writer.write(licData.getExpiryDate());
                    writer.newLine();
                    writer.write("Expiry Day : ");
                    writer.write(licData.getExpiryDay());
                    writer.newLine();
                }
                catch (IOException e2) {
                    if (!logger.isWarnEnabled()) break block26;
                    logger.warn((Object)String.format("Failed to save license information into file %s.", this.infoFile.getAbsolutePath()), (Throwable)e2);
                }
            }
        }
    }

    private static class StoreLicThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public StoreLicThreadFactory() {
            SecurityManager s2 = System.getSecurityManager();
            this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
            String threadName = "Store-license-Thread";
            this.namePrefix = threadName + "-";
        }

        @Override
        public Thread newThread(Runnable r2) {
            Thread t2 = new Thread(this.group, r2, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t2.setContextClassLoader(this.getClass().getClassLoader());
            t2.setDaemon(true);
            return t2;
        }
    }
}

