/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.util;

import com.bes.enterprise.springboot.util.JarInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.springframework.boot.loader.jar.JarFile;

public class ClassPreventUtil {
    private static Map<String, JarInfo> jarInfos = new HashMap<String, JarInfo>();
    private static Map<String, HashSet<String>> conflictJars = new HashMap<String, HashSet<String>>();

    public static void check() throws Exception {
        String conflictJarList = null;
        try {
            String parentJarPath = ClassPreventUtil.class.getClassLoader().getResource("").getPath().split("!")[0];
            if (parentJarPath.startsWith("file:/")) {
                String[] paths = parentJarPath.split("/");
                parentJarPath = "./" + paths[paths.length - 1];
            }
            JarFile jar = new JarFile(new File(parentJarPath));
            ClassPreventUtil.checkJar(jar);
            if (conflictJars.size() == 0) {
                return;
            }
            conflictJarList = "The following jar files conflict, please confirm:\n";
            Set<String> JarskeySet = conflictJars.keySet();
            for (String jarName : JarskeySet) {
                HashSet<String> jarTempList = conflictJars.get(jarName);
                for (String jarTemp : jarTempList) {
                    conflictJarList = conflictJarList + jarTemp + "\n";
                }
                conflictJarList = conflictJarList + "\n";
            }
        }
        catch (Exception exception) {
            return;
        }
        if (conflictJarList != null) {
            throw new Exception(conflictJarList);
        }
    }

    public static void checkJar(JarFile jar) throws Exception {
        Enumeration innerFiles = jar.entries();
        ArrayList<JarFile> depJars = new ArrayList<JarFile>();
        while (innerFiles.hasMoreElements()) {
            JarEntry jarEntryTemp = (JarEntry)innerFiles.nextElement();
            if (!jarEntryTemp.getName().endsWith(".jar")) continue;
            depJars.add(jar.getNestedJarFile((ZipEntry)jarEntryTemp));
        }
        for (JarFile jarFileTemp : depJars) {
            ClassPreventUtil.checkJar(jarFileTemp);
        }
        for (JarFile depjar : depJars) {
            ClassPreventUtil.getJarInfos(depjar);
        }
    }

    private static void getJarInfos(JarFile jar) throws Exception {
        JarInfo jarInfo = new JarInfo();
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes attributes = jar.getManifest().getMainAttributes();
        Set<Object> set = attributes.keySet();
        Object groupIdKey = null;
        Object artifactIdKey = null;
        Object versionKey = null;
        for (Object o2 : set) {
            if ("Implementation-Vendor-Id".equals(o2.toString())) {
                groupIdKey = o2;
            }
            if ("Implementation-Title".equals(o2.toString())) {
                artifactIdKey = o2;
            }
            if (!"Implementation-Version".equals(o2.toString())) continue;
            versionKey = o2;
        }
        Object groupId = attributes.get(groupIdKey);
        Object artifactId = attributes.get(artifactIdKey);
        Object version = attributes.get(versionKey);
        if (groupId != null) {
            jarInfo.setGroupId(groupId.toString());
        }
        if (artifactId != null) {
            jarInfo.setArtifactId(artifactId.toString());
        }
        if (version != null) {
            jarInfo.setVersion(version.toString());
        }
        jarInfo.setJarFile(jar);
        if (groupId != null && artifactId != null) {
            String key = groupId + "-" + artifactId;
            if (jarInfos.containsKey(key)) {
                String existJarName;
                HashSet<String> conflictJar = conflictJars.get(key);
                if (conflictJar == null) {
                    conflictJar = new HashSet();
                }
                if (!(existJarName = jarInfos.get(key).getJarFile().getName()).equals(jar.getName())) {
                    conflictJar.add(jar.getName());
                    conflictJar.add(existJarName);
                    conflictJars.put(key, conflictJar);
                }
            }
            jarInfos.put(key, jarInfo);
        }
    }
}

