/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web;

import com.bes.enterprise.appserver.common.util.FileUtils;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.appserver.common.util.SystemPropertyConstants;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import com.bes.enterprise.context.ServerContext;
import com.bes.enterprise.web.BESCoyoteConnector;
import com.bes.enterprise.web.BESWebContainer;
import com.bes.enterprise.web.VirtualHost;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import com.bes.enterprise.web.crane.http11.AbstractHttp11JsseProtocol;
import com.bes.enterprise.web.util.BeanInspectUtils;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.web.util.net.jsse.JSSEImplementation;
import com.bes.enterprise.web.util.net.openssl.OpenSSLImplementation;
import com.bes.enterprise.webtier.CredentialHandler;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.ApplicationServer;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultEngine;
import com.bes.enterprise.webtier.core.NativeLifecycleListener;
import com.bes.enterprise.webtier.core.WorkThreadExecutor;
import com.bes.enterprise.webtier.realm.DataSourceRealm;
import com.bes.enterprise.webtier.realm.JDBCRealm;
import com.bes.enterprise.webtier.realm.JNDIRealm;
import com.bes.enterprise.webtier.realm.LockOutRealm;
import com.bes.enterprise.webtier.realm.MemoryRealm;
import com.bes.enterprise.webtier.startup.BESContextConfig;
import com.bes.enterprise.webtier.startup.EngineConfig;
import com.bes.enterprise.webtier.startup.HostConfig;
import com.bes.enterprise.webtier.valves.AccessLogValve;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;

public class CloudWebContainer
extends BESWebContainer {
    protected ServerContext context;
    protected int defaultRedirectPort = -1;
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    private static final String DEFAULT_GM_KEYSTORE_TYPE = "bks";
    private static final String INSTANCE_ROOT_PROPERTY = "com.bes.installRoot";
    private static final String DEFAULT_HTTP_EXECUTOR_NAME_PREFIX = "httpWorkerThread-";
    private static final String DEFAULT_HTTPS_EXECUTOR_NAME_PREFIX = "httpSSLWorkerThread-";
    protected static SystemPropertyValueTranslator translator = SystemPropertyValueTranslator.getInstance();
    private static NativeListenerEngine nlEngine = NativeListenerEngine.NONE;
    protected HashMap<String, BESCoyoteConnector> connectorMap;

    protected CloudWebContainer(String id, ServerContext context) {
        super(id, context);
        this.context = context;
    }

    public static BESWebContainer createInstance(ServerContext context) {
        webContainer = new CloudWebContainer("0", context);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Creating new instance of PEWebContainer.");
        }
        ((CloudWebContainer)webContainer).init(context);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Initialization of PEWebContainer.");
        }
        return webContainer;
    }

    protected void init(ServerContext context) {
        this.connectorMap = new HashMap();
        try {
            DomTemplate serverBean = context.getConfigBean();
            ConfigProviderGlobals.addGlobalItem("rootConfig", serverBean);
            DomTemplate wcBean = serverBean.getElement("web-container");
            ApplicationServer server = this.createServer(serverBean);
            this._embedded.setServer(server);
            server.addService(this._embedded);
            Engine engine = this.createEngine(serverBean);
            this.createConnectors(wcBean);
            this.configEngine(engine, wcBean);
            this.createResources();
            this.loadRealms(serverBean.getElement("security-service"));
            engine.setRealm(this._embedded.getRealm(serverBean.getElement("security-service").getAttribute("default-realm")));
            boolean globalAccessLogEnabled = Boolean.valueOf(wcBean.getElement("http-service").getAttribute("global-access-log-enabled"));
            this.createHosts(wcBean, serverBean.getElement("security-service"), globalAccessLogEnabled, serverBean);
            this.cleanWorkDir(wcBean, engine.getName());
        }
        catch (Exception e2) {
            _logger.log(Level.SEVERE, "Failed to init web container!", e2);
            throw new RuntimeException(e2);
        }
    }

    protected ApplicationServer createServer(DomTemplate serverBean) {
        ApplicationServer server = new ApplicationServer();
        if (Boolean.valueOf(serverBean.getAttribute("log-version")).booleanValue()) {
            server.addLifecycleListener(this.loadListener("com.bes.enterprise.webtier.startup.VersionLoggerListener"));
        }
        if (Boolean.valueOf(serverBean.getAttribute("memory-leak-prevention")).booleanValue()) {
            server.addLifecycleListener(this.loadListener("com.bes.enterprise.webtier.core.JreMemoryLeakPreventionListener"));
        }
        if (Boolean.valueOf(serverBean.getAttribute("threadlocal-leak-prevention")).booleanValue()) {
            server.addLifecycleListener(this.loadListener("com.bes.enterprise.webtier.core.ThreadLocalLeakPreventionListener"));
        }
        server.setAddress(serverBean.getAttribute("adminhost"));
        server.setPort(Integer.parseInt(serverBean.getAttribute("adminport")));
        server.setShutdown(serverBean.getAttribute("stop"));
        server.addLifecycleListener(this.loadListener("com.bes.enterprise.webtier.mbeans.GlobalResourcesLifecycleListener"));
        server.addLifecycleListener(this.loadListener("com.bes.enterprise.webtier.util.mbeanserver.BesJmxRemoteLifecycleListener"));
        server.setHeavenBase(new File(System.getProperty("com.bes.instanceRoot")));
        server.setHeavenHome(new File(System.getProperty(INSTANCE_ROOT_PROPERTY)));
        return server;
    }

    protected void configEngine(Engine engine, DomTemplate wcBean) {
        for (DomTemplate listener : wcBean.getElements("listener")) {
            LifecycleListener lifecycleListener;
            if ("com.bes.enterprise.webtier.core.NativeLifecycleListener".equals(listener.getAttribute("class-name")) && NativeListenerEngine.NONE.equals((Object)nlEngine) || (lifecycleListener = this.loadListener(listener.getAttribute("class-name"))) == null) continue;
            BeanInspectUtils.transmitProperties((Object)lifecycleListener, listener.getElements("property"));
            if (lifecycleListener instanceof NativeLifecycleListener) {
                NativeLifecycleListener nativeLifecycleListener = (NativeLifecycleListener)lifecycleListener;
                nativeLifecycleListener.setSSLEngine(nlEngine.getName());
            }
            engine.addLifecycleListener(lifecycleListener);
        }
        for (DomTemplate valve : wcBean.getElements("valve")) {
            Valve besValve = (Valve)this.loadInstance(valve.getAttribute("class-name"));
            if (besValve == null) continue;
            BeanInspectUtils.transmitProperties((Object)besValve, valve);
            BeanInspectUtils.transmitProperties((Object)besValve, valve.getElements("property"));
            ((DefaultEngine)engine).addValve(besValve);
        }
    }

    private LifecycleListener loadListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (LifecycleListener)clazz.newInstance();
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, ex.getMessage() + ":" + className, ex);
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.context.getCommonClassLoader();
    }

    public void createConnectors(DomTemplate webContainer) {
        DomTemplate[] httpListeners = webContainer.getElements("http-listener").toArray(new DomTemplate[0]);
        DomTemplate httpListener = null;
        if (httpListeners != null) {
            try {
                for (int i2 = 0; i2 < httpListeners.length; ++i2) {
                    httpListener = httpListeners[i2];
                    if (!Boolean.valueOf(httpListener.getAttribute("enabled")).booleanValue()) continue;
                    String securityEnabled = httpListener.getAttribute("security-enabled");
                    String sslMode = httpListener.getElement("ssl").getAttribute("ssl-mode");
                    if ("APR".equals(httpListener.getAttribute("io-mode")) || Boolean.valueOf(securityEnabled).booleanValue() && "NativeSSL".equals(sslMode)) {
                        nlEngine = NativeListenerEngine.ON;
                    }
                    if (Boolean.valueOf(securityEnabled).booleanValue() && "KAE".equals(sslMode)) {
                        nlEngine = NativeListenerEngine.KAE;
                    }
                    this.createConnector(httpListener, webContainer.getElement("http-service"));
                    if (this.defaultRedirectPort != -1 || !Boolean.valueOf(securityEnabled).booleanValue()) continue;
                    this.defaultRedirectPort = Integer.parseInt(translator.getTranslatedValue(httpListener.getAttribute("port")));
                }
            }
            catch (NumberFormatException ex) {
                _logger.log(Level.SEVERE, String.format("Failed to create connector %s:" + ex.getMessage(), httpListener.getAttribute("name")), ex);
            }
        }
        this.setDefaultRedirectPort();
    }

    public BESCoyoteConnector createConnector(DomTemplate httpListener, DomTemplate httpService) {
        String jkSecret;
        String protocol;
        String address;
        int port = Integer.parseInt(translator.getTranslatedValue(httpListener.getAttribute("port")));
        boolean isSecure = Boolean.valueOf(httpListener.getAttribute("security-enabled"));
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = translator.getTranslatedValue(httpListener.getAttribute("address"))) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        if (StringUtils.isBlank(protocol = httpListener.getAttribute("protocol"))) {
            boolean isJkEnabled = Boolean.valueOf(httpListener.getAttribute("jk-enabled"));
            String ioMode = httpListener.getAttribute("io-mode");
            DomTemplate[] httpListenerProps = httpListener.getElements("property").toArray(new DomTemplate[0]);
            if (httpListenerProps != null) {
                for (int i2 = 0; i2 < httpListenerProps.length; ++i2) {
                    String propName = httpListenerProps[i2].getAttribute("name");
                    if (StringUtils.isBlank(propName) || !"io-mode".equals(propName)) continue;
                    ioMode = translator.getTranslatedValue(httpListenerProps[i2].getAttribute("value"));
                    break;
                }
            }
            switch (ioMode) {
                case "AIO": {
                    if (isJkEnabled) {
                        protocol = "com.bes.enterprise.web.crane.ajp.AjpNio2Protocol";
                        break;
                    }
                    protocol = "com.bes.enterprise.web.crane.http11.Http11Nio2Protocol";
                    break;
                }
                case "BIO": {
                    if (isJkEnabled) {
                        protocol = "com.bes.enterprise.web.crane.ajp.AjpProtocol";
                        break;
                    }
                    protocol = "com.bes.enterprise.web.crane.http11.Http11Protocol";
                    break;
                }
                default: {
                    if (isJkEnabled) {
                        protocol = "com.bes.enterprise.web.crane.ajp.AjpNioProtocol";
                        break;
                    }
                    protocol = "com.bes.enterprise.web.crane.http11.Http11NioProtocol";
                    break;
                }
                case "APR": {
                    protocol = isJkEnabled ? "com.bes.enterprise.web.crane.ajp.AjpNativeProtocol" : "com.bes.enterprise.web.crane.http11.Http11NativeProtocol";
                }
            }
        }
        BESCoyoteConnector connector = (BESCoyoteConnector)this._embedded.createConnector(address, port, protocol);
        connector.setName(httpListener.getAttribute("name"));
        if (isSecure) {
            connector.setScheme("https");
            connector.setSecure(true);
        }
        if (!StringUtils.isEmpty(jkSecret = httpListener.getAttribute("jk-secret"))) {
            connector.setJkSecret(jkSecret);
            connector.setSecretRequired(true);
        } else {
            connector.setSecretRequired(false);
        }
        this.configureConnector(connector, httpListener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{port, connector});
        }
        this._embedded.addConnector(connector);
        connector.setService(this._embedded);
        this.connectorMap.put(httpListener.getAttribute("name"), connector);
        if (connector.getRedirectPort() == -1 && this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        return connector;
    }

    private void configureConnector(BESCoyoteConnector connector, DomTemplate httpListener, boolean isSecure, DomTemplate httpService) {
        this.configureThreadPool(connector, httpListener);
        this.configureKeepAlive(connector, httpListener.getElement("keep-alive"));
        this.configureHttpProtocol(connector, httpListener.getElement("http-protocol"));
        String sslMode = httpListener.getElement("ssl").getAttribute("ssl-mode");
        if (!"APR".equals(httpListener.getAttribute("io-mode"))) {
            if (Boolean.parseBoolean(httpListener.getAttribute("security-enabled")) && ("NativeSSL".equals(sslMode) || "KAE".equals(sslMode))) {
                connector.setSslImplementationName(OpenSSLImplementation.class.getName());
            } else {
                connector.setSslImplementationName(JSSEImplementation.class.getName());
            }
        }
        if (Boolean.parseBoolean(httpListener.getAttribute("http2-enabled"))) {
            DomTemplate http2Protocol = httpListener.getElement("http2-protocol");
            http2Protocol.setAttribute("keep-alive-timeout", String.valueOf(Long.parseLong(httpListener.getElement("keep-alive").getAttribute("keep-alive-timeout")) * 1000L));
            this.configureHttp2Protocol(connector, http2Protocol);
        }
        if (httpListener.getAttribute("default-virtual-server") != null) {
            connector.setDefaultVirtualServer(httpListener.getAttribute("default-virtual-server").toLowerCase(Locale.ENGLISH));
        }
        if (httpListener.getAttribute("proxy-name") != null) {
            connector.setProxyName(httpListener.getAttribute("proxy-name"));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("proxy-port"))) {
            connector.setProxyPort(Integer.parseInt(translator.getTranslatedValue(httpListener.getAttribute("proxy-port"))));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("redirect-port"))) {
            connector.setRedirectPort(Integer.parseInt(translator.getTranslatedValue(httpListener.getAttribute("redirect-port"))));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("use-ip-vhosts"))) {
            connector.setUseIPVHosts(Boolean.valueOf(httpListener.getAttribute("use-ip-vhosts")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("accept-count"))) {
            connector.setAcceptCount(Integer.valueOf(httpListener.getAttribute("accept-count")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("acceptor-thread"))) {
            connector.setAcceptorThreadCount(Integer.valueOf(httpListener.getAttribute("acceptor-thread")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("acceptor-thread-priority"))) {
            connector.setAcceptorThreadPriority(Integer.valueOf(httpListener.getAttribute("acceptor-thread-priority")));
        }
        if (httpListener.getAttribute("address") != null) {
            connector.setAddress(String.valueOf(translator.getTranslatedValue(httpListener.getAttribute("address"))));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("bind-on-init"))) {
            connector.setBindOnInit(Boolean.valueOf(httpListener.getAttribute("bind-on-init")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("connection-linger"))) {
            connector.setConnectionLinger(Integer.valueOf(httpListener.getAttribute("connection-linger")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("connection-timeout"))) {
            connector.setConnectionTimeout(Integer.valueOf(httpListener.getAttribute("connection-timeout")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("executor-termination-timeout-millis"))) {
            connector.setExecutorTerminationTimeoutMillis(Integer.valueOf(httpListener.getAttribute("executor-termination-timeout-millis")).intValue());
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("max-connections"))) {
            connector.setMaxConnections(Integer.valueOf(httpListener.getAttribute("max-connections")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("processor-cache"))) {
            connector.setProcessorCache(Integer.valueOf(httpListener.getAttribute("processor-cache")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("socket-buffer"))) {
            connector.setSocketBuffer(Integer.valueOf(httpListener.getAttribute("socket-buffer")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("security-enabled"))) {
            connector.setSecurityEnabled(Boolean.valueOf(httpListener.getAttribute("security-enabled")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("tcp-no-delay"))) {
            connector.setTcpNoDelay(Boolean.valueOf(httpListener.getAttribute("tcp-no-delay")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("thread-priority"))) {
            connector.setThreadPriority(Integer.valueOf(httpListener.getAttribute("thread-priority")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("upgrade-async-write-buffer-size"))) {
            connector.setUpgradeAsyncWriteBufferSize(Integer.valueOf(httpListener.getAttribute("upgrade-async-write-buffer-size")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("app-read-buf-size"))) {
            connector.setAppReadBufSize(Integer.valueOf(httpListener.getAttribute("app-read-buf-size")));
        }
        if (!StringUtils.isBlank(httpListener.getAttribute("app-write-buf-size"))) {
            connector.setAppWriteBufSize(Integer.valueOf(httpListener.getAttribute("app-write-buf-size")));
        }
        if (isSecure) {
            if (Boolean.parseBoolean(httpListener.getAttribute("gmssl-enabled"))) {
                this.configureGMSSL(httpListener.getElement("gmssl"), connector);
            } else {
                this.configureSSL(httpListener.getElement("ssl"), connector);
            }
        }
        this.configureHttpListenerProperties(httpListener, connector);
    }

    protected void configureThreadPool(BESCoyoteConnector connector, DomTemplate httpListener) {
        if (httpListener.getAttribute("thread-pool") != null) {
            DomTemplate threadPool = this.findThreadForHttpListener(httpListener);
            if (threadPool == null) {
                throw new RuntimeException("Must specify thread pool for http listener " + httpListener.getAttribute("name"));
            }
            Executor executor = this.createExecutor(threadPool);
            if (executor instanceof WorkThreadExecutor) {
                StringBuilder sb = new StringBuilder();
                sb.append(Boolean.valueOf(httpListener.getAttribute("security-enabled")) != false ? DEFAULT_HTTPS_EXECUTOR_NAME_PREFIX : DEFAULT_HTTP_EXECUTOR_NAME_PREFIX);
                String port = httpListener.getAttribute("port");
                if (SystemPropertyConstants.isSystemPropertySyntax(port)) {
                    sb.append(SystemPropertyConstants.replace(port));
                } else {
                    sb.append(port);
                }
                ((WorkThreadExecutor)executor).setName(sb.toString());
                ((WorkThreadExecutor)executor).setThreadPoolName(threadPool.getAttribute("name"));
                sb.append("-");
                ((WorkThreadExecutor)executor).setNamePrefix(sb.toString());
            }
            try {
                this.setExecutor(connector, executor);
                this._embedded.addExecutor(executor);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Failed to set executor for http listener:" + ex.getMessage(), ex);
            }
        }
    }

    protected Executor createExecutor(DomTemplate connThreadPool) {
        Class tpClassName = null;
        if (connThreadPool.getAttribute("class-name") == null) {
            tpClassName = WorkThreadExecutor.class;
        } else {
            try {
                tpClassName = Class.forName(connThreadPool.getAttribute("class-name"));
            }
            catch (Exception e2) {
                _logger.log(Level.WARNING, "Failed to load " + connThreadPool.getAttribute("class-name"), ", use " + WorkThreadExecutor.class.getName() + " defaultly!");
                tpClassName = WorkThreadExecutor.class;
            }
        }
        try {
            Executor ex = (Executor)tpClassName.newInstance();
            BeanInspectUtils.transmitProperties((Object)ex, connThreadPool);
            return ex;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Failed to create executor:" + ex.getMessage(), ex);
            return null;
        }
    }

    protected DomTemplate findThreadForHttpListener(DomTemplate httpListener) {
        List<DomTemplate> threadPools = this.context.getConfigBean().getElement("thread-pools").getElements("thread-pool");
        if (threadPools == null) {
            return null;
        }
        for (DomTemplate threadPool : threadPools) {
            if (!threadPool.getAttribute("name").equals(httpListener.getAttribute("thread-pool"))) continue;
            return threadPool;
        }
        return null;
    }

    protected void configureSSL(DomTemplate ssl, BESCoyoteConnector connector) {
        DomTemplate[] sslProperties;
        String sslImplementationName;
        String sslEnabledProtocols;
        String sslProtocol;
        String clientAuth;
        String prop;
        if (ssl == null) {
            return;
        }
        SSLHostConfig defaultSSLHostConfig = new SSLHostConfig();
        if (ssl.getAttribute("cert-type").equals("CER")) {
            String keyAlias;
            String truststoreFile;
            String keystoreFile = translator.getTranslatedValue(ssl.getAttribute("keystore-file"));
            if (!StringUtils.isBlank(keystoreFile)) {
                defaultSSLHostConfig.setCertificateKeystoreFile(keystoreFile);
            } else {
                prop = System.getProperty("javax.net.ssl.keyStore");
                if (prop != null) {
                    defaultSSLHostConfig.setCertificateKeystoreFile(prop);
                }
            }
            String keystoreType = ssl.getAttribute("keystore-type");
            if (keystoreType != null) {
                defaultSSLHostConfig.setCertificateKeystoreType(keystoreType);
            } else {
                defaultSSLHostConfig.setCertificateKeystoreType("JKS");
            }
            String keystorePass = ssl.getAttribute("keystore-pass");
            if (keystorePass == null) {
                keystorePass = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (keystorePass != null) {
                defaultSSLHostConfig.setCertificateKeystorePassword(keystorePass);
            }
            if (!StringUtils.isBlank(truststoreFile = translator.getTranslatedValue(ssl.getAttribute("truststore-file")))) {
                defaultSSLHostConfig.setTruststoreFile(truststoreFile);
            } else {
                String prop2 = System.getProperty("javax.net.ssl.trustStore");
                if (prop2 != null) {
                    defaultSSLHostConfig.setTruststoreFile(prop2);
                }
            }
            String truststoreType = ssl.getAttribute("truststore-type");
            if (truststoreType != null) {
                defaultSSLHostConfig.setTruststoreType(truststoreType);
            } else {
                defaultSSLHostConfig.setTruststoreType("JKS");
            }
            String truststorePass = ssl.getAttribute("truststore-pass");
            if (truststorePass == null) {
                truststorePass = System.getProperty("javax.net.ssl.trustStorePassword");
            }
            if (truststorePass != null) {
                defaultSSLHostConfig.setTruststorePassword(truststorePass);
            }
            if ((keyAlias = ssl.getAttribute("key-alias")) != null) {
                defaultSSLHostConfig.setCertificateKeyAlias(keyAlias);
            }
        } else {
            String certificateFile = translator.getTranslatedValue(ssl.getAttribute("certificate-file"));
            if (!StringUtils.isBlank(certificateFile)) {
                defaultSSLHostConfig.setCertificateFile(certificateFile);
            } else {
                prop = System.getProperty("javax.net.ssl.certificateFile");
                if (prop != null) {
                    defaultSSLHostConfig.setCertificateFile(prop);
                }
            }
            String certificateKeyFile = translator.getTranslatedValue(ssl.getAttribute("certificate-key-file"));
            if (!StringUtils.isBlank(certificateKeyFile)) {
                defaultSSLHostConfig.setCertificateKeyFile(certificateKeyFile);
            } else {
                String prop3 = System.getProperty("javax.net.ssl.certificateKeyFile");
                if (prop3 != null) {
                    defaultSSLHostConfig.setCertificateKeyFile(prop3);
                }
            }
            String certificateChainFile = translator.getTranslatedValue(ssl.getAttribute("certificate-chain-file"));
            if (!StringUtils.isBlank(certificateChainFile)) {
                defaultSSLHostConfig.setCertificateChainFile(certificateChainFile);
            } else {
                String prop4 = System.getProperty("javax.net.ssl.certificateChainFile");
                if (prop4 != null) {
                    defaultSSLHostConfig.setCertificateChainFile(prop4);
                }
            }
        }
        String keyPass = ssl.getAttribute("key-pass");
        if (keyPass != null) {
            defaultSSLHostConfig.setCertificateKeyPassword(keyPass);
        }
        if ((clientAuth = ssl.getAttribute("client-auth")) != null) {
            defaultSSLHostConfig.setCertificateVerification(clientAuth);
        }
        if ((sslProtocol = ssl.getAttribute("ssl-protocol")) != null) {
            defaultSSLHostConfig.setSslProtocol(sslProtocol);
        }
        if ((sslEnabledProtocols = ssl.getAttribute("ssl-enabled-protocols")) != null && !sslEnabledProtocols.isEmpty()) {
            defaultSSLHostConfig.setProtocols(sslEnabledProtocols);
        } else {
            StringBuffer protocols = new StringBuffer();
            if (Boolean.parseBoolean(ssl.getAttribute("ssl3-enabled"))) {
                protocols.append("+");
                protocols.append("SSLv3");
            }
            if (Boolean.parseBoolean(ssl.getAttribute("tls-enabled"))) {
                protocols.append("+");
                protocols.append("TLSv1");
            }
            if (Boolean.parseBoolean(ssl.getAttribute("tls11-enabled"))) {
                protocols.append("+");
                protocols.append("TLSv1.1");
            }
            if (Boolean.parseBoolean(ssl.getAttribute("tls12-enabled"))) {
                protocols.append("+");
                protocols.append("TLSv1.2");
            }
            if (Boolean.parseBoolean(ssl.getAttribute("tls13-enabled"))) {
                protocols.append("+");
                protocols.append("TLSv1.3");
            }
            if (protocols.length() > 0 && protocols.charAt(0) == '+') {
                protocols.deleteCharAt(0);
            }
            defaultSSLHostConfig.setProtocols(protocols.toString());
        }
        String ciphers = ssl.getAttribute("ciphers");
        if (StringUtils.isEmpty(ciphers)) {
            ciphers = "HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!DHE:!kRSA";
        }
        defaultSSLHostConfig.setCiphers(ciphers);
        connector.addSslHostConfig(defaultSSLHostConfig);
        if (connector.getProtocolHandler() instanceof AbstractHttp11JsseProtocol) {
            AbstractHttp11JsseProtocol protocolHandler = (AbstractHttp11JsseProtocol)connector.getProtocolHandler();
            protocolHandler.setDefaultSSLHostConfigName(defaultSSLHostConfig.getHostName());
        }
        if ((sslImplementationName = ssl.getAttribute("ssl-implementation-name")) != null) {
            connector.setSslImplementationName(sslImplementationName);
        }
        if ((sslProperties = ssl.getElements("property").toArray(new DomTemplate[0])) != null) {
            for (int i2 = 0; i2 < sslProperties.length; ++i2) {
                String propName = sslProperties[i2].getAttribute("name");
                String propValue = translator.getTranslatedValue(sslProperties[i2].getAttribute("value"));
                try {
                    if (this.configureHttpListenerProperty(propName, propValue, connector) || !_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "httplistener.invalid_ssl_property", propName);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "httplistener.invalid_ssl_property", propName);
                }
            }
        }
    }

    protected void configureGMSSL(DomTemplate gmssl, BESCoyoteConnector connector) {
        String keyPass;
        String keyAlias;
        if (gmssl == null) {
            return;
        }
        SSLHostConfig defaultSSLHostConfig = new SSLHostConfig();
        String keystoreFile = translator.getTranslatedValue(gmssl.getAttribute("keystore-file"));
        if (!StringUtils.isBlank(keystoreFile)) {
            defaultSSLHostConfig.setCertificateKeystoreFile(keystoreFile);
        } else {
            String prop = System.getProperty("javax.net.ssl.keyStore");
            if (prop != null) {
                defaultSSLHostConfig.setCertificateKeystoreFile(prop);
            }
        }
        defaultSSLHostConfig.setCertificateKeystoreType(DEFAULT_GM_KEYSTORE_TYPE);
        String keystorePass = gmssl.getAttribute("keystore-pass");
        if (keystorePass == null) {
            keystorePass = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (keystorePass != null) {
            defaultSSLHostConfig.setCertificateKeystorePassword(keystorePass);
        }
        if ((keyAlias = gmssl.getAttribute("key-alias")) != null) {
            defaultSSLHostConfig.setCertificateKeyAlias(keyAlias);
        }
        if ((keyPass = gmssl.getAttribute("key-pass")) != null) {
            defaultSSLHostConfig.setCertificateKeyPassword(keyPass);
        }
        connector.addSslHostConfig(defaultSSLHostConfig);
        if (connector.getProtocolHandler() instanceof AbstractHttp11JsseProtocol) {
            AbstractHttp11JsseProtocol protocolHandler = (AbstractHttp11JsseProtocol)connector.getProtocolHandler();
            protocolHandler.setDefaultSSLHostConfigName(defaultSSLHostConfig.getHostName());
        }
        connector.setSslProtocol("GMSSL");
        String sslImplementationName = gmssl.getAttribute("ssl-implementation-name");
        if (sslImplementationName != null) {
            connector.setSslImplementationName(sslImplementationName);
        } else {
            connector.setSslImplementationName("com.bes.enterprise.gmssl.adapter.GMSSLImplementation");
        }
        DomTemplate[] sslProperties = gmssl.getElements("property").toArray(new DomTemplate[0]);
        List<String> legalAttributes = Arrays.asList("keystorePass", "keystoreFile", "keyAlias", "keyPass");
        if (sslProperties != null) {
            for (int i2 = 0; i2 < sslProperties.length; ++i2) {
                String propName = sslProperties[i2].getAttribute("name");
                String propValue = translator.getTranslatedValue(sslProperties[i2].getAttribute("value"));
                if (!legalAttributes.contains(propName)) {
                    _logger.log(Level.WARNING, "httplistener.invalid_gmssl_property", propName);
                }
                try {
                    if (this.configureHttpListenerProperty(propName, propValue, connector) || !_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "httplistener.invalid_gmssl_property", propName);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "httplistener.invalid_gmssl_property", propName);
                }
            }
        }
    }

    public void configureHttpListenerProperties(DomTemplate httpListener, BESCoyoteConnector connector) {
        DomTemplate[] httpListenerProps = httpListener.getElements("property").toArray(new DomTemplate[0]);
        if (httpListenerProps != null) {
            for (int i2 = 0; i2 < httpListenerProps.length; ++i2) {
                String propName = httpListenerProps[i2].getAttribute("name");
                String propValue = translator.getTranslatedValue(httpListenerProps[i2].getAttribute("value"));
                try {
                    if (this.configureHttpListenerProperty(propName, propValue, connector)) continue;
                    _logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    _logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
                }
            }
        }
    }

    protected boolean configureHttpListenerProperty(String propName, String propValue, BESCoyoteConnector connector) {
        connector.setProperty(propName, propValue);
        return true;
    }

    private void setDefaultRedirectPort() {
        if (this.defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i2 = 0; i2 < connectors.length; ++i2) {
                if (connectors[i2].getRedirectPort() != -1) continue;
                connectors[i2].setRedirectPort(this.defaultRedirectPort);
            }
        }
    }

    protected Engine createEngine(DomTemplate serverBean) {
        String engineName = "com.bes.appserv";
        DomTemplate securityService = this.context.getConfigBean().getElement("security-service");
        Engine engine = this._embedded.createEngine(this._embedded.getRealm(securityService.getAttribute("default-realm")));
        engine.addLifecycleListener(new EngineConfig());
        this._embedded.setContainer(engine);
        engine.setService(this._embedded);
        engine.setParentClassLoader(this.context.getSharedClassLoader());
        ((DefaultEngine)engine).setName(engineName);
        DomTemplate hotdeployConfig = serverBean.getElement("hotdeploy-config");
        if (Boolean.parseBoolean(hotdeployConfig.getAttribute("enabled"))) {
            int checkInterval = Integer.parseInt(hotdeployConfig.getAttribute("check-interval"));
            engine.setBackgroundProcessorDelay(checkInterval);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Creating Engine " + engineName);
        }
        return engine;
    }

    protected void loadRealms(DomTemplate securityService) {
        List<DomTemplate> authRealms;
        if (securityService != null && (authRealms = securityService.getElements("auth-realm")) != null) {
            for (DomTemplate authRealm : authRealms) {
                this._embedded.putIntoLoadedRealms(authRealm.getAttribute("name"), this.loadRealm(securityService, authRealm));
            }
        }
    }

    private Realm loadRealm(DomTemplate securityService, DomTemplate authRealm) {
        LockOutRealm lockOutRealm = null;
        if (securityService.getAttribute("lock-enabled") != null && Boolean.parseBoolean(securityService.getAttribute("lock-enabled"))) {
            lockOutRealm = new LockOutRealm();
            if (securityService.getAttribute("failure-count") != null) {
                lockOutRealm.setFailureCount(Integer.parseInt(securityService.getAttribute("failure-count")));
            }
            if (securityService.getAttribute("lock-out-time") != null) {
                lockOutRealm.setFailureCount(Integer.parseInt(securityService.getAttribute("lock-out-time")));
            }
        }
        try {
            if (lockOutRealm != null) {
                this.addRealm(lockOutRealm, this.loadRealm(authRealm));
                return lockOutRealm;
            }
            return this.loadRealm(authRealm);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, authRealm.getAttribute("name") + " loads fail!", ex);
            return null;
        }
    }

    private Realm loadRealm(DomTemplate authRealm) {
        Realm realm = null;
        try {
            realm = (Realm)this.getClassLoader().loadClass(authRealm.getAttribute("class-name")).newInstance();
            if (!authRealm.getElements("auth-realm").isEmpty()) {
                List<DomTemplate> childRealms = authRealm.getElements("auth-realm");
                for (DomTemplate childRealm : childRealms) {
                    this.addRealm(realm, this.loadRealm(childRealm));
                }
            }
            if (realm != null) {
                BeanInspectUtils.transmitProperties((Object)realm, authRealm);
                HashMap<String, String> realmProps = new HashMap<String, String>();
                realmProps.put("pathname", translator.getTranslatedValue(authRealm.getAttribute("pathname")));
                realmProps.put("configFile", translator.getTranslatedValue(authRealm.getAttribute("config-file")));
                if (realm instanceof JDBCRealm || realm instanceof JNDIRealm) {
                    realmProps.put("connectionURL", authRealm.getAttribute("connection-url"));
                }
                if (realm instanceof JDBCRealm || realm instanceof JNDIRealm || realm instanceof DataSourceRealm || realm instanceof MemoryRealm) {
                    CredentialHandler handler = (CredentialHandler)this.getClassLoader().loadClass(authRealm.getElement("credential-handler").getAttribute("class-name")).newInstance();
                    BeanInspectUtils.transmitProperties((Object)handler, authRealm.getElement("credential-handler"));
                    realm.setCredentialHandler(handler);
                }
                BeanInspectUtils.transmitProperties((Object)realm, realmProps);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, authRealm.getAttribute("class-name") + " loads fail!", ex);
        }
        return realm;
    }

    protected AccessLogValve loadHostAccessLog(DomTemplate acessLogBean, DomTemplate virtualServer) {
        AccessLogValve valve = new AccessLogValve();
        BeanInspectUtils.transmitProperties((Object)valve, acessLogBean);
        HashMap<String, String> accessLogProps = new HashMap<String, String>();
        for (DomTemplate property : virtualServer.getElements("property")) {
            if (!property.getAttribute("name").startsWith("accessLog")) continue;
            String value = translator.getTranslatedValue(property.getAttribute("value"));
            if ("accessLogEnabled".equals(property.getAttribute("name")) && "inherit".equals(value) || StringUtils.isBlank(value)) continue;
            accessLogProps.put(StringUtils.lowerCaseFirst(property.getAttribute("name").substring("accessLog".length())), value);
        }
        BeanInspectUtils.transmitProperties((Object)valve, accessLogProps);
        boolean rotatableByTime = Boolean.parseBoolean(acessLogBean.getAttribute("rotation-enabled"));
        valve.setRotatableByTime(rotatableByTime);
        String maxHistroyFilesVal = acessLogBean.getAttribute("max-history-files");
        int maxHistroyFiles = 10;
        if (maxHistroyFilesVal != null && !"".equals(maxHistroyFilesVal)) {
            try {
                maxHistroyFiles = Integer.parseInt(maxHistroyFilesVal);
                if (maxHistroyFiles <= 0) {
                    maxHistroyFiles = 10;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        valve.setMaxHistoryFiles(maxHistroyFiles);
        boolean rotationEnabledBySize = Boolean.parseBoolean(acessLogBean.getAttribute("rotation-enabled-by-size"));
        valve.setRotatableBySize(rotationEnabledBySize);
        if (rotationEnabledBySize) {
            String rotationSizeVal = acessLogBean.getAttribute("rotation-size");
            int rotationSize = 0xA00000;
            if (rotationSizeVal != null && !"".equals(rotationSizeVal)) {
                try {
                    rotationSize = Integer.parseInt(rotationSizeVal);
                    if (rotationSize <= 0) {
                        rotationSize = 0xA00000;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            valve.setRotationSize(rotationSize);
        }
        valve.setPattern(acessLogBean.getAttribute("format"));
        return valve;
    }

    protected void createHosts(DomTemplate httpService, DomTemplate securityService, boolean globalAccessLoggingEnabled, DomTemplate serverBean) {
        DomTemplate[] vses = httpService.getElements("virtual-server").toArray(new DomTemplate[0]);
        for (int j2 = 0; j2 < vses.length; ++j2) {
            this.createHost(httpService, securityService, vses[j2], globalAccessLoggingEnabled, serverBean);
        }
    }

    protected VirtualHost createHost(DomTemplate webcontainer, DomTemplate securityService, DomTemplate vse, boolean globalAccessLoggingEnabled, DomTemplate serverBean) {
        Engine engine = this._embedded.getContainer();
        String docroot = translator.getTranslatedValue(vse.getAttribute("app-base"));
        if (!new File(docroot).isAbsolute()) {
            docroot = new File(System.getProperty("com.bes.instanceRoot"), docroot).getAbsolutePath();
        }
        String vs_id = vse.getAttribute("name");
        VirtualHost vs = this.createVS(vs_id, vse, docroot, null);
        boolean accessLoggingEnabled = this.isAccessLoggingEnabled(vse, globalAccessLoggingEnabled);
        if (accessLoggingEnabled) {
            AccessLogValve accessLogValve = this.loadHostAccessLog(webcontainer.getElement("http-service").getElement("access-log"), vse);
            accessLogValve.setEnabled(true);
            vs.addValve(accessLogValve);
        }
        this.configureHost(vs, vse, webcontainer, securityService, serverBean.getElement("hotdeploy-config"), globalAccessLoggingEnabled);
        DomTemplate applications = serverBean.getElement("applications");
        if (applications != null) {
            String warLocation = applications.getAttribute("app-location");
            String dirLocation = applications.getAttribute("location");
            List<DomTemplate> webModules = applications.getElements("web-module");
            if (webModules != null) {
                for (DomTemplate webModule : webModules) {
                    String virtualServer = webModule.getAttribute("virtual-server");
                    if (virtualServer == null || !virtualServer.trim().equalsIgnoreCase(vs.getName()) || !Boolean.valueOf(webModule.getAttribute("enabled")).booleanValue()) continue;
                    DefaultContext context = new DefaultContext();
                    context.setName(webModule.getAttribute("name"));
                    context.setPath(webModule.getAttribute("context-root"));
                    String location = SystemPropertyValueTranslator.getInstance().getTranslatedValue(webModule.getAttribute("location"));
                    context.setDelegate(Boolean.valueOf(webModule.getAttribute("delegate")));
                    context.setDocBase(location);
                    context.setWebappVersion(webModule.getAttribute("version"));
                    BESContextConfig contextConfig = new BESContextConfig();
                    context.addLifecycleListener(contextConfig);
                    if (webModule.getElements("property") != null) {
                        BeanInspectUtils.transmitProperties((Object)context, webModule.getElements("property"));
                    }
                    vs.addChild(context);
                }
            }
        }
        engine.addChild(vs);
        vs.setParent(engine);
        vs.setParentClassLoader(this.context.getSharedClassLoader());
        return vs;
    }

    protected void configureHost(VirtualHost vs, DomTemplate vsBean, DomTemplate webcontainer, DomTemplate securityService, DomTemplate hotdeployConfig, boolean globalAccessLoggingEnabled) {
        String listeners;
        vs.configureAliases();
        Set<String> virtualServers = StringUtils.parseStringSet(hotdeployConfig.getAttribute("virtual-server"), ",");
        if (Boolean.parseBoolean(hotdeployConfig.getAttribute("enabled")) && virtualServers.contains(vsBean.getAttribute("name"))) {
            LifecycleListener listener = this.loadListener("com.bes.enterprise.webtier.startup.HostConfig");
            ((HostConfig)listener).setStatusFileCreatable(Boolean.parseBoolean(hotdeployConfig.getAttribute("status-file-creatable")));
            vs.addLifecycleListener(listener);
            vs.setAutoDeploy(true);
            vs.setAppBase(translator.getTranslatedValue(hotdeployConfig.getAttribute("directory")));
        }
        if ((listeners = vsBean.getAttribute("http-listeners")) == null) {
            return;
        }
        vs.setHttpListeners(listeners.split(","));
    }

    protected void cleanWorkDir(DomTemplate httpService, String engineName) {
        String[] childs;
        File workDir;
        List<DomTemplate> vss = httpService.getElements("virtual-server");
        LinkedList<String> vsNames = new LinkedList<String>();
        if (vss != null) {
            for (DomTemplate vs : vss) {
                vsNames.add(vs.getAttribute("name"));
            }
        }
        if ((workDir = new File(System.getProperty(INSTANCE_ROOT_PROPERTY) + File.separator + "work" + File.separator + engineName)).exists() && (childs = workDir.list()) != null) {
            for (String child : childs) {
                if (vsNames.contains(child)) continue;
                FileUtils.whack(new File(workDir, child));
            }
        }
    }

    protected boolean isAccessLoggingEnabled(DomTemplate vsBean, boolean globalAccessLoggingEnabled) {
        for (DomTemplate property : vsBean.getElements("property")) {
            if (!property.getAttribute("name").equals("accessLogEnabled")) continue;
            String value = property.getAttribute("value");
            if (StringUtils.isBlank(value)) break;
            String accessLoggingEnabled = value;
            if (accessLoggingEnabled.equals("inherit")) {
                return globalAccessLoggingEnabled;
            }
            return Boolean.parseBoolean(accessLoggingEnabled);
        }
        return true;
    }

    protected boolean validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot != null) {
            boolean isValid = new File(docroot).exists();
            if (!isValid && defaultWebModule == null) {
                String msg = _logger.getResourceBundle().getString("pewebcontainer.virtual_server.invalid_docroot");
                msg = MessageFormat.format(msg, vs_id, docroot);
                throw new IllegalArgumentException(msg);
            }
            if (!isValid) {
                _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
            }
        } else if (defaultWebModule == null) {
            String msg = _logger.getResourceBundle().getString("pewebcontainer.virtual_server.missing_docroot");
            msg = MessageFormat.format(msg, vs_id);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    public static CloudWebContainer getPEWebContainer() {
        return (CloudWebContainer)webContainer;
    }

    private void configureKeepAlive(BESCoyoteConnector connector, DomTemplate keepAlive) {
        if (keepAlive == null) {
            return;
        }
        String timeoutInSeconds = keepAlive.getAttribute("keep-alive-timeout");
        String maxConnections = keepAlive.getAttribute("max-keep-alive-requests");
        if (!StringUtils.isBlank(timeoutInSeconds)) {
            connector.setKeepAliveTimeout(Integer.parseInt(timeoutInSeconds) * 1000);
        }
        if (!StringUtils.isBlank(maxConnections)) {
            connector.setMaxKeepAliveRequests(Integer.parseInt(maxConnections));
        }
    }

    private void configureHttpProtocol(BESCoyoteConnector connector, DomTemplate httpProtocol) {
        DomTemplate[] httProtocolProps;
        if (httpProtocol == null) {
            return;
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("allow-trace"))) {
            connector.setAllowTrace(Boolean.parseBoolean(httpProtocol.getAttribute("allow-trace")));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("async-timeout"))) {
            connector.setAsyncTimeout(Long.parseLong(httpProtocol.getAttribute("async-timeout")));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("dns-lookup-enabled"))) {
            connector.setEnableLookups(Boolean.parseBoolean(httpProtocol.getAttribute("dns-lookup-enabled")));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("max-parameter-count"))) {
            connector.setMaxParameterCount(Integer.parseInt(httpProtocol.getAttribute("max-parameter-count")));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("max-post-size"))) {
            connector.setMaxPostSize(Integer.parseInt(httpProtocol.getAttribute("max-post-size")));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("xpowered-by"))) {
            connector.setXpoweredBy(Boolean.valueOf(httpProtocol.getAttribute("xpowered-by")));
        }
        if (httpProtocol.getAttribute("uri-encoding") != null) {
            connector.setURIEncoding(httpProtocol.getAttribute("uri-encoding"));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("request-character-encoding"))) {
            connector.setDefaultRequestCharacterEncoding(String.valueOf(httpProtocol.getAttribute("request-character-encoding")));
        }
        if (!StringUtils.isBlank(httpProtocol.getAttribute("response-character-encoding"))) {
            connector.setDefaultResponseCharacterEncoding(String.valueOf(httpProtocol.getAttribute("response-character-encoding")));
        }
        if ((httProtocolProps = httpProtocol.getElements("property").toArray(new DomTemplate[0])) != null) {
            for (DomTemplate property : httProtocolProps) {
                if ("useBodyEncodingForURI".equals(property.getAttribute("name"))) {
                    connector.setUseBodyEncodingForURI(Boolean.parseBoolean(property.getAttribute("value")));
                }
                if ("requestCharacterEncoding".equals(property.getAttribute("name"))) {
                    connector.setDefaultRequestCharacterEncoding(property.getAttribute("value"));
                }
                if ("responseCharacterEncoding".equals(property.getAttribute("name"))) {
                    connector.setDefaultResponseCharacterEncoding(property.getAttribute("value"));
                }
                if ("maxPartCount".equals(property.getAttribute("name"))) {
                    connector.setMaxPartCount(Integer.parseInt(property.getAttribute("value")));
                }
                if (!"maxPartHeaderSize".equals(property.getAttribute("name"))) continue;
                connector.setMaxPartHeaderSize(Integer.parseInt(property.getAttribute("value")));
            }
        }
        if (httpProtocol.getAttribute("compressible-mime-type") != null) {
            connector.setCompressibleMimeType(httpProtocol.getAttribute("compressible-mime-type"));
        }
        if (httpProtocol.getAttribute("compression") != null) {
            connector.setCompression(httpProtocol.getAttribute("compression"));
        }
        if (httpProtocol.getAttribute("compression-min-size") != null) {
            connector.setCompressionMinSize(httpProtocol.getAttribute("compression-min-size"));
        }
        if (httpProtocol.getAttribute("no-compression-user-agents") != null) {
            connector.setNoCompressionUserAgents(httpProtocol.getAttribute("no-compression-user-agents"));
        }
        if (httpProtocol.getAttribute("connection-upload-timeout") != null) {
            connector.setConnectionUploadTimeout(httpProtocol.getAttribute("connection-upload-timeout"));
        }
        if (httpProtocol.getAttribute("disable-upload-timeout") != null) {
            connector.setDisableUploadTimeout(httpProtocol.getAttribute("disable-upload-timeout"));
        }
        if (httpProtocol.getAttribute("restricted-user-agents") != null) {
            connector.setRestrictedUserAgents(httpProtocol.getAttribute("restricted-user-agents"));
        }
        if (httpProtocol.getAttribute("use-keep-alive-response-header") != null) {
            connector.setUseKeepAliveResponseHeader(httpProtocol.getAttribute("use-keep-alive-response-header"));
        }
    }

    private void configureHttp2Protocol(BESCoyoteConnector connector, DomTemplate http2Protocol) {
        UpgradeProtocol upgradeProtocol = null;
        String className = http2Protocol.getAttribute("class-name");
        try {
            Class<?> clazz = Class.forName(className);
            upgradeProtocol = (UpgradeProtocol)clazz.newInstance();
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, ex.getMessage() + ":" + className, ex);
            return;
        }
        BeanInspectUtils.transmitProperties((Object)upgradeProtocol, http2Protocol);
        connector.addUpgradeProtocol(upgradeProtocol);
    }

    public synchronized void addConnector(Connector connector) {
        this._embedded.addConnector(connector);
    }

    static enum NativeListenerEngine {
        NONE("none"),
        ON("on"),
        KAE("kae");

        private String name;

        private NativeListenerEngine(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

