/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.ajp;

import com.bes.enterprise.web.crane.AbstractProtocol;
import com.bes.enterprise.web.crane.Processor;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import com.bes.enterprise.web.crane.UpgradeToken;
import com.bes.enterprise.web.crane.ajp.AjpProcessor;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import java.util.regex.Pattern;

public abstract class AbstractAjpProtocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractAjpProtocol.class);
    protected boolean ajpFlush = true;
    private boolean appServerAuthentication = true;
    private boolean appServerAuthorization = false;
    private String requiredSecret = null;
    private Pattern allowedRequestAttributesPattern;
    private int packetSize = 8192;

    public AbstractAjpProtocol(AbstractEndpoint<S, ?> endpoint) {
        super(endpoint);
        this.setConnectionTimeout(-1);
        this.getEndpoint().setUseSendfile(false);
        AbstractProtocol.ConnectionHandler cHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(cHandler);
        this.getEndpoint().setHandler(cHandler);
    }

    @Override
    protected String getProtocolName() {
        return "Ajp";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    @Override
    protected UpgradeProtocol getNegotiatedProtocol(String name) {
        return null;
    }

    @Override
    protected UpgradeProtocol getUpgradeProtocol(String name) {
        return null;
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean ajpFlush) {
        this.ajpFlush = ajpFlush;
    }

    public boolean getAppServerAuthentication() {
        return this.appServerAuthentication;
    }

    public void setAppServerAuthentication(boolean appServerAuthentication) {
        this.appServerAuthentication = appServerAuthentication;
    }

    public boolean getAppServerAuthorization() {
        return this.appServerAuthorization;
    }

    public void setAppServerAuthorization(boolean appServerAuthorization) {
        this.appServerAuthorization = appServerAuthorization;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public void setAllowedRequestAttributesPattern(String allowedRequestAttributesPattern) {
        this.allowedRequestAttributesPattern = Pattern.compile(allowedRequestAttributesPattern);
    }

    public String getAllowedRequestAttributesPattern() {
        return this.allowedRequestAttributesPattern.pattern();
    }

    protected Pattern getAllowedRequestAttributesPatternInternal() {
        return this.allowedRequestAttributesPattern;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize < 8192 ? 8192 : packetSize;
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.getLog().warn(sm.getString("ajpprotocol.noSSL", sslHostConfig.getHostName()));
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return new SSLHostConfig[0];
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.getLog().warn(sm.getString("ajpprotocol.noUpgrade", upgradeProtocol.getClass().getName()));
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return new UpgradeProtocol[0];
    }

    @Override
    protected Processor createProcessor() {
        AjpProcessor processor = new AjpProcessor(this.getPacketSize(), this.getEndpoint());
        processor.setAdapter(this.getAdapter());
        processor.setAjpFlush(this.getAjpFlush());
        processor.setAppServerAuthentication(this.getAppServerAuthentication());
        processor.setAppServerAuthorization(this.getAppServerAuthorization());
        processor.setRequiredSecret(this.requiredSecret);
        processor.setKeepAliveTimeout(this.getKeepAliveTimeout());
        processor.setClientCertProvider(this.getClientCertProvider());
        processor.setSendReasonPhrase(this.getSendReasonPhrase());
        processor.setAllowedRequestAttributesPattern(this.getAllowedRequestAttributesPatternInternal());
        return processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socket, UpgradeToken upgradeToken) {
        throw new IllegalStateException(sm.getString("ajpprotocol.noUpgradeHandler", upgradeToken.getHttpUpgradeHandler().getClass().getName()));
    }
}

