/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.InputBuffer;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.http11.InputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.http.HeaderUtil;
import com.bes.enterprise.web.util.http.MimeHeaders;
import com.bes.enterprise.web.util.http.parser.HttpParser;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class Http11InputBuffer
implements InputBuffer {
    private static final Log log = LogFactory.getLog(Http11InputBuffer.class);
    private static final StringManager sm = StringManager.getManager(Http11InputBuffer.class);
    private static final byte[] CLIENT_PREFACE_START = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    public static boolean strictRequestURI = Boolean.getBoolean("com.bes.enterprise.web.strictRequestURI");
    public static boolean checkInvalidCharacterInURI = Boolean.getBoolean("com.bes.enterprise.web.checkInvalidURI");
    public static boolean ignoreSpaceInURI = Boolean.getBoolean("com.bes.enterprise.web.ignoreSpaceInURI");
    private final Request request;
    private final MimeHeaders headers;
    private final boolean rejectIllegalHeader;
    private boolean parsingHeader;
    private boolean swallowInput;
    private byte[] buf;
    private int lastValid;
    private int pos;
    private int end;
    private SocketWrapperBase<?> wrapper;
    private InputBuffer inputStreamInputBuffer;
    private InputFilter[] filterLibrary;
    private InputFilter[] activeFilters;
    private int lastActiveFilter;
    private byte prevChr = 0;
    private byte chr = 0;
    private boolean parsingRequestLine;
    private int parsingRequestLinePhase = 0;
    private boolean parsingRequestLineEol = false;
    private int parsingRequestLineStart = 0;
    private int parsingRequestLineQPos = -1;
    private HeaderParsePosition headerParsePos;
    private final HeaderParseData headerData = new HeaderParseData();
    private final HttpParser httpParser;
    private final int headerBufferSize;
    private int socketReadBufferSize;

    public Http11InputBuffer(Request request, int headerBufferSize, boolean rejectIllegalHeader, HttpParser httpParser) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.headerBufferSize = headerBufferSize;
        this.rejectIllegalHeader = rejectIllegalHeader;
        this.httpParser = httpParser;
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.swallowInput = true;
        this.inputStreamInputBuffer = new SocketInputBuffer();
    }

    void addFilter(InputFilter filter) {
        if (filter == null) {
            throw new NullPointerException(sm.getString("iib.filter.npe"));
        }
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i2 = 0; i2 < this.filterLibrary.length; ++i2) {
            newFilterLibrary[i2] = this.filterLibrary[i2];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    boolean isChunking() {
        for (int i2 = 0; i2 < this.lastActiveFilter; ++i2) {
            if (this.activeFilters[i2] != this.filterLibrary[1]) continue;
            return true;
        }
        return false;
    }

    void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i2 = 0; i2 <= this.lastActiveFilter; ++i2) {
                if (this.activeFilters[i2] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    @Override
    @Deprecated
    public int doRead(ByteChunk chunk) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk);
    }

    void recycle() {
        this.wrapper = null;
        this.request.recycle();
        for (int i2 = 0; i2 <= this.lastActiveFilter; ++i2) {
            this.activeFilters[i2].recycle();
        }
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0 && this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.lastValid - this.pos);
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        for (int i2 = 0; i2 <= this.lastActiveFilter; ++i2) {
            this.activeFilters[i2].recycle();
        }
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    boolean parseRequestLine(boolean keptAlive, int connectionTimeout, int keepAliveTimeout) throws IOException {
        boolean space;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase < 2) {
            do {
                if (this.pos >= this.lastValid) {
                    if (keptAlive) {
                        this.wrapper.setReadTimeout(keepAliveTimeout);
                    }
                    if (!this.fill(false)) {
                        this.parsingRequestLinePhase = 1;
                        return false;
                    }
                    this.wrapper.setReadTimeout(connectionTimeout);
                }
                if (!keptAlive && this.pos == 0 && this.lastValid >= CLIENT_PREFACE_START.length - 1) {
                    boolean prefaceMatch = true;
                    for (int i2 = 0; i2 < CLIENT_PREFACE_START.length && prefaceMatch; ++i2) {
                        if (CLIENT_PREFACE_START[i2] == this.buf[i2]) continue;
                        prefaceMatch = false;
                    }
                    if (prefaceMatch) {
                        this.parsingRequestLinePhase = -1;
                        return false;
                    }
                }
                if (this.request.getStartTime() < 0L) {
                    this.request.setStartTime(System.currentTimeMillis());
                }
                this.chr = this.buf[this.pos++];
            } while (this.chr == 13 || this.chr == 10);
            --this.pos;
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 2;
            if (log.isDebugEnabled()) {
                log.debug("Received [" + new String(this.buf, this.pos, this.lastValid - this.pos, StandardCharsets.ISO_8859_1) + "]");
            }
        }
        if (this.parsingRequestLinePhase == 2) {
            space = false;
            while (!space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space = true;
                    this.request.method().setBytes(this.buf, this.parsingRequestLineStart, this.pos - this.parsingRequestLineStart);
                } else if (!HttpParser.isToken(this.buf[this.pos])) {
                    this.request.protocol().setString("HTTP/1.1");
                    String invalidMethodValue = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                    throw new IllegalArgumentException(sm.getString("iib.invalidmethod", invalidMethodValue));
                }
                ++this.pos;
            }
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            int end = 0;
            boolean space2 = false;
            while (!space2) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                int position = this.pos;
                this.prevChr = this.chr;
                this.chr = this.buf[this.pos];
                if (this.prevChr == 13 && this.chr != 10) {
                    this.request.protocol().setString("HTTP/1.1");
                    String invalidRequestTarget = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                    throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", invalidRequestTarget));
                }
                if (this.chr == 32 || this.chr == 9) {
                    if (ignoreSpaceInURI) {
                        if (HttpParser.isHttpProtocol(this.buf[this.pos + 1]) && HttpParser.isHttpProtocol(this.buf[this.pos + 2]) && HttpParser.isHttpProtocol(this.buf[this.pos + 3]) && HttpParser.isHttpProtocol(this.buf[this.pos + 4])) {
                            space2 = true;
                            end = position;
                        } else {
                            space2 = false;
                        }
                    } else {
                        space2 = true;
                        end = position;
                    }
                } else if (this.chr != 13) {
                    if (this.chr == 10) {
                        space2 = true;
                        this.request.protocol().setString("");
                        this.parsingRequestLinePhase = 7;
                        end = this.prevChr == 13 ? position - 1 : position;
                    } else if (this.chr == 63 && this.parsingRequestLineQPos == -1) {
                        this.parsingRequestLineQPos = position;
                    } else {
                        if (checkInvalidCharacterInURI && this.parsingRequestLineQPos != -1 && !this.httpParser.isQueryRelaxed(this.chr)) {
                            this.request.protocol().setString("HTTP/1.1");
                            String invalidRequestTarget = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                            throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", invalidRequestTarget));
                        }
                        if (strictRequestURI && this.httpParser.isNotRequestTargetRelaxed(this.chr)) {
                            this.request.protocol().setString("HTTP/1.1");
                            String invalidRequestTarget = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                            throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", invalidRequestTarget));
                        }
                    }
                }
                ++this.pos;
            }
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.buf, this.parsingRequestLineQPos + 1, end - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            }
            if (this.parsingRequestLinePhase == 4) {
                this.parsingRequestLinePhase = 5;
            }
        }
        if (this.parsingRequestLinePhase == 5) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 6;
            this.end = 0;
        }
        if (this.parsingRequestLinePhase == 6) {
            while (!this.parsingRequestLineEol) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                int position = this.pos;
                this.prevChr = this.chr;
                this.chr = this.buf[this.pos];
                if (this.chr != 13) {
                    if (this.prevChr == 13 && this.chr == 10) {
                        this.end = position - 1;
                        this.parsingRequestLineEol = true;
                    } else if (this.chr == 10) {
                        this.end = position;
                        this.parsingRequestLineEol = true;
                    } else if (!HttpParser.isHttpProtocol(this.chr)) {
                        String invalidProtocol = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                        throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol", invalidProtocol));
                    }
                }
                ++this.pos;
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.buf, this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
                this.parsingRequestLinePhase = 7;
            }
        }
        if (this.parsingRequestLinePhase == 7) {
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException(sm.getString("iib.invalidPhase", this.parsingRequestLinePhase));
    }

    private String parseInvalid(int startPos, byte[] buffer) {
        int b2 = 0;
        while (this.pos < buffer.length && b2 != 32) {
            b2 = buffer[this.pos];
            ++this.pos;
        }
        String result = HeaderUtil.toPrintableString(buffer, startPos, this.pos - startPos - 1);
        if (b2 != 32) {
            result = result + "...";
        }
        return result;
    }

    boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        HeaderParseStatus status = HeaderParseStatus.HAVE_MORE_HEADERS;
        do {
            status = this.parseHeader();
            if (this.pos <= this.headerBufferSize && this.buf.length - this.pos >= this.socketReadBufferSize) continue;
            throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
        } while (status == HeaderParseStatus.HAVE_MORE_HEADERS);
        if (status == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.pos;
            return true;
        }
        return false;
    }

    int getParsingRequestLinePhase() {
        return this.parsingRequestLinePhase;
    }

    void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    int available(boolean read) {
        int available = this.lastValid - this.pos;
        if (available == 0 && this.lastActiveFilter >= 0) {
            for (int i2 = 0; available == 0 && i2 <= this.lastActiveFilter; ++i2) {
                available = this.activeFilters[i2].available();
            }
        }
        if (available > 0 || !read) {
            return available;
        }
        try {
            if (this.wrapper.hasDataToRead()) {
                this.fill(false);
                available = this.lastValid - this.pos;
            }
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("iib.available.readFail"), ioe);
            }
            available = 1;
        }
        return available;
    }

    boolean isFinished() {
        if (this.lastValid > this.pos) {
            return false;
        }
        if (this.lastActiveFilter >= 0) {
            return this.activeFilters[this.lastActiveFilter].isFinished();
        }
        return false;
    }

    ByteBuffer getLeftover() {
        int available = this.lastValid - this.pos;
        if (available > 0) {
            return ByteBuffer.wrap(this.buf, this.pos, available);
        }
        return null;
    }

    void init(SocketWrapperBase<?> socketWrapper) {
        this.wrapper = socketWrapper;
        int bufLength = this.headerBufferSize + this.wrapper.getSocketBufferHandler().getReadBuffer().capacity();
        if (this.buf == null || this.buf.length < bufLength) {
            this.buf = new byte[bufLength];
        }
    }

    private boolean fill(boolean block) throws IOException {
        int nRead;
        if (this.parsingHeader) {
            if (this.lastValid >= this.headerBufferSize) {
                if (this.parsingRequestLine) {
                    this.request.protocol().setString("HTTP/1.1");
                }
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
        } else {
            this.lastValid = this.pos = this.end;
        }
        if ((nRead = this.wrapper.read(block, this.buf, this.pos, this.buf.length - this.pos)) > 0) {
            this.lastValid = this.pos + nRead;
            return true;
        }
        if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return false;
    }

    private HeaderParseStatus parseHeader() throws IOException {
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13 || this.prevChr == 13) {
                if (this.chr == 10) {
                    ++this.pos;
                    return HeaderParseStatus.DONE;
                }
                if (this.prevChr != 13) break;
                --this.pos;
                break;
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.start = this.pos;
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            int position = this.pos;
            this.chr = this.buf[this.pos];
            if (this.chr == 58) {
                if (this.headerData.start == this.pos) {
                    return this.skipLine(false);
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
                this.headerData.headerValue = this.headers.addValue(this.buf, this.headerData.start, position - this.headerData.start);
                ++this.pos;
                this.headerData.start = position = this.pos;
                this.headerData.realPos = position;
                this.headerData.lastSignificantChar = position;
                break;
            }
            if (!HttpParser.isToken(this.chr)) {
                this.headerData.lastSignificantChar = position;
                return this.skipLine(false);
            }
            if (this.chr >= 65 && this.chr <= 90) {
                this.buf[this.pos] = (byte)(this.chr - -32);
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_SKIPLINE) {
            return this.skipLine(false);
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START || this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START) {
                while (true) {
                    if (this.pos >= this.lastValid && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.chr = this.buf[this.pos];
                    if (this.chr != 32 && this.chr != 9) break;
                    ++this.pos;
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
            }
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                boolean eol = false;
                while (!eol) {
                    if (this.pos >= this.lastValid && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.prevChr = this.chr;
                    this.chr = this.buf[this.pos];
                    if (this.chr != 13) {
                        if (this.chr == 10) {
                            eol = true;
                        } else {
                            if (this.prevChr == 13) {
                                return this.skipLine(true);
                            }
                            if (HttpParser.isControl(this.chr) && this.chr != 9) {
                                return this.skipLine(true);
                            }
                            if (this.chr == 32 || this.chr == 9) {
                                this.buf[this.headerData.realPos] = this.chr;
                                ++this.headerData.realPos;
                            } else {
                                this.buf[this.headerData.realPos] = this.chr;
                                this.headerData.lastSignificantChar = ++this.headerData.realPos;
                            }
                        }
                    }
                    ++this.pos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            byte peek = this.buf[this.pos];
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (peek != 32 && peek != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                break;
            }
            this.buf[this.headerData.realPos] = peek;
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
        }
        this.headerData.headerValue.setBytes(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    private HeaderParseStatus skipLine(boolean deleteHeader) throws IOException {
        boolean rejectThisHeader = this.rejectIllegalHeader;
        if (!rejectThisHeader && deleteHeader) {
            if (this.headers.getName(this.headers.size() - 1).equalsIgnoreCase("content-length")) {
                rejectThisHeader = true;
            } else {
                this.headers.removeHeader(this.headers.size() - 1);
            }
        }
        this.headerParsePos = HeaderParsePosition.HEADER_SKIPLINE;
        boolean eol = false;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            int position = this.pos;
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13) {
                if (this.chr == 10) {
                    eol = true;
                } else {
                    this.headerData.lastSignificantChar = position;
                }
            }
            ++this.pos;
        }
        if (rejectThisHeader || log.isDebugEnabled()) {
            String message = sm.getString("iib.invalidheader.reject", HeaderUtil.toPrintableString(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start + 1));
            if (rejectThisHeader) {
                throw new IllegalArgumentException(message);
            }
            log.debug(message);
        }
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    private class SocketInputBuffer
    implements InputBuffer {
        private SocketInputBuffer() {
        }

        @Override
        @Deprecated
        public int doRead(ByteChunk chunk) throws IOException {
            if (Http11InputBuffer.this.pos >= Http11InputBuffer.this.lastValid && !Http11InputBuffer.this.fill(true)) {
                return -1;
            }
            int length = Http11InputBuffer.this.lastValid - Http11InputBuffer.this.pos;
            chunk.setBytes(Http11InputBuffer.this.buf, Http11InputBuffer.this.pos, length);
            Http11InputBuffer.this.pos = Http11InputBuffer.this.lastValid;
            return length;
        }
    }

    private static class HeaderParseData {
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        private HeaderParseData() {
        }

        public void recycle() {
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    private static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE_START,
        HEADER_VALUE,
        HEADER_MULTI_LINE,
        HEADER_SKIPLINE;

    }

    private static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

