/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11.filters;

import com.bes.enterprise.web.crane.InputBuffer;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.http11.InputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BufferedInputFilter
implements InputFilter {
    private static final String ENCODING_NAME = "buffered";
    private static final ByteChunk ENCODING = new ByteChunk();
    private ByteChunk buffered;
    private final ByteChunk tempRead = new ByteChunk(1024);
    private InputBuffer buffer;
    private boolean hasRead = false;

    public void setLimit(int limit) {
        if (this.buffered == null) {
            this.buffered = new ByteChunk(4096);
            this.buffered.setLimit(limit);
        }
    }

    @Override
    public void setRequest(Request request) {
        try {
            while (this.buffer.doRead(this.tempRead) >= 0) {
                this.buffered.append(this.tempRead);
                this.tempRead.recycle();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Request body too large for buffer");
        }
    }

    @Override
    public int doRead(ByteChunk chunk) throws IOException {
        if (this.hasRead || this.buffered.getLength() <= 0) {
            return -1;
        }
        chunk.setBytes(this.buffered.getBytes(), this.buffered.getStart(), this.buffered.getLength());
        this.hasRead = true;
        return chunk.getLength();
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void recycle() {
        if (this.buffered != null) {
            if (this.buffered.getBuffer().length > 65536) {
                this.buffered = null;
            } else {
                this.buffered.recycle();
            }
        }
        this.tempRead.recycle();
        this.hasRead = false;
        this.buffer = null;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    @Override
    public long end() throws IOException {
        return 0L;
    }

    @Override
    public int available() {
        return this.buffered.getLength();
    }

    @Override
    public boolean isFinished() {
        return this.hasRead || this.buffered.getLength() <= 0;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(StandardCharsets.ISO_8859_1), 0, ENCODING_NAME.length());
    }
}

