/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11.filters;

import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.crane.http11.HttpOutputBuffer;
import com.bes.enterprise.web.crane.http11.OutputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.HexUtils;
import java.io.IOException;

public class ChunkedOutputFilter
implements OutputFilter {
    protected static final ByteChunk END_CHUNK = new ByteChunk();
    protected HttpOutputBuffer buffer;
    protected final byte[] chunkLength = new byte[10];
    protected final ByteChunk chunkHeader = new ByteChunk();

    public ChunkedOutputFilter() {
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    @Override
    public int doWrite(ByteChunk chunk) throws IOException {
        int result = chunk.getLength();
        if (result <= 0) {
            return 0;
        }
        int pos = 7;
        for (int current = result; current > 0; current /= 16) {
            int digit = current % 16;
            this.chunkLength[pos--] = HexUtils.getHex(digit);
        }
        this.chunkHeader.setBytes(this.chunkLength, pos + 1, 9 - pos);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(chunk);
        this.chunkHeader.setBytes(this.chunkLength, 8, 2);
        this.buffer.doWrite(this.chunkHeader);
        return result;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(HttpOutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        this.buffer.doWrite(END_CHUNK);
        this.buffer.end();
    }

    @Override
    public void recycle() {
    }

    static {
        byte[] END_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
        END_CHUNK.setBytes(END_CHUNK_BYTES, 0, END_CHUNK_BYTES.length);
    }
}

