/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.bcel.classfile;

import com.bes.enterprise.web.util.bcel.classfile.ClassFormatException;
import com.bes.enterprise.web.util.bcel.classfile.ConstantClass;
import com.bes.enterprise.web.util.bcel.classfile.ConstantDouble;
import com.bes.enterprise.web.util.bcel.classfile.ConstantFloat;
import com.bes.enterprise.web.util.bcel.classfile.ConstantInteger;
import com.bes.enterprise.web.util.bcel.classfile.ConstantLong;
import com.bes.enterprise.web.util.bcel.classfile.ConstantUtf8;
import com.bes.enterprise.web.util.bcel.classfile.Utility;
import java.io.DataInput;
import java.io.IOException;

public abstract class Constant {
    protected final byte tag;

    Constant(byte tag) {
        this.tag = tag;
    }

    public final byte getTag() {
        return this.tag;
    }

    static Constant readConstant(DataInput dataInput) throws IOException, ClassFormatException {
        int skipSize;
        byte b2 = dataInput.readByte();
        switch (b2) {
            case 7: {
                return new ConstantClass(dataInput);
            }
            case 3: {
                return new ConstantInteger(dataInput);
            }
            case 4: {
                return new ConstantFloat(dataInput);
            }
            case 5: {
                return new ConstantLong(dataInput);
            }
            case 6: {
                return new ConstantDouble(dataInput);
            }
            case 1: {
                return ConstantUtf8.getInstance(dataInput);
            }
            case 8: 
            case 16: 
            case 19: 
            case 20: {
                skipSize = 2;
                break;
            }
            case 15: {
                skipSize = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                skipSize = 4;
                break;
            }
            default: {
                throw new ClassFormatException("Invalid byte tag in constant pool: " + b2);
            }
        }
        Utility.skipFully(dataInput, skipSize);
        return null;
    }

    public String toString() {
        return "[" + this.tag + "]";
    }
}

