/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.compat;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.compat.Jre16Compat;
import com.bes.enterprise.web.util.res.StringManager;
import java.lang.reflect.Field;

public class Jre19Compat
extends Jre16Compat {
    private static final Log log = LogFactory.getLog(Jre16Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre19Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public Object getExecutor(Thread thread) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object result = super.getExecutor(thread);
        if (result == null) {
            Object holder = null;
            Object task = null;
            try {
                Field holderField = thread.getClass().getDeclaredField("holder");
                holderField.setAccessible(true);
                holder = holderField.get(thread);
                Field taskField = holder.getClass().getDeclaredField("task");
                taskField.setAccessible(true);
                task = taskField.get(holder);
            }
            catch (NoSuchFieldException nfe) {
                return null;
            }
            if (task != null && task.getClass().getCanonicalName() != null && (task.getClass().getCanonicalName().equals("com.bes.enterprise.web.util.threads.ThreadPoolExecutor.Worker") || task.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker"))) {
                Field executorField = task.getClass().getDeclaredField("this$0");
                executorField.setAccessible(true);
                result = executorField.get(task);
            }
        }
        return result;
    }

    static {
        Class<?> c1 = null;
        try {
            c1 = Class.forName("java.lang.WrongThreadException");
        }
        catch (ClassNotFoundException cnfe) {
            log.debug(sm.getString("jre19Compat.javaPre19"), cnfe);
        }
        supported = c1 != null;
    }
}

