/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.compat;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.compat.Jre16Compat;
import com.bes.enterprise.web.util.compat.Jre19Compat;
import com.bes.enterprise.web.util.res.StringManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Jre21Compat
extends Jre19Compat {
    private static final Log log = LogFactory.getLog(Jre16Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre21Compat.class);
    private static final Method nameMethod;
    private static final Method startMethod;
    private static final Method ofVirtualMethod;

    static boolean isSupported() {
        return ofVirtualMethod != null;
    }

    @Override
    public Object createVirtualThreadBuilder(String name) {
        try {
            Object threadBuilder = ofVirtualMethod.invoke(null, (Object[])null);
            nameMethod.invoke(threadBuilder, name, 0L);
            return threadBuilder;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e2) {
            throw new UnsupportedOperationException(e2);
        }
    }

    @Override
    public void threadBuilderStart(Object threadBuilder, Runnable command) {
        try {
            startMethod.invoke(threadBuilder, command);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e2) {
            throw new UnsupportedOperationException(e2);
        }
    }

    static {
        Class<?> c1 = null;
        Method m1 = null;
        Method m2 = null;
        Method m3 = null;
        try {
            c1 = Class.forName("java.lang.Thread$Builder");
            m1 = c1.getMethod("name", String.class, Long.TYPE);
            m2 = c1.getMethod("start", Runnable.class);
            m3 = Thread.class.getMethod("ofVirtual", null);
        }
        catch (ClassNotFoundException e2) {
            log.debug(sm.getString("jre21Compat.javaPre21"), e2);
        }
        catch (ReflectiveOperationException e3) {
            log.error(sm.getString("jre21Compat.unexpected"), e3);
        }
        nameMethod = m1;
        startMethod = m2;
        ofVirtualMethod = m3;
    }
}

