/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.compat;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.compat.JreCompat;
import com.bes.enterprise.web.util.res.StringManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLParameters;

class Jre8Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre8Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre8Compat.class);
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Constructor<?> domainLoadStoreParameterConstructor;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLParameters sslParameters, boolean useCipherSuitesOrder) {
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sslParameters, useCipherSuitesOrder);
        }
        catch (IllegalArgumentException e2) {
            throw new UnsupportedOperationException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new UnsupportedOperationException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new UnsupportedOperationException(e4);
        }
    }

    @Override
    public KeyStore.LoadStoreParameter getDomainLoadStoreParameter(URI uri) {
        try {
            return (KeyStore.LoadStoreParameter)domainLoadStoreParameterConstructor.newInstance(uri, Collections.EMPTY_MAP);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e2) {
            throw new UnsupportedOperationException(e2);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    static {
        Method m1 = null;
        Constructor<?> c2 = null;
        try {
            Class<?> clazz1 = Class.forName("javax.net.ssl.SSLParameters");
            m1 = clazz1.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            Class<?> clazz2 = Class.forName("java.security.DomainLoadStoreParameter");
            c2 = clazz2.getConstructor(URI.class, Map.class);
        }
        catch (SecurityException e2) {
            log.error(sm.getString("jre8Compat.unexpected"), e2);
        }
        catch (NoSuchMethodException e3) {
            if (m1 == null) {
                log.debug(sm.getString("jre8Compat.javaPre8"), e3);
            } else {
                log.error(sm.getString("jre8Compat.unexpected"), e3);
            }
        }
        catch (ClassNotFoundException e4) {
            log.error(sm.getString("jre8Compat.unexpected"), e4);
        }
        setUseCipherSuitesOrderMethod = m1;
        domainLoadStoreParameterConstructor = c2;
    }
}

