/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.descriptor.tld;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.descriptor.Constants;
import com.bes.enterprise.web.util.descriptor.DigesterFactory;
import com.bes.enterprise.web.util.descriptor.XmlErrorHandler;
import com.bes.enterprise.web.util.descriptor.tld.TaglibXml;
import com.bes.enterprise.web.util.descriptor.tld.TldResourcePath;
import com.bes.enterprise.web.util.descriptor.tld.TldRuleSet;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.digester.RuleSet;
import com.bes.enterprise.web.util.security.PrivilegedGetTccl;
import com.bes.enterprise.web.util.security.PrivilegedSetTccl;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldParser {
    private final Log log = LogFactory.getLog(TldParser.class);
    private final Digester digester;

    public TldParser(boolean namespaceAware, boolean validation, boolean blockExternal) {
        this(namespaceAware, validation, new TldRuleSet(), blockExternal);
    }

    public TldParser(boolean namespaceAware, boolean validation, RuleSet ruleSet, boolean blockExternal) {
        this.digester = DigesterFactory.newDigester(validation, namespaceAware, ruleSet, blockExternal);
    }

    /*
     * Loose catch block
     */
    public TaglibXml parse(TldResourcePath path) throws IOException, SAXException {
        ClassLoader original;
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedGetTccl pa = new PrivilegedGetTccl();
            original = AccessController.doPrivileged(pa);
        } else {
            original = Thread.currentThread().getContextClassLoader();
        }
        try {
            try (InputStream is = path.openStream();){
                if (Constants.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa = new PrivilegedSetTccl(TldParser.class.getClassLoader());
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(TldParser.class.getClassLoader());
                }
                XmlErrorHandler handler = new XmlErrorHandler();
                this.digester.setErrorHandler(handler);
                TaglibXml taglibXml = new TaglibXml();
                this.digester.push(taglibXml);
                InputSource source = new InputSource(path.toExternalForm());
                source.setByteStream(is);
                this.digester.parse(source);
                if (!handler.getWarnings().isEmpty() || !handler.getErrors().isEmpty()) {
                    handler.logFindings(this.log, source.getSystemId());
                    if (!handler.getErrors().isEmpty()) {
                        throw handler.getErrors().iterator().next();
                    }
                }
                TaglibXml taglibXml2 = taglibXml;
                return taglibXml2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.digester.reset();
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa = new PrivilegedSetTccl(original);
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.digester.setClassLoader(classLoader);
    }
}

