/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.file;

import com.bes.enterprise.web.util.res.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class ConfigFileLoader {
    private static final StringManager sm = StringManager.getManager(ConfigFileLoader.class.getPackage().getName());
    private static final File BES_BASE_FILE;
    private static final URI BES_BASE_URI;

    private ConfigFileLoader() {
    }

    public static InputStream getInputStream(String location) throws IOException {
        File f2 = new File(location);
        if (!f2.isAbsolute()) {
            f2 = new File(BES_BASE_FILE, location);
        }
        if (f2.isFile()) {
            return new FileInputStream(f2);
        }
        URI uri = ConfigFileLoader.getURI(location);
        try {
            URL url = uri.toURL();
            return url.openConnection().getInputStream();
        }
        catch (IllegalArgumentException e2) {
            throw new IOException(sm.getString("configFileLoader.cannotObtainURL", location), e2);
        }
    }

    public static URI getURI(String location) {
        URI uri = BES_BASE_URI != null ? BES_BASE_URI.resolve(location) : URI.create(location);
        return uri;
    }

    static {
        String besBase = System.getProperty("bes.base");
        if (besBase != null) {
            BES_BASE_FILE = new File(besBase);
            BES_BASE_URI = BES_BASE_FILE.toURI();
        } else {
            BES_BASE_FILE = null;
            BES_BASE_URI = null;
        }
    }
}

