/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http;

import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.http.MimeHeaderField;
import com.bes.enterprise.web.util.http.NamesEnumerator;
import com.bes.enterprise.web.util.http.ValuesEnumerator;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;

public class MimeHeaders {
    public static final int DEFAULT_HEADER_SIZE = 8;
    private static final StringManager sm = StringManager.getManager("com.bes.enterprise.web.util.http");
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private int limit = -1;

    public void setLimit(int limit) {
        this.limit = limit;
        if (limit > 0 && this.headers.length > limit && this.count < limit) {
            MimeHeaderField[] tmp = new MimeHeaderField[limit];
            System.arraycopy(this.headers, 0, tmp, 0, this.count);
            this.headers = tmp;
        }
    }

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.headers[i2].recycle();
        }
        this.count = 0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== MimeHeaders ===");
        Enumeration<String> e2 = this.names();
        while (e2.hasMoreElements()) {
            String n2 = e2.nextElement();
            Enumeration<String> ev = this.values(n2);
            while (ev.hasMoreElements()) {
                pw.print(n2);
                pw.print(" = ");
                pw.println(ev.nextElement());
            }
        }
        return sw.toString();
    }

    public void duplicate(MimeHeaders source) throws IOException {
        for (int i2 = 0; i2 < source.size(); ++i2) {
            MimeHeaderField mhf = this.createHeader();
            mhf.getName().duplicate(source.getName(i2));
            mhf.getValue().duplicate(source.getValue(i2));
        }
    }

    public int size() {
        return this.count;
    }

    public MessageBytes getName(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2].getName() : null;
    }

    public MessageBytes getValue(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2].getValue() : null;
    }

    public int findHeader(String name, int starting) {
        for (int i2 = starting; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            return i2;
        }
        return -1;
    }

    public Enumeration<String> names() {
        return new NamesEnumerator(this);
    }

    public Enumeration<String> values(String name) {
        return new ValuesEnumerator(this, name);
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        if (this.limit > -1 && this.count >= this.limit) {
            throw new IllegalStateException(sm.getString("headers.maxCountFail", this.limit));
        }
        int len = this.headers.length;
        if (this.count >= len) {
            int newLength = this.count * 2;
            if (this.limit > 0 && newLength > this.limit) {
                newLength = this.limit;
            }
            MimeHeaderField[] tmp = new MimeHeaderField[newLength];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public MessageBytes addValue(String name) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public MessageBytes addValue(byte[] b2, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(b2, startN, len);
        return mhf.getValue();
    }

    public MessageBytes setValue(String name) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            for (int j2 = i2 + 1; j2 < this.count; ++j2) {
                if (!this.headers[j2].getName().equalsIgnoreCase(name)) continue;
                this.removeHeader(j2--);
            }
            return this.headers[i2].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public MessageBytes getValue(String name) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            return this.headers[i2].getValue();
        }
        return null;
    }

    public MessageBytes getUniqueValue(String name) {
        MessageBytes result = null;
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            if (result == null) {
                result = this.headers[i2].getValue();
                continue;
            }
            throw new IllegalArgumentException();
        }
        return result;
    }

    public String getHeader(String name) {
        MessageBytes mh = this.getValue(name);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            this.removeHeader(i2--);
        }
    }

    public void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        this.headers[idx] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mh;
        --this.count;
    }
}

