/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.http.CookieProcessorBase;
import com.bes.enterprise.web.util.http.MimeHeaders;
import com.bes.enterprise.web.util.http.SameSiteCookies;
import com.bes.enterprise.web.util.http.ServerCookies;
import com.bes.enterprise.web.util.http.parser.Cookie;
import com.bes.enterprise.web.util.res.StringManager;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.BitSet;
import java.util.Date;

public class Rfc6265CookieProcessor
extends CookieProcessorBase {
    private static final Log log;
    private static final StringManager sm;
    private static final BitSet domainValid;

    @Override
    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public void parseCookieHeader(MimeHeaders headers, ServerCookies serverCookies) {
        if (headers == null) {
            return;
        }
        int pos = headers.findHeader("Cookie", 0);
        while (pos >= 0) {
            MessageBytes cookieValue = headers.getValue(pos);
            if (cookieValue != null && !cookieValue.isNull()) {
                if (cookieValue.getType() != 2) {
                    if (log.isDebugEnabled()) {
                        Exception e2 = new Exception();
                        log.debug("Cookies: Parsing cookie as String. Expected bytes.", e2);
                    }
                    cookieValue.toBytes();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Cookies: Parsing b[]: " + cookieValue.toString());
                }
                ByteChunk bc = cookieValue.getByteChunk();
                Cookie.parseCookie(bc.getBytes(), bc.getOffset(), bc.getLength(), serverCookies);
            }
            ++pos;
            pos = headers.findHeader("Cookie", pos);
        }
    }

    @Override
    public String generateHeader(javax.servlet.http.Cookie cookie) {
        SameSiteCookies sameSiteCookiesValue;
        String path;
        String domain;
        int maxAge;
        StringBuffer header = new StringBuffer();
        header.append(cookie.getName());
        header.append('=');
        String value = cookie.getValue();
        if (value != null && value.length() > 0) {
            this.validateCookieValue(value);
            header.append(value);
        }
        if ((maxAge = cookie.getMaxAge()) > -1) {
            header.append("; Max-Age=");
            header.append(maxAge);
            header.append("; Expires=");
            if (maxAge == 0) {
                header.append(ANCIENT_DATE);
            } else {
                ((DateFormat)COOKIE_DATE_FORMAT.get()).format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), header, new FieldPosition(0));
            }
        }
        if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
            this.validateDomain(domain);
            header.append("; Domain=");
            header.append(domain);
        }
        if ((path = cookie.getPath()) != null && path.length() > 0) {
            this.validatePath(path);
            header.append("; Path=");
            header.append(path);
        }
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (!(sameSiteCookiesValue = this.getSameSiteCookies()).equals((Object)SameSiteCookies.UNSET)) {
            header.append("; SameSite=");
            header.append(sameSiteCookiesValue.getValue());
        }
        return header.toString();
    }

    private void validateCookieValue(String value) {
        int start = 0;
        int end = value.length();
        if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
            start = 1;
            --end;
        }
        char[] chars = value.toCharArray();
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = chars[i2];
            if (c2 >= '!' && c2 != '\"' && c2 != ',' && c2 != ';' && c2 != '\\' && c2 != '\u007f') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidCharInValue", Integer.toString(c2)));
        }
    }

    private void validateDomain(String domain) {
        int prev = -1;
        int cur = -1;
        char[] chars = domain.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            prev = cur;
            cur = chars[i2];
            if (!domainValid.get(cur)) {
                throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
            }
            if (prev != 45 || cur != 46) continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
        }
        if (cur == 46 || cur == 45) {
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", domain));
        }
    }

    private void validatePath(String path) {
        char[] chars = path.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char ch = chars[i2];
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidPath", path));
        }
    }

    static {
        int c2;
        log = LogFactory.getLog(Rfc6265CookieProcessor.class);
        sm = StringManager.getManager(Rfc6265CookieProcessor.class.getPackage().getName());
        domainValid = new BitSet(128);
        for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
            domainValid.set(c2);
        }
        for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
            domainValid.set(c2);
        }
        for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
            domainValid.set(c2);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

