/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.log;

import com.bes.enterprise.web.util.log.CaptureLog;
import java.io.IOException;
import java.io.PrintStream;
import java.util.EmptyStackException;
import java.util.Stack;

public class SystemLogHandler
extends PrintStream {
    private final PrintStream out;
    private static final ThreadLocal<Stack<CaptureLog>> logs = new ThreadLocal();
    private static final Stack<CaptureLog> reuse = new Stack();

    public SystemLogHandler(PrintStream wrapped) {
        super(wrapped);
        this.out = wrapped;
    }

    public static void startCapture() {
        Stack<CaptureLog> stack;
        CaptureLog log = null;
        if (!reuse.isEmpty()) {
            try {
                log = reuse.pop();
            }
            catch (EmptyStackException e2) {
                log = new CaptureLog();
            }
        } else {
            log = new CaptureLog();
        }
        if ((stack = logs.get()) == null) {
            stack = new Stack();
            logs.set(stack);
        }
        stack.push(log);
    }

    public static String stopCapture() {
        Stack<CaptureLog> stack = logs.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        CaptureLog log = stack.pop();
        if (log == null) {
            return null;
        }
        String capture = log.getCapture();
        log.reset();
        reuse.push(log);
        return capture;
    }

    protected PrintStream findStream() {
        PrintStream ps;
        CaptureLog log;
        Stack<CaptureLog> stack = logs.get();
        if (stack != null && !stack.isEmpty() && (log = stack.peek()) != null && (ps = log.getStream()) != null) {
            return ps;
        }
        return this.out;
    }

    @Override
    public void flush() {
        this.findStream().flush();
    }

    @Override
    public void close() {
        this.findStream().close();
    }

    @Override
    public boolean checkError() {
        return this.findStream().checkError();
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(int b2) {
        this.findStream().write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.findStream().write(b2);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.findStream().write(buf, off, len);
    }

    @Override
    public void print(boolean b2) {
        this.findStream().print(b2);
    }

    @Override
    public void print(char c2) {
        this.findStream().print(c2);
    }

    @Override
    public void print(int i2) {
        this.findStream().print(i2);
    }

    @Override
    public void print(long l2) {
        this.findStream().print(l2);
    }

    @Override
    public void print(float f2) {
        this.findStream().print(f2);
    }

    @Override
    public void print(double d2) {
        this.findStream().print(d2);
    }

    @Override
    public void print(char[] s2) {
        this.findStream().print(s2);
    }

    @Override
    public void print(String s2) {
        this.findStream().print(s2);
    }

    @Override
    public void print(Object obj) {
        this.findStream().print(obj);
    }

    @Override
    public void println() {
        this.findStream().println();
    }

    @Override
    public void println(boolean x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(char x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(int x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(long x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(float x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(double x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(char[] x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(String x2) {
        this.findStream().println(x2);
    }

    @Override
    public void println(Object x2) {
        this.findStream().println(x2);
    }
}

