/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.modeler.modules;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.modeler.ManagedBean;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.modeler.modules.ModelerSource;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class MbeansDescriptorsDigesterSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsDigesterSource.class);
    private static final Object dLock = new Object();
    private Registry registry;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private static Digester digester = null;

    private static Digester createDigester() {
        Digester digester = new Digester();
        digester.setNamespaceAware(false);
        digester.setValidating(false);
        URL url = Registry.getRegistry(null, null).getClass().getResource("/com/bes/enterprise/web/util/modeler/mbeans-descriptors.dtd");
        digester.register("-//Apache Software Foundation//DTD Model MBeans Configuration File", url.toString());
        digester.addObjectCreate("mbeans-descriptors/mbean", "com.bes.enterprise.web.util.modeler.ManagedBean");
        digester.addSetProperties("mbeans-descriptors/mbean");
        digester.addSetNext("mbeans-descriptors/mbean", "add", "java.lang.Object");
        digester.addObjectCreate("mbeans-descriptors/mbean/attribute", "com.bes.enterprise.web.util.modeler.AttributeInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/attribute");
        digester.addSetNext("mbeans-descriptors/mbean/attribute", "addAttribute", "com.bes.enterprise.web.util.modeler.AttributeInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/notification", "com.bes.enterprise.web.util.modeler.NotificationInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/notification");
        digester.addSetNext("mbeans-descriptors/mbean/notification", "addNotification", "com.bes.enterprise.web.util.modeler.NotificationInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/notification/descriptor/field", "com.bes.enterprise.web.util.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/notification/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/notification/descriptor/field", "addField", "com.bes.enterprise.web.util.modeler.FieldInfo");
        digester.addCallMethod("mbeans-descriptors/mbean/notification/notification-type", "addNotifType", 0);
        digester.addObjectCreate("mbeans-descriptors/mbean/operation", "com.bes.enterprise.web.util.modeler.OperationInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation");
        digester.addSetNext("mbeans-descriptors/mbean/operation", "addOperation", "com.bes.enterprise.web.util.modeler.OperationInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/operation/descriptor/field", "com.bes.enterprise.web.util.modeler.FieldInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation/descriptor/field");
        digester.addSetNext("mbeans-descriptors/mbean/operation/descriptor/field", "addField", "com.bes.enterprise.web.util.modeler.FieldInfo");
        digester.addObjectCreate("mbeans-descriptors/mbean/operation/parameter", "com.bes.enterprise.web.util.modeler.ParameterInfo");
        digester.addSetProperties("mbeans-descriptors/mbean/operation/parameter");
        digester.addSetNext("mbeans-descriptors/mbean/operation/parameter", "addParameter", "com.bes.enterprise.web.util.modeler.ParameterInfo");
        return digester;
    }

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        InputStream stream = (InputStream)this.source;
        ArrayList loadedMbeans = new ArrayList();
        Iterator iterator = dLock;
        synchronized (iterator) {
            if (digester == null) {
                digester = MbeansDescriptorsDigesterSource.createDigester();
            }
            try {
                digester.push(loadedMbeans);
                digester.parse(stream);
            }
            catch (Exception e2) {
                log.error(sm.getString("modules.digesterParseError"), e2);
                throw e2;
            }
            finally {
                digester.reset();
            }
        }
        for (ManagedBean loadedMbean : loadedMbeans) {
            this.registry.addManagedBean(loadedMbean);
        }
    }
}

