/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.appserver.common.util.NetUtils;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.web.crane.AbstractProcessor;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.collections.SynchronizedStack;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.net.Acceptor;
import com.bes.enterprise.web.util.net.SSLContext;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.web.util.net.SSLHostConfigCertificate;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketProcessorBase;
import com.bes.enterprise.web.util.net.SocketProperties;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.threads.LimitLatch;
import com.bes.enterprise.web.util.threads.ResizableExecutor;
import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import com.bes.enterprise.web.util.threads.WorkQueue;
import com.bes.enterprise.web.util.threads.WorkThreadFactory;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class AbstractEndpoint<S, U> {
    protected static final StringManager sm = StringManager.getManager(AbstractEndpoint.class);
    private static final boolean lazyBind = Boolean.getBoolean("com.bes.enterprise.web.lazyBind");
    public static final int lazyBindMaxTime = Integer.parseInt(System.getProperty("com.bes.enterprise.web.lazyBindMaxTime", "30"));
    private CountDownLatch portBoundLatch = new CountDownLatch(1);
    private static CountDownLatch allAppHasStarted = new CountDownLatch(1);
    protected AtomicInteger connectionCounter = new AtomicInteger(0);
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = true;
    private volatile LimitLatch connectionLimitLatch = null;
    protected final SocketProperties socketProperties = new SocketProperties();
    protected Acceptor<U> acceptor;
    protected SynchronizedStack<SocketProcessorBase<S>> processorCache;
    private ObjectName oname = null;
    protected Map<U, SocketWrapperBase<S>> connections = new ConcurrentHashMap<U, SocketWrapperBase<S>>();
    private String connectorName;
    private String defaultSSLHostConfigName = "_default_";
    protected ConcurrentMap<String, SSLHostConfig> sslHostConfigs = new ConcurrentHashMap<String, SSLHostConfig>();
    private boolean useSendfile = true;
    private long executorTerminationTimeoutMillis = 5000L;
    protected int acceptorThreadCount = 1;
    protected int acceptorThreadPriority = 5;
    private int maxConnections = 10000;
    private Executor executor = null;
    private int port;
    private InetAddress address;
    private int acceptCount = 1024;
    private boolean bindOnInit = true;
    private volatile BindState bindState = BindState.UNBOUND;
    private Integer keepAliveTimeout = null;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    private int maxQueueSize = 4096;
    private int maxIdleTime = 60000;
    private String namePrefix;
    protected int threadPriority = 5;
    private int maxKeepAliveRequests = 100;
    private int maxHeaderCount = 100;
    private String name = "TP";
    private String domain;
    private boolean daemon = true;
    private boolean useAsyncIO = true;
    protected final List<String> negotiableProtocols = new ArrayList<String>();
    private Handler<S> handler = null;
    protected HashMap<String, Object> attributes = new HashMap();
    protected final Set<SocketWrapperBase<S>> waitingRequests = Collections.newSetFromMap(new ConcurrentHashMap());

    public static long toTimeout(long timeout) {
        return timeout > 0L ? timeout : Long.MAX_VALUE;
    }

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public abstract boolean isParseHeadersBySelectorThread();

    public Set<SocketWrapperBase<S>> getConnections() {
        return new HashSet<SocketWrapperBase<S>>(this.connections.values());
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getDefaultSSLHostConfigName() {
        return this.defaultSSLHostConfigName;
    }

    public void setDefaultSSLHostConfigName(String defaultSSLHostConfigName) {
        this.defaultSSLHostConfigName = defaultSSLHostConfigName;
    }

    public void addSslHostConfig(SSLHostConfig sslHostConfig) throws IllegalArgumentException {
        this.addSslHostConfig(sslHostConfig, false);
    }

    public void addSslHostConfig(SSLHostConfig sslHostConfig, boolean replace) throws IllegalArgumentException {
        String key = sslHostConfig.getHostName();
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException(sm.getString("endpoint.noSslHostName"));
        }
        if (this.bindState != BindState.UNBOUND && this.bindState != BindState.SOCKET_CLOSED_ON_STOP && this.isSSLEnabled()) {
            try {
                this.createSSLContext(sslHostConfig);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(e2);
            }
        }
        if (replace) {
            SSLHostConfig previous = this.sslHostConfigs.put(key, sslHostConfig);
            if (previous != null) {
                this.unregisterJmx(sslHostConfig);
            }
            this.registerJmx(sslHostConfig);
        } else {
            SSLHostConfig duplicate = this.sslHostConfigs.putIfAbsent(key, sslHostConfig);
            if (duplicate != null) {
                this.releaseSSLContext(sslHostConfig);
                throw new IllegalArgumentException(sm.getString("endpoint.duplicateSslHostName", key));
            }
            this.registerJmx(sslHostConfig);
        }
    }

    public SSLHostConfig removeSslHostConfig(String hostName) {
        if (hostName == null) {
            return null;
        }
        if (hostName.equalsIgnoreCase(this.getDefaultSSLHostConfigName())) {
            throw new IllegalArgumentException(sm.getString("endpoint.removeDefaultSslHostConfig", hostName));
        }
        SSLHostConfig sslHostConfig = (SSLHostConfig)this.sslHostConfigs.remove(hostName);
        this.unregisterJmx(sslHostConfig);
        return sslHostConfig;
    }

    public void reloadSslHostConfig(String hostName) {
        SSLHostConfig sslHostConfig = (SSLHostConfig)this.sslHostConfigs.get(hostName);
        if (sslHostConfig == null) {
            throw new IllegalArgumentException(sm.getString("endpoint.unknownSslHostName", hostName));
        }
        this.addSslHostConfig(sslHostConfig, true);
    }

    public void reloadSslHostConfigs() {
        for (String hostName : this.sslHostConfigs.keySet()) {
            this.reloadSslHostConfig(hostName);
        }
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.sslHostConfigs.values().toArray(new SSLHostConfig[0]);
    }

    protected abstract void createSSLContext(SSLHostConfig var1) throws Exception;

    protected void destroySsl() throws Exception {
        if (this.isSSLEnabled()) {
            for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
                this.releaseSSLContext(sslHostConfig);
            }
        }
    }

    protected void releaseSSLContext(SSLHostConfig sslHostConfig) {
        for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates(true)) {
            SSLContext sslContext;
            if (certificate.getSslContext() == null || (sslContext = certificate.getSslContext()) == null) continue;
            sslContext.destroy();
        }
    }

    protected SSLHostConfig getSSLHostConfig(String sniHostName) {
        SSLHostConfig result = null;
        if (sniHostName != null) {
            result = (SSLHostConfig)this.sslHostConfigs.get(sniHostName);
            if (result != null) {
                return result;
            }
            int indexOfDot = sniHostName.indexOf(46);
            if (indexOfDot > -1) {
                result = (SSLHostConfig)this.sslHostConfigs.get("*" + sniHostName.substring(indexOfDot));
            }
        }
        if (result == null) {
            result = (SSLHostConfig)this.sslHostConfigs.get(this.getDefaultSSLHostConfigName());
        }
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public long getExecutorTerminationTimeoutMillis() {
        return this.executorTerminationTimeoutMillis;
    }

    public void setExecutorTerminationTimeoutMillis(long executorTerminationTimeoutMillis) {
        this.executorTerminationTimeoutMillis = executorTerminationTimeoutMillis;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setAcceptorThreadPriority(int acceptorThreadPriority) {
        this.acceptorThreadPriority = acceptorThreadPriority;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setMaxConnections(int maxCon) {
        this.maxConnections = maxCon;
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            if (maxCon == -1) {
                this.releaseConnectionLatch();
            } else {
                latch.setLimit(maxCon);
            }
        } else if (maxCon > 0) {
            this.initializeConnectionLatch();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionCount() {
        return this.connectionCounter.longValue();
    }

    protected void connectionCounterUp() {
        this.connectionCounter.getAndIncrement();
    }

    private void connectionCounterDown() {
        this.connectionCounter.decrementAndGet();
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public final int getLocalPort() {
        try {
            InetSocketAddress localAddress = this.getLocalAddress();
            if (localAddress == null) {
                return -1;
            }
            return localAddress.getPort();
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    protected abstract InetSocketAddress getLocalAddress() throws IOException;

    public void setAcceptCount(int acceptCount) {
        if (acceptCount > 0) {
            this.acceptCount = acceptCount;
        }
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean b2) {
        this.bindOnInit = b2;
    }

    public int getKeepAliveTimeout() {
        if (this.keepAliveTimeout == null) {
            return this.getConnectionTimeout();
        }
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.socketProperties.setTcpNoDelay(tcpNoDelay);
    }

    public int getConnectionLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setConnectionLinger(int connectionLinger) {
        this.socketProperties.setSoLingerTime(connectionLinger);
        this.socketProperties.setSoLingerOn(connectionLinger >= 0);
    }

    public int getConnectionTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setConnectionTimeout(int soTimeout) {
        this.socketProperties.setSoTimeout(soTimeout);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public abstract boolean isAlpnSupported();

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            ((java.util.concurrent.ThreadPoolExecutor)executor).setCorePoolSize(minSpareThreads);
        }
    }

    public int getMinSpareThreads() {
        return Math.min(this.getMinSpareThreadsInternal(), this.getMaxThreads());
    }

    private int getMinSpareThreadsInternal() {
        if (this.internalExecutor) {
            return this.minSpareThreads;
        }
        return -1;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            ((java.util.concurrent.ThreadPoolExecutor)executor).setMaximumPoolSize(maxThreads);
        }
    }

    public int getMaxThreads() {
        if (this.internalExecutor) {
            return this.maxThreads;
        }
        return -1;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        if (this.internalExecutor) {
            return this.maxQueueSize;
        }
        return -1;
    }

    public void setMaxIdleSize(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxIdleSize() {
        if (this.internalExecutor) {
            return this.maxIdleTime;
        }
        return -1;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String namePrefix() {
        return this.namePrefix;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        if (this.internalExecutor) {
            return this.threadPriority;
        }
        return -1;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDaemon(boolean b2) {
        this.daemon = b2;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setUseAsyncIO(boolean useAsyncIO) {
        this.useAsyncIO = useAsyncIO;
    }

    public boolean getUseAsyncIO() {
        return this.useAsyncIO;
    }

    protected abstract boolean getDeferAccept();

    public void addNegotiatedProtocol(String negotiableProtocol) {
        this.negotiableProtocols.add(negotiableProtocol);
    }

    public boolean hasNegotiableProtocols() {
        return this.negotiableProtocols.size() > 0;
    }

    public void setHandler(Handler<S> handler) {
        this.handler = handler;
    }

    public Handler<S> getHandler() {
        return this.handler;
    }

    public void setAttribute(String name, Object value) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(sm.getString("endpoint.setAttribute", name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        Object value = this.attributes.get(key);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(sm.getString("endpoint.getAttribute", key, value));
        }
        return value;
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        String socketName = "socket.";
        try {
            if (name.startsWith("socket.")) {
                return IntrospectionUtils.setProperty(this.socketProperties, name.substring("socket.".length()), value);
            }
            return IntrospectionUtils.setProperty(this, name, value, false);
        }
        catch (Exception x2) {
            this.getLog().error("Unable to set attribute \"" + name + "\" to \"" + value + "\"", x2);
            return false;
        }
    }

    public String getProperty(String name) {
        Object result;
        String value = (String)this.getAttribute(name);
        String socketName = "socket.";
        if (value == null && name.startsWith("socket.") && (result = IntrospectionUtils.getProperty(this.socketProperties, name.substring("socket.".length()))) != null) {
            value = result.toString();
        }
        return value;
    }

    public int getCurrentThreadCount() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        StringBuilder sb = new StringBuilder();
        if (this.namePrefix == null) {
            if (!this.SSLEnabled) {
                sb.append("httpWorkerThread");
            } else {
                sb.append("httpSSLWorkerThread");
            }
        } else {
            sb.append(this.namePrefix);
        }
        sb.append("-").append(this.getPort());
        sb.append("-");
        WorkQueue taskqueue = new WorkQueue(this.getMaxQueueSize());
        WorkThreadFactory tf = new WorkThreadFactory(sb.toString(), this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), (long)this.maxIdleTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)taskqueue, tf);
        taskqueue.setParent((ThreadPoolExecutor)this.executor);
    }

    public void shutdownExecutor() {
        Executor executor = this.executor;
        if (executor != null && this.internalExecutor) {
            this.executor = null;
            if (executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
                tpe.shutdownNow();
                long timeout = this.getExecutorTerminationTimeoutMillis();
                if (timeout > 0L) {
                    try {
                        tpe.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tpe.isTerminating()) {
                        this.getLog().warn(sm.getString("endpoint.warn.executorShutdown", this.getName()));
                    }
                }
                WorkQueue queue = (WorkQueue)tpe.getQueue();
                queue.setParent(null);
            }
        }
    }

    protected void unlockAccept() {
        block25: {
            if (this.acceptor == null || this.acceptor.getState() != Acceptor.AcceptorState.RUNNING) {
                return;
            }
            InetSocketAddress unlockAddress = null;
            InetSocketAddress localAddress = null;
            try {
                localAddress = this.getLocalAddress();
            }
            catch (IOException ioe) {
                this.getLog().debug(sm.getString("endpoint.debug.unlock.localFail", this.getName()), ioe);
            }
            if (localAddress == null) {
                this.getLog().warn(sm.getString("endpoint.debug.unlock.localNone", this.getName()));
                return;
            }
            try {
                unlockAddress = AbstractEndpoint.getUnlockAddress(localAddress);
                try (Socket s2 = new Socket();){
                    int stmo = 2000;
                    int utmo = 2000;
                    if (this.getSocketProperties().getSoTimeout() > stmo) {
                        stmo = this.getSocketProperties().getSoTimeout();
                    }
                    if (this.getSocketProperties().getUnlockTimeout() > utmo) {
                        utmo = this.getSocketProperties().getUnlockTimeout();
                    }
                    s2.setSoTimeout(stmo);
                    s2.setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("About to unlock socket for:" + unlockAddress);
                    }
                    s2.connect(unlockAddress, utmo);
                    if (this.getDeferAccept()) {
                        OutputStreamWriter sw = new OutputStreamWriter(s2.getOutputStream(), "ISO-8859-1");
                        sw.write("OPTIONS * HTTP/1.0\r\nUser-Agent: AppServer wakeup connection\r\n\r\n");
                        sw.flush();
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Socket unlock completed for:" + unlockAddress);
                    }
                }
                long startTime = System.nanoTime();
                while (startTime + 1000000000L > System.nanoTime() && this.acceptor.getState() == Acceptor.AcceptorState.RUNNING) {
                    if (startTime + 1000000L >= System.nanoTime()) continue;
                    Thread.sleep(1L);
                }
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                if (!this.getLog().isDebugEnabled()) break block25;
                this.getLog().debug(sm.getString("endpoint.debug.unlock.fail", "" + this.getPort()), t2);
            }
        }
    }

    private static InetSocketAddress getUnlockAddress(InetSocketAddress localAddress) throws SocketException {
        if (localAddress.getAddress().isAnyLocalAddress()) {
            InetAddress loopbackUnlockAddress = null;
            InetAddress linkLocalUnlockAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!localAddress.getAddress().getClass().isAssignableFrom(inetAddress.getClass())) continue;
                    if (inetAddress.isLoopbackAddress()) {
                        if (loopbackUnlockAddress != null) continue;
                        loopbackUnlockAddress = inetAddress;
                        continue;
                    }
                    if (inetAddress.isLinkLocalAddress()) {
                        if (linkLocalUnlockAddress != null) continue;
                        linkLocalUnlockAddress = inetAddress;
                        continue;
                    }
                    return new InetSocketAddress(inetAddress, localAddress.getPort());
                }
            }
            if (loopbackUnlockAddress != null) {
                return new InetSocketAddress(loopbackUnlockAddress, localAddress.getPort());
            }
            if (linkLocalUnlockAddress != null) {
                return new InetSocketAddress(linkLocalUnlockAddress, localAddress.getPort());
            }
            return new InetSocketAddress("localhost", localAddress.getPort());
        }
        return localAddress;
    }

    public boolean processSocket(SocketWrapperBase<S> socketWrapper, SocketEvent event, boolean dispatch) {
        try {
            if (socketWrapper == null) {
                return false;
            }
            SocketProcessorBase<S> sc = this.processorCache.pop();
            if (sc == null) {
                sc = this.createSocketProcessor(socketWrapper, event);
            } else {
                sc.reset(socketWrapper, event);
            }
            Executor executor = this.getExecutor();
            if (dispatch && executor != null) {
                executor.execute(sc);
            } else {
                sc.run();
            }
        }
        catch (RejectedExecutionException ree) {
            this.getLog().warn(sm.getString("endpoint.executor.fail", socketWrapper), ree);
            return false;
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            this.getLog().error(sm.getString("endpoint.process.fail"), t2);
            return false;
        }
        return true;
    }

    protected abstract SocketProcessorBase<S> createSocketProcessor(SocketWrapperBase<S> var1, SocketEvent var2);

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    public static void notifyAllAppsStarted() {
        allAppHasStarted.countDown();
    }

    private void lazyBindIfNecessary() throws Exception {
        if (lazyBind) {
            Thread bindThread = new Thread(){

                @Override
                public void run() {
                    if (AbstractEndpoint.this.getAddress() == null && !NetUtils.isPortFree(AbstractEndpoint.this.getPort())) {
                        String msg = sm.getString("endpoint.port.inuse", AbstractEndpoint.this.getPort());
                        throw new RuntimeException(msg);
                    }
                    if (AbstractEndpoint.this.getAddress() != null && !NetUtils.isPortFreeServer(AbstractEndpoint.this.getPort(), AbstractEndpoint.this.getAddress())) {
                        String msg = sm.getString("endpoint.address.inuse", AbstractEndpoint.this.getAddress().getHostAddress(), AbstractEndpoint.this.getPort());
                        throw new RuntimeException(msg);
                    }
                    try {
                        allAppHasStarted.await(lazyBindMaxTime, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    try {
                        AbstractEndpoint.this.bindWithCleanup();
                        AbstractEndpoint.this.portBoundLatch.countDown();
                    }
                    catch (Exception ex) {
                        String msg = null;
                        if (AbstractEndpoint.this.getAddress() == null) {
                            msg = sm.getString("endpoint.port.inuse", AbstractEndpoint.this.getPort());
                        } else if (AbstractEndpoint.this.getAddress() != null) {
                            msg = sm.getString("endpoint.address.inuse", AbstractEndpoint.this.getAddress().getHostAddress(), AbstractEndpoint.this.getPort());
                        }
                        AbstractEndpoint.this.getLog().error(msg, ex);
                        ConfigProviderGlobals.shutdown();
                    }
                }
            };
            bindThread.start();
        } else {
            this.bindWithCleanup();
        }
    }

    public void waitPortBound() {
        if (!lazyBind) {
            return;
        }
        try {
            this.portBoundLatch.await(lazyBindMaxTime, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void bindWithCleanup() throws Exception {
        try {
            this.bind();
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            this.unbind();
            throw t2;
        }
    }

    public void init() throws Exception {
        if (this.bindOnInit) {
            this.lazyBindIfNecessary();
            this.bindState = BindState.BOUND_ON_INIT;
        }
        if (this.domain != null) {
            this.oname = new ObjectName(this.domain + ":type=ThreadPool,name=\"" + this.getName() + "\"");
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            ObjectName socketPropertiesOname = new ObjectName(this.domain + ":type=SocketProperties,name=\"" + this.getName() + "\"");
            this.socketProperties.setObjectName(socketPropertiesOname);
            Registry.getRegistry(null, null).registerComponent((Object)this.socketProperties, socketPropertiesOname, null);
            for (SSLHostConfig sslHostConfig : this.findSslHostConfigs()) {
                this.registerJmx(sslHostConfig);
            }
        }
    }

    private void registerJmx(SSLHostConfig sslHostConfig) {
        if (this.domain == null) {
            return;
        }
        ObjectName sslOname = null;
        try {
            sslOname = new ObjectName(this.domain + ":type=SSLHostConfig,ThreadPool=\"" + this.getName() + "\",name=" + ObjectName.quote(sslHostConfig.getHostName()));
            sslHostConfig.setObjectName(sslOname);
            try {
                Registry.getRegistry(null, null).registerComponent((Object)sslHostConfig, sslOname, null);
            }
            catch (Exception e2) {
                this.getLog().warn(sm.getString("endpoint.jmxRegistrationFailed", sslOname), e2);
            }
        }
        catch (MalformedObjectNameException e3) {
            this.getLog().warn(sm.getString("endpoint.invalidJmxNameSslHost", sslHostConfig.getHostName()), e3);
        }
        for (SSLHostConfigCertificate sslHostConfigCert : sslHostConfig.getCertificates()) {
            ObjectName sslCertOname = null;
            try {
                sslCertOname = new ObjectName(this.domain + ":type=SSLHostConfigCertificate,ThreadPool=\"" + this.getName() + "\",Host=" + ObjectName.quote(sslHostConfig.getHostName()) + ",name=" + (Object)((Object)sslHostConfigCert.getType()));
                sslHostConfigCert.setObjectName(sslCertOname);
                try {
                    Registry.getRegistry(null, null).registerComponent((Object)sslHostConfigCert, sslCertOname, null);
                }
                catch (Exception e4) {
                    this.getLog().warn(sm.getString("endpoint.jmxRegistrationFailed", sslCertOname), e4);
                }
            }
            catch (MalformedObjectNameException e5) {
                this.getLog().warn(sm.getString("endpoint.invalidJmxNameSslHostCert", new Object[]{sslHostConfig.getHostName(), sslHostConfigCert.getType()}), e5);
            }
        }
    }

    private void unregisterJmx(SSLHostConfig sslHostConfig) {
        Registry registry = Registry.getRegistry(null, null);
        registry.unregisterComponent(sslHostConfig.getObjectName());
        for (SSLHostConfigCertificate sslHostConfigCert : sslHostConfig.getCertificates()) {
            registry.unregisterComponent(sslHostConfigCert.getObjectName());
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.lazyBindIfNecessary();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    protected void startAcceptorThread() {
        this.acceptor = new Acceptor(this);
        String namePrefix = "AcceptorThread-" + this.getPort();
        this.acceptor.setThreadName(namePrefix);
        Thread t2 = new Thread(this.acceptor, namePrefix);
        t2.setPriority(this.getAcceptorThreadPriority());
        t2.setDaemon(this.getDaemon());
        t2.setContextClassLoader(this.getClass().getClassLoader());
        t2.start();
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.releaseConnectionLatch();
            this.unlockAccept();
            this.getHandler().pause();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START || this.bindState == BindState.SOCKET_CLOSED_ON_STOP) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
        Registry registry = Registry.getRegistry(null, null);
        registry.unregisterComponent(this.oname);
        registry.unregisterComponent(this.socketProperties.getObjectName());
        for (SSLHostConfig sslHostConfig : this.findSslHostConfigs()) {
            this.unregisterJmx(sslHostConfig);
        }
    }

    protected abstract Log getLog();

    protected LimitLatch initializeConnectionLatch() {
        if (this.maxConnections == -1) {
            return null;
        }
        if (this.connectionLimitLatch == null) {
            this.connectionLimitLatch = new LimitLatch(this.getMaxConnections());
        }
        return this.connectionLimitLatch;
    }

    protected void releaseConnectionLatch() {
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            latch.releaseAll();
        }
        this.connectionLimitLatch = null;
    }

    protected void countUpOrAwaitConnection() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            latch.countUpOrAwait();
        }
    }

    protected long countDownConnection() {
        return this.countDownConnection(true);
    }

    protected long countDownConnection(boolean closeSocket) {
        if (closeSocket) {
            this.connectionCounterDown();
        }
        if (this.maxConnections == -1) {
            return -1L;
        }
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            long result = latch.countDown();
            if (result < 0L) {
                this.getLog().warn(sm.getString("endpoint.warn.incorrectConnectionCount"));
            }
            return result;
        }
        return -1L;
    }

    public final void closeServerSocketGraceful() {
        if (this.bindState == BindState.BOUND_ON_START) {
            this.acceptor.stop(-1);
            this.releaseConnectionLatch();
            this.unlockAccept();
            this.getHandler().pause();
            this.bindState = BindState.SOCKET_CLOSED_ON_STOP;
            try {
                this.doCloseServerSocket();
            }
            catch (IOException ioe) {
                this.getLog().warn(sm.getString("endpoint.serverSocket.closeFailed", this.getName()), ioe);
            }
        }
    }

    public final long awaitConnectionsClose(long waitMillis) {
        while (waitMillis > 0L && !this.connections.isEmpty()) {
            try {
                Thread.sleep(50L);
                waitMillis -= 50L;
            }
            catch (InterruptedException e2) {
                Thread.interrupted();
                waitMillis = 0L;
            }
        }
        return waitMillis;
    }

    protected abstract void doCloseServerSocket() throws IOException;

    protected abstract U serverSocketAccept() throws Exception;

    protected abstract boolean setSocketOptions(U var1);

    protected void closeSocket(U socket) {
        SocketWrapperBase<S> socketWrapper = this.connections.get(socket);
        if (socketWrapper != null) {
            socketWrapper.close();
        }
    }

    protected int getMaxThreadsExecutor(boolean useExecutor) {
        if (useExecutor && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                return ((java.util.concurrent.ThreadPoolExecutor)this.executor).getMaximumPoolSize();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getMaxThreads();
            }
            return -1;
        }
        return this.maxThreads;
    }

    protected abstract void destroySocket(U var1);

    protected static enum BindState {
        UNBOUND,
        BOUND_ON_INIT,
        BOUND_ON_START,
        SOCKET_CLOSED_ON_STOP;

    }

    public static interface Handler<S> {
        public SocketState process(SocketWrapperBase<S> var1, SocketEvent var2);

        public Object getGlobal();

        @Deprecated
        public Set<S> getOpenSockets();

        public void release(SocketWrapperBase<S> var1);

        public void pause();

        public void recycle();

        public AbstractProcessor getProcessor(SocketWrapperBase<S> var1);

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END,
            SENDFILE,
            UPGRADING,
            UPGRADED,
            SUSPENDED,
            PARSED_HEADER;

        }
    }
}

