/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.http11.AbstractHttp11Protocol;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.AbstractJsseEndpoint;
import com.bes.enterprise.web.util.net.Acceptor;
import com.bes.enterprise.web.util.net.ApplicationBufferHandler;
import com.bes.enterprise.web.util.net.DefaultServerSocketFactory;
import com.bes.enterprise.web.util.net.SSLSupport;
import com.bes.enterprise.web.util.net.SendfileDataBase;
import com.bes.enterprise.web.util.net.SendfileState;
import com.bes.enterprise.web.util.net.ServerSocketFactory;
import com.bes.enterprise.web.util.net.SocketBufferHandler;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketProcessorBase;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.CompletionHandler;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JIoEndpoint
extends AbstractJsseEndpoint<Socket, Socket> {
    private static final Log log = LogFactory.getLog(JIoEndpoint.class);
    protected ServerSocket serverSocket = null;
    protected AbstractHttp11Protocol protocol = null;
    protected ServerSocketFactory serverSocketFactory = null;
    private String allowUnsafeLegacyRenegotiation = null;
    private AsyncTimeout asyncTimeout = null;

    public void setProtocol(AbstractHttp11Protocol protocol) {
        this.protocol = protocol;
    }

    public JIoEndpoint() {
        this.setMaxConnections(0);
        this.setExecutorTerminationTimeoutMillis(0L);
    }

    @Override
    protected Object getServerSocket() {
        return this.serverSocket;
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        if (this.getServerSocket() == null) {
            return null;
        }
        SocketAddress sa = ((ServerSocket)this.getServerSocket()).getLocalSocketAddress();
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    @Override
    public boolean getUseSendfile() {
        return false;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public boolean isParseHeadersBySelectorThread() {
        return false;
    }

    @Override
    protected SocketProcessorBase<Socket> createSocketProcessor(SocketWrapperBase<Socket> socketWrapper, SocketEvent event) {
        return new SocketProcessor(socketWrapper, event);
    }

    @Override
    protected void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void destroySocket(Socket socket) {
        block2: {
            this.countDownConnection();
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(sm.getString("endpoint.err.close"), ioe);
            }
        }
    }

    @Override
    protected void doCloseServerSocket() throws IOException {
        if (this.serverSocket != null) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e2) {
                log.error(sm.getString("endpoint.err.close"), e2);
            }
        }
        this.serverSocket = null;
    }

    @Override
    protected Socket serverSocketAccept() throws Exception {
        return this.serverSocket.accept();
    }

    @Override
    protected boolean setSocketOptions(Socket socket) {
        try {
            this.socketProperties.setProperties(socket);
        }
        catch (SocketException s2) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("endpoint.err.unexpected"), s2);
            }
            return false;
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("endpoint.err.unexpected"), t2);
            return false;
        }
        return true;
    }

    @Override
    public void bind() throws Exception {
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.getMaxConnections() == 0) {
            this.setMaxConnections(this.getMaxThreadsExecutor(true));
        }
        this.initialiseSsl();
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.isSSLEnabled() ? this.getSslImplementation().getServerSocketFactory(this) : new DefaultServerSocketFactory(this);
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = this.getAddress() == null ? this.serverSocketFactory.createSocket(this.getPort(), this.getAcceptCount()) : this.serverSocketFactory.createSocket(this.getPort(), this.getAcceptCount(), this.getAddress());
            }
            catch (BindException orig) {
                String msg = this.getAddress() == null ? orig.getMessage() + " <null>:" + this.getPort() : orig.getMessage() + " " + this.getAddress().toString() + ":" + this.getPort();
                BindException be = new BindException(msg);
                be.initCause(orig);
                throw be;
            }
        }
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.startAcceptorThread();
            this.setAsyncTimeout(new AsyncTimeout());
            Thread timeoutThread = new Thread((Runnable)this.getAsyncTimeout(), this.getName() + "-AsyncTimeout");
            timeoutThread.setPriority(this.threadPriority);
            timeoutThread.setDaemon(true);
            timeoutThread.start();
        }
    }

    @Override
    protected void startAcceptorThread() {
        this.acceptor = new JioAcceptor(this);
        String threadName = this.getName() + "-Acceptor-";
        this.acceptor.setThreadName(threadName);
        Thread t2 = new Thread((Runnable)this.acceptor, threadName);
        t2.setPriority(this.getAcceptorThreadPriority());
        t2.setDaemon(this.getDaemon());
        t2.start();
    }

    @Override
    public void stopInternal() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.getAsyncTimeout().stop();
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        this.doCloseServerSocket();
        this.getHandler().recycle();
    }

    protected boolean processSocket(Socket socket) {
        try {
            JIoSocketWrapper wrapper = new JIoSocketWrapper(socket, this);
            wrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            wrapper.setSecure(this.isSSLEnabled());
            if (!this.running) {
                return false;
            }
            this.getExecutor().execute(new SocketProcessor(wrapper, SocketEvent.OPEN_READ));
        }
        catch (RejectedExecutionException x2) {
            log.warn("Socket processing request was rejected for:" + socket, x2);
            return false;
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("endpoint.process.fail"), t2);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processSocket(SocketWrapperBase<Socket> socket, SocketEvent status, boolean dispatch) {
        try {
            SocketWrapperBase<Socket> socketWrapperBase = socket;
            synchronized (socketWrapperBase) {
                if (this.waitingRequests.remove(socket)) {
                    SocketProcessor proc = new SocketProcessor(socket, status);
                    Executor executor = this.getExecutor();
                    if (dispatch && executor != null) {
                        if (!this.running) {
                            return false;
                        }
                        this.getExecutor().execute(proc);
                    } else {
                        proc.run();
                    }
                }
            }
        }
        catch (RejectedExecutionException ree) {
            log.warn(sm.getString("endpoint.executor.fail", socket), ree);
            return false;
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("endpoint.process.fail"), t2);
            return false;
        }
        return true;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    public String getAlgorithm() {
        return this.protocol.getAlgorithm();
    }

    public String getClientAuth() {
        return this.protocol.getClientAuth();
    }

    public String getKeystoreFile() {
        return this.protocol.getKeystoreFile();
    }

    public String getKeystorePass() {
        return this.protocol.getKeyPass();
    }

    public String getKeystoreType() {
        return this.protocol.getKeystoreType();
    }

    public String getKeystoreProvider() {
        return this.protocol.getKeystoreProvider();
    }

    public String getSslProtocol() {
        return this.protocol.getSslProtocol();
    }

    public String getCiphers() {
        return this.protocol.getCiphers();
    }

    public String getKeyAlias() {
        return this.protocol.getKeyAlias();
    }

    public String getKeyPass() {
        return this.protocol.getKeyPass();
    }

    public String getTruststoreFile() {
        return this.protocol.getTruststoreFile();
    }

    public String getTruststorePass() {
        return this.protocol.getTruststorePass();
    }

    public String getTruststoreType() {
        return this.protocol.getTruststoreType();
    }

    public String getTruststoreProvider() {
        return this.protocol.getTruststoreProvider();
    }

    public String getTruststoreAlgorithm() {
        return this.protocol.getTruststoreAlgorithm();
    }

    public String getTrustManagerClassName() {
        return this.protocol.getTrustManagerClassName();
    }

    public String getCrlFile() {
        return this.protocol.getCrlFile();
    }

    public String getTrustMaxCertLength() {
        return String.valueOf(this.protocol.getTrustMaxCertLength());
    }

    public int getSessionCacheSize() {
        return this.protocol.getSessionCacheSize();
    }

    public int getSessionTimeout() {
        return this.protocol.getSessionTimeout();
    }

    public String getAllowUnsafeLegacyRenegotiation() {
        return this.allowUnsafeLegacyRenegotiation;
    }

    public String[] getSslEnabledProtocols() {
        return this.protocol.getSslEnabledProtocols();
    }

    public AsyncTimeout getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(AsyncTimeout asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    protected class AsyncTimeout
    implements Runnable {
        private volatile boolean asyncTimeoutRunning = true;

        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (this.asyncTimeoutRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (SocketWrapperBase socket : JIoEndpoint.this.waitingRequests) {
                    long access = socket.getLastAccess();
                    if (socket.getTimeout() <= 0L || now - access <= socket.getTimeout()) continue;
                    JIoEndpoint.this.processSocket(socket, SocketEvent.TIMEOUT, true);
                }
                while (JIoEndpoint.this.paused && this.asyncTimeoutRunning) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void stop() {
            this.asyncTimeoutRunning = false;
        }
    }

    public static class JIoSocketWrapper
    extends SocketWrapperBase<Socket> {
        private volatile boolean closed = false;
        private WritableByteChannel outputChannel = null;

        public JIoSocketWrapper(Socket socket, JIoEndpoint endpoint) throws IOException {
            super(socket, endpoint);
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.socketBufferHandler = new SocketBufferHandler(this.getEndpoint().socketProperties.getAppReadBufSize(), this.getEndpoint().socketProperties.getAppWriteBufSize(), this.getEndpoint().socketProperties.getDirectBuffer());
            this.outputChannel = Channels.newChannel(((Socket)this.getSocket()).getOutputStream());
        }

        @Override
        protected void populateRemoteHost() {
            InetAddress inetAddr = ((Socket)this.getSocket()).getInetAddress();
            if (inetAddr != null) {
                this.remoteHost = inetAddr.getHostName();
                if (this.remoteAddr == null) {
                    this.remoteAddr = inetAddr.getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemoteAddr() {
            InetAddress inetAddr = ((Socket)this.getSocket()).getInetAddress();
            if (inetAddr != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
        }

        @Override
        protected void populateRemotePort() {
            this.remotePort = ((Socket)this.getSocket()).getPort();
        }

        @Override
        protected void populateLocalName() {
            InetAddress inetAddr = ((Socket)this.getSocket()).getLocalAddress();
            if (inetAddr != null) {
                this.localName = inetAddr.getHostName();
            }
        }

        @Override
        protected void populateLocalAddr() {
            InetAddress inetAddr = ((Socket)this.getSocket()).getLocalAddress();
            if (inetAddr != null) {
                this.localAddr = inetAddr.getHostAddress();
            }
        }

        @Override
        protected void populateLocalPort() {
            this.localPort = ((Socket)this.getSocket()).getLocalPort();
        }

        @Override
        public int read(boolean block, byte[] b2, int off, int len) throws IOException {
            int nRead = ((Socket)this.getSocket()).getInputStream().read(b2, off, len);
            return nRead;
        }

        @Override
        public int read(boolean block, ByteBuffer to) throws IOException {
            int nRead = this.populateReadBuffer(to);
            return nRead;
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            return true;
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler handler) {
        }

        @Override
        protected void doClose() {
            block3: {
                if (log.isDebugEnabled()) {
                    log.debug("Calling [" + this.getEndpoint() + "].closeSocket([" + this + "])");
                }
                try {
                    ((Socket)this.getSocket()).close();
                    this.closed = true;
                }
                catch (Throwable e2) {
                    ExceptionUtils.handleThrowable(e2);
                    if (!log.isDebugEnabled()) break block3;
                    log.error(e2);
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        protected void doWrite(boolean block, ByteBuffer from) throws IOException {
            this.outputChannel.write(from);
        }

        @Override
        public void registerReadInterest() {
        }

        @Override
        public void registerWriteInterest() {
        }

        @Override
        public SendfileDataBase createSendfileData(String filename, long pos, long length) {
            return null;
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileData) {
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sslSupport) throws IOException {
        }

        @Override
        public SSLSupport getSslSupport(String clientCertProvider) {
            if (this.getEndpoint().isSSLEnabled()) {
                return ((JIoEndpoint)this.getEndpoint()).getSslImplementation().getSSLSupport((Socket)this.getSocket());
            }
            return null;
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean read, ByteBuffer[] buffers, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> completion) {
            return null;
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<Socket> {
        public SocketProcessor(SocketWrapperBase<Socket> socketWrapper, SocketEvent status) {
            super(socketWrapper, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState doRun() {
            boolean launch = false;
            SocketWrapperBase socketWrapperBase = this.socketWrapper;
            synchronized (socketWrapperBase) {
                try {
                    AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                    try {
                        JIoEndpoint.this.serverSocketFactory.handshake((Socket)this.socketWrapper.getSocket());
                    }
                    catch (Throwable t2) {
                        ExceptionUtils.handleThrowable(t2);
                        if (log.isDebugEnabled()) {
                            log.debug(AbstractEndpoint.sm.getString("endpoint.err.handshake"), t2);
                        }
                        state = AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.CLOSED) {
                        state = this.event == null ? JIoEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.OPEN_READ) : JIoEndpoint.this.getHandler().process(this.socketWrapper, this.event);
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        if (log.isTraceEnabled()) {
                            log.trace("Closing socket:" + this.socketWrapper);
                        }
                        JIoEndpoint.this.countDownConnection();
                        try {
                            ((Socket)this.socketWrapper.getSocket()).close();
                        }
                        catch (IOException iOException) {}
                    } else if (state == AbstractEndpoint.Handler.SocketState.OPEN || state == AbstractEndpoint.Handler.SocketState.UPGRADING || state == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                        this.socketWrapper.access();
                        launch = true;
                    } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.socketWrapper.access();
                        JIoEndpoint.this.waitingRequests.add(this.socketWrapper);
                    }
                }
                finally {
                    block31: {
                        if (launch) {
                            try {
                                JIoEndpoint.this.getExecutor().execute(new SocketProcessor(this.socketWrapper, SocketEvent.OPEN_READ));
                            }
                            catch (RejectedExecutionException x2) {
                                log.warn("Socket reprocessing request was rejected for:" + this.socketWrapper, x2);
                                try {
                                    JIoEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.DISCONNECT);
                                }
                                finally {
                                    JIoEndpoint.this.countDownConnection();
                                }
                            }
                            catch (NullPointerException npe) {
                                if (!JIoEndpoint.this.running) break block31;
                                log.error(AbstractEndpoint.sm.getString("endpoint.launch.fail"), npe);
                            }
                        }
                    }
                }
            }
            this.socketWrapper = null;
            return null;
        }
    }

    protected class JioAcceptor
    extends Acceptor {
        private JIoEndpoint endpoint;

        public JioAcceptor(JIoEndpoint endpoint) {
            super(endpoint);
            this.endpoint = endpoint;
        }

        @Override
        public void run() {
            JIoEndpoint.this.waitPortBound();
            int errorDelay = 0;
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused && JIoEndpoint.this.running) {
                    this.state = Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!JIoEndpoint.this.running) break;
                this.state = Acceptor.AcceptorState.RUNNING;
                try {
                    JIoEndpoint.this.countUpOrAwaitConnection();
                    Socket socket = null;
                    try {
                        socket = JIoEndpoint.this.serverSocketFactory.acceptSocket(JIoEndpoint.this.serverSocket);
                    }
                    catch (IOException ioe) {
                        JIoEndpoint.this.countDownConnection();
                        errorDelay = this.handleExceptionWithDelay(errorDelay);
                        throw ioe;
                    }
                    errorDelay = 0;
                    if (JIoEndpoint.this.running && !JIoEndpoint.this.paused && JIoEndpoint.this.setSocketOptions(socket)) {
                        if (JIoEndpoint.this.processSocket(socket)) continue;
                        JIoEndpoint.this.countDownConnection();
                        JIoEndpoint.this.closeSocket(socket);
                        continue;
                    }
                    JIoEndpoint.this.countDownConnection();
                    JIoEndpoint.this.closeSocket(socket);
                }
                catch (IOException x2) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error(AbstractEndpoint.sm.getString("endpoint.accept.fail"), x2);
                }
                catch (NullPointerException npe) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error(AbstractEndpoint.sm.getString("endpoint.accept.fail"), npe);
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                    log.error(AbstractEndpoint.sm.getString("endpoint.accept.fail"), t2);
                }
            }
            this.state = Acceptor.AcceptorState.ENDED;
        }
    }
}

