/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.AbstractProcessor;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.collections.SynchronizedQueue;
import com.bes.enterprise.web.util.collections.SynchronizedStack;
import com.bes.enterprise.web.util.compat.JreCompat;
import com.bes.enterprise.web.util.compat.JrePlatform;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.AbstractJsseEndpoint;
import com.bes.enterprise.web.util.net.ApplicationBufferHandler;
import com.bes.enterprise.web.util.net.NioChannel;
import com.bes.enterprise.web.util.net.SSLSupport;
import com.bes.enterprise.web.util.net.SecureNioChannel;
import com.bes.enterprise.web.util.net.SendfileDataBase;
import com.bes.enterprise.web.util.net.SendfileState;
import com.bes.enterprise.web.util.net.SocketBufferHandler;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketProcessorBase;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.net.jsse.JSSESupport;
import com.bes.enterprise.webtier.core.task.RequestDispatchUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class NioEndpoint
extends AbstractJsseEndpoint<NioChannel, SocketChannel> {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static final int OP_REGISTER = 256;
    private volatile ServerSocketChannel serverSock = null;
    private volatile CountDownLatch stopLatch = null;
    private SynchronizedStack<PollerEvent> eventCache;
    private SynchronizedStack<NioChannel> nioChannels;
    private SocketAddress previousAcceptedSocketRemoteAddress = null;
    private long previousAcceptedSocketNanoTime = 0L;
    private boolean useInheritedChannel = false;
    private int pollerThreadPriority = 5;
    private int pollerThreadCount = 1;
    private long selectorTimeout = 1000L;
    private boolean parseHeadersBySelectorThread = false;
    private Poller[] pollers = null;
    private AtomicInteger pollerRotater = new AtomicInteger(0);

    public void setUseInheritedChannel(boolean useInheritedChannel) {
        this.useInheritedChannel = useInheritedChannel;
    }

    public boolean getUseInheritedChannel() {
        return this.useInheritedChannel;
    }

    public void setPollerThreadPriority(int pollerThreadPriority) {
        this.pollerThreadPriority = pollerThreadPriority;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setSelectorTimeout(long timeout) {
        this.selectorTimeout = timeout;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    @Override
    public boolean isParseHeadersBySelectorThread() {
        return this.parseHeadersBySelectorThread;
    }

    public void setParseHeadersBySelectorThread(boolean parseHeadersBySelectorThread) {
        this.parseHeadersBySelectorThread = parseHeadersBySelectorThread;
    }

    public Poller getPoller0() {
        int idx = Math.abs(this.pollerRotater.incrementAndGet()) % this.pollers.length;
        return this.pollers[idx];
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int sum = 0;
        for (int i2 = 0; i2 < this.pollers.length; ++i2) {
            sum += this.pollers[i2].getKeyCount();
        }
        return sum;
    }

    @Override
    public void bind() throws Exception {
        if (!this.getUseInheritedChannel()) {
            this.serverSock = ServerSocketChannel.open();
            this.socketProperties.setProperties(this.serverSock.socket());
            InetSocketAddress addr = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
            this.serverSock.socket().bind(addr, this.getAcceptCount());
        } else {
            Channel ic = System.inheritedChannel();
            if (ic instanceof ServerSocketChannel) {
                this.serverSock = (ServerSocketChannel)ic;
            }
            if (this.serverSock == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.init.bind.inherited"));
            }
        }
        this.serverSock.configureBlocking(true);
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount <= 0) {
            this.pollerThreadCount = 1;
        }
        this.setStopLatch(new CountDownLatch(this.pollerThreadCount));
        this.initialiseSsl();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            this.eventCache = new SynchronizedStack(128, this.socketProperties.getEventCache());
            this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.pollers = new Poller[this.getPollerThreadCount()];
            String namePrefix = "SelectorReaderThread-" + this.getPort() + "-";
            for (int i2 = 0; i2 < this.pollers.length; ++i2) {
                this.pollers[i2] = new Poller();
                Thread pollerThread = new Thread((Runnable)this.pollers[i2], namePrefix + (i2 + 1));
                pollerThread.setPriority(this.threadPriority);
                pollerThread.setDaemon(true);
                pollerThread.start();
            }
            this.startAcceptorThread();
        }
    }

    @Override
    public void stopInternal() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.acceptor.stop(10);
            for (int i2 = 0; this.pollers != null && i2 < this.pollers.length; ++i2) {
                if (this.pollers[i2] == null) continue;
                this.pollers[i2].destroy();
                this.pollers[i2] = null;
            }
            try {
                if (this.getStopLatch() != null && !this.getStopLatch().await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS)) {
                    log.warn(sm.getString("endpoint.nio.stopLatchAwaitFail"));
                }
            }
            catch (InterruptedException e2) {
                log.warn(sm.getString("endpoint.nio.stopLatchAwaitInterrupted"), e2);
            }
            this.shutdownExecutor();
            this.eventCache.clear();
            this.nioChannels.clear();
            this.processorCache.clear();
        }
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPort()));
        }
        if (this.running) {
            this.stop();
        }
        this.doCloseServerSocket();
        this.destroySsl();
        super.unbind();
        if (this.getHandler() != null) {
            this.getHandler().recycle();
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPort()));
        }
    }

    @Override
    protected void doCloseServerSocket() throws IOException {
        if (!this.getUseInheritedChannel() && this.serverSock != null) {
            this.serverSock.close();
        }
        this.serverSock = null;
    }

    protected SynchronizedStack<NioChannel> getNioChannels() {
        return this.nioChannels;
    }

    protected CountDownLatch getStopLatch() {
        return this.stopLatch;
    }

    protected void setStopLatch(CountDownLatch stopLatch) {
        this.stopLatch = stopLatch;
    }

    @Override
    protected boolean setSocketOptions(SocketChannel socket) {
        NioSocketWrapper socketWrapper = null;
        try {
            NioChannel channel = this.nioChannels.pop();
            if (channel == null) {
                SocketBufferHandler bufhandler = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                channel = this.isSSLEnabled() ? new SecureNioChannel(bufhandler, this) : new NioChannel(bufhandler);
            }
            NioSocketWrapper newWrapper = new NioSocketWrapper(channel, this);
            channel.reset(socket, newWrapper);
            this.connections.put(socket, newWrapper);
            socketWrapper = newWrapper;
            socket.configureBlocking(false);
            this.socketProperties.setProperties(socket.socket());
            socketWrapper.setReadTimeout(this.getConnectionTimeout());
            socketWrapper.setWriteTimeout(this.getConnectionTimeout());
            socketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            this.getPoller0().register(socketWrapper);
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            try {
                log.error("", t2);
            }
            catch (Throwable tt) {
                ExceptionUtils.handleThrowable(tt);
            }
            if (socketWrapper == null) {
                this.destroySocket(socket);
            }
            return false;
        }
        return true;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected void destroySocket(SocketChannel socket) {
        block2: {
            this.countDownConnection();
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(sm.getString("endpoint.err.close"), ioe);
            }
        }
    }

    @Override
    protected NetworkChannel getServerSocket() {
        return this.serverSock;
    }

    @Override
    protected SocketChannel serverSocketAccept() throws Exception {
        SocketChannel result = this.serverSock.accept();
        if (!JrePlatform.IS_WINDOWS) {
            SocketAddress currentRemoteAddress = result.getRemoteAddress();
            long currentNanoTime = System.nanoTime();
            if (currentRemoteAddress.equals(this.previousAcceptedSocketRemoteAddress) && currentNanoTime - this.previousAcceptedSocketNanoTime < 1000L) {
                throw new IOException(sm.getString("endpoint.err.duplicateAccept"));
            }
            this.previousAcceptedSocketRemoteAddress = currentRemoteAddress;
            this.previousAcceptedSocketNanoTime = currentNanoTime;
        }
        return result;
    }

    @Override
    protected SocketProcessorBase<NioChannel> createSocketProcessor(SocketWrapperBase<NioChannel> socketWrapper, SocketEvent event) {
        return new SocketProcessor(socketWrapper, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processSocket(SocketWrapperBase<NioChannel> socketWrapper, SocketEvent event, boolean dispatch) {
        block17: {
            try {
                if (socketWrapper == null) {
                    return false;
                }
                SocketProcessorBase<NioChannel> sc = (SocketProcessorBase<NioChannel>)this.processorCache.pop();
                if (sc == null) {
                    sc = this.createSocketProcessor(socketWrapper, event);
                } else {
                    sc.reset(socketWrapper, event);
                }
                Executor executor = this.getExecutor();
                if (dispatch && executor != null) {
                    if (this.isParseHeadersBySelectorThread()) {
                        AbstractEndpoint.Handler.SocketState state = null;
                        SocketWrapperBase<NioChannel> socketWrapperBase = socketWrapper;
                        synchronized (socketWrapperBase) {
                            state = sc.doRun();
                        }
                        if (state != null && state == AbstractEndpoint.Handler.SocketState.PARSED_HEADER) {
                            sc = (SocketProcessorBase<NioChannel>)this.processorCache.pop();
                            if (sc == null) {
                                sc = this.createSocketProcessor(socketWrapper, event);
                            } else if (SocketEvent.OPEN_WRITE == event) {
                                sc.reset(socketWrapper, SocketEvent.OPEN_READ);
                            } else {
                                sc.reset(socketWrapper, event);
                            }
                            AbstractProcessor processor = this.getHandler().getProcessor(socketWrapper);
                            boolean isReject = RequestDispatchUtil.doDispatchTask(processor, executor, sc, socketWrapper, this);
                            if (isReject) {
                                return false;
                            }
                        }
                        break block17;
                    }
                    executor.execute(sc);
                    break block17;
                }
                sc.run();
            }
            catch (RejectedExecutionException ree) {
                this.getLog().warn(sm.getString("endpoint.executor.fail", socketWrapper), ree);
                return false;
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                this.getLog().error(sm.getString("endpoint.process.fail"), t2);
                return false;
            }
        }
        return true;
    }

    public static class SendfileData
    extends SendfileDataBase {
        protected volatile FileChannel fchannel;

        public SendfileData(String filename, long pos, long length) {
            super(filename, pos, length);
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<NioChannel> {
        public SocketProcessor(SocketWrapperBase<NioChannel> socketWrapper, SocketEvent event) {
            super(socketWrapper, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractEndpoint.Handler.SocketState doRun() {
            AbstractEndpoint.Handler.SocketState state = null;
            Poller poller = ((NioChannel)this.socketWrapper.getSocket()).getSocketWrapper().poller;
            if (poller == null) {
                this.socketWrapper.close();
                return null;
            }
            try {
                int handshake = -1;
                try {
                    if (((NioChannel)this.socketWrapper.getSocket()).isHandshakeComplete()) {
                        handshake = 0;
                    } else if (this.event == SocketEvent.STOP || this.event == SocketEvent.DISCONNECT || this.event == SocketEvent.ERROR) {
                        handshake = -1;
                    } else {
                        handshake = ((NioChannel)this.socketWrapper.getSocket()).handshake(this.event == SocketEvent.OPEN_READ, this.event == SocketEvent.OPEN_WRITE);
                        this.event = SocketEvent.OPEN_READ;
                    }
                }
                catch (IOException x2) {
                    handshake = -1;
                    if (log.isDebugEnabled()) {
                        log.debug("Error during SSL handshake", x2);
                    }
                }
                catch (CancelledKeyException ckx) {
                    handshake = -1;
                }
                if (handshake == 0) {
                    state = AbstractEndpoint.Handler.SocketState.OPEN;
                    state = this.event == null ? NioEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.OPEN_READ) : NioEndpoint.this.getHandler().process(this.socketWrapper, this.event);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
                    }
                } else if (handshake == -1) {
                    NioEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.CONNECT_FAIL);
                    poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
                } else if (handshake == 1) {
                    this.socketWrapper.registerReadInterest();
                } else if (handshake == 4) {
                    this.socketWrapper.registerWriteInterest();
                }
            }
            catch (CancelledKeyException cx) {
                poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
            }
            catch (VirtualMachineError vme) {
                ExceptionUtils.handleThrowable(vme);
            }
            catch (Throwable t2) {
                log.error("", t2);
                poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
            }
            finally {
                this.socketWrapper = null;
                this.event = null;
                if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                    NioEndpoint.this.processorCache.push(this);
                }
            }
            return state;
        }

        private SelectionKey getSelectionKey() {
            if (JreCompat.isJre11Available()) {
                return null;
            }
            SocketChannel socketChannel = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel();
            if (socketChannel == null) {
                return null;
            }
            NioChannel socket = (NioChannel)this.socketWrapper.getSocket();
            Poller poller = socket.getSocketWrapper().poller;
            return socketChannel.keyFor(poller.getSelector());
        }
    }

    public static class NioSocketWrapper
    extends SocketWrapperBase<NioChannel> {
        private final SynchronizedStack<NioChannel> nioChannels;
        private Poller poller;
        private int interestOps = 0;
        private volatile SendfileData sendfileData = null;
        private volatile long lastRead;
        private volatile long lastWrite = this.lastRead = System.currentTimeMillis();
        private final Object readLock;
        private volatile boolean readBlocking = false;
        private final Object writeLock;
        private volatile boolean writeBlocking = false;

        public NioSocketWrapper(NioChannel channel, NioEndpoint endpoint) {
            super(channel, endpoint);
            this.nioChannels = endpoint.getNioChannels();
            this.socketBufferHandler = channel.getBufHandler();
            this.readLock = this.readPending == null ? new Object() : this.readPending;
            this.writeLock = this.writePending == null ? new Object() : this.writePending;
        }

        public Poller getPoller() {
            return this.poller;
        }

        public void setPoller(Poller poller) {
            this.poller = poller;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int ops) {
            this.interestOps = ops;
            return ops;
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void updateLastWrite() {
            this.lastWrite = System.currentTimeMillis();
        }

        public long getLastWrite() {
            return this.lastWrite;
        }

        public void updateLastRead() {
            this.lastRead = System.currentTimeMillis();
        }

        public long getLastRead() {
            return this.lastRead;
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            if (this.socketBufferHandler.getReadBuffer().remaining() > 0) {
                return true;
            }
            this.fillReadBuffer(false);
            boolean isReady = this.socketBufferHandler.getReadBuffer().position() > 0;
            return isReady;
        }

        @Override
        public int read(boolean block, byte[] b2, int off, int len) throws IOException {
            int nRead = this.populateReadBuffer(b2, off, len);
            if (nRead > 0) {
                return nRead;
            }
            nRead = this.fillReadBuffer(block);
            this.updateLastRead();
            if (nRead > 0) {
                this.socketBufferHandler.configureReadBufferForRead();
                nRead = Math.min(nRead, len);
                this.socketBufferHandler.getReadBuffer().get(b2, off, nRead);
            }
            return nRead;
        }

        @Override
        public int read(boolean block, ByteBuffer to) throws IOException {
            int nRead = this.populateReadBuffer(to);
            if (nRead > 0) {
                return nRead;
            }
            int limit = this.socketBufferHandler.getReadBuffer().capacity();
            if (to.remaining() >= limit) {
                to.limit(to.position() + limit);
                nRead = this.fillReadBuffer(block, to);
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read direct from socket: [" + nRead + "]");
                }
                this.updateLastRead();
            } else {
                nRead = this.fillReadBuffer(block);
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read into buffer: [" + nRead + "]");
                }
                this.updateLastRead();
                if (nRead > 0) {
                    nRead = this.populateReadBuffer(to);
                }
            }
            return nRead;
        }

        @Override
        protected void doClose() {
            block13: {
                if (log.isDebugEnabled()) {
                    log.debug("Calling [" + this.getEndpoint() + "].closeSocket([" + this + "])");
                }
                try {
                    this.getEndpoint().connections.remove(((NioChannel)this.getSocket()).getIOChannel());
                    if (((NioChannel)this.getSocket()).isOpen()) {
                        ((NioChannel)this.getSocket()).close(true);
                    }
                    if (this.getEndpoint().running && (this.nioChannels == null || !this.nioChannels.push((NioChannel)this.getSocket()))) {
                        ((NioChannel)this.getSocket()).free();
                    }
                }
                catch (Throwable e2) {
                    ExceptionUtils.handleThrowable(e2);
                    if (log.isDebugEnabled()) {
                        log.error(sm.getString("endpoint.debug.channelCloseFail"), e2);
                    }
                }
                finally {
                    this.socketBufferHandler = SocketBufferHandler.EMPTY;
                    this.nonBlockingWriteBuffer.clear();
                    this.reset(NioChannel.CLOSED_NIO_CHANNEL);
                }
                try {
                    SendfileData data = this.getSendfileData();
                    if (data != null && data.fchannel != null && data.fchannel.isOpen()) {
                        data.fchannel.close();
                    }
                }
                catch (Throwable e3) {
                    ExceptionUtils.handleThrowable(e3);
                    if (!log.isDebugEnabled()) break block13;
                    log.error(sm.getString("endpoint.sendfile.closeError"), e3);
                }
            }
        }

        private int fillReadBuffer(boolean block) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(block, this.socketBufferHandler.getReadBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int fillReadBuffer(boolean block, ByteBuffer buffer) throws IOException {
            int n2;
            if (this.getSocket() == NioChannel.CLOSED_NIO_CHANNEL) {
                throw new ClosedChannelException();
            }
            if (block) {
                long timeout = this.getReadTimeout();
                long startNanos = 0L;
                do {
                    if (startNanos > 0L) {
                        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                        if (elapsedMillis == 0L) {
                            elapsedMillis = 1L;
                        }
                        if ((timeout -= elapsedMillis) <= 0L) {
                            throw new SocketTimeoutException();
                        }
                    }
                    if ((n2 = ((NioChannel)this.getSocket()).read(buffer)) == -1) {
                        throw new EOFException();
                    }
                    if (n2 != 0) continue;
                    if (!this.readBlocking) {
                        this.readBlocking = true;
                        this.registerReadInterest();
                    }
                    Object object = this.readLock;
                    synchronized (object) {
                        if (this.readBlocking) {
                            try {
                                if (timeout > 0L) {
                                    startNanos = System.nanoTime();
                                    this.readLock.wait(timeout);
                                } else {
                                    this.readLock.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                } while (n2 == 0);
            } else {
                n2 = ((NioChannel)this.getSocket()).read(buffer);
                if (n2 == -1) {
                    throw new EOFException();
                }
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(boolean block, ByteBuffer buffer) throws IOException {
            int n2 = 0;
            if (this.getSocket() == NioChannel.CLOSED_NIO_CHANNEL) {
                throw new ClosedChannelException();
            }
            if (block) {
                if (this.previousIOException != null) {
                    throw new IOException(this.previousIOException);
                }
                long timeout = this.getWriteTimeout();
                long startNanos = 0L;
                do {
                    if (startNanos > 0L) {
                        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                        if (elapsedMillis == 0L) {
                            elapsedMillis = 1L;
                        }
                        if ((timeout -= elapsedMillis) <= 0L) {
                            this.previousIOException = new SocketTimeoutException();
                            throw this.previousIOException;
                        }
                    }
                    if ((n2 = ((NioChannel)this.getSocket()).write(buffer)) == -1) {
                        throw new EOFException();
                    }
                    if (n2 == 0 && (buffer.hasRemaining() || ((NioChannel)this.getSocket()).getOutboundRemaining() > 0)) {
                        this.writeBlocking = true;
                        this.registerWriteInterest();
                        Object object = this.writeLock;
                        synchronized (object) {
                            if (this.writeBlocking) {
                                try {
                                    if (timeout > 0L) {
                                        startNanos = System.nanoTime();
                                        this.writeLock.wait(timeout);
                                    } else {
                                        this.writeLock.wait();
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                this.writeBlocking = false;
                            }
                        }
                    }
                    if (startNanos <= 0L) continue;
                    timeout = this.getWriteTimeout();
                    startNanos = 0L;
                } while (buffer.hasRemaining() || ((NioChannel)this.getSocket()).getOutboundRemaining() > 0);
            } else {
                do {
                    if ((n2 = ((NioChannel)this.getSocket()).write(buffer)) != -1) continue;
                    throw new EOFException();
                } while (n2 > 0 && buffer.hasRemaining());
            }
            this.updateLastWrite();
        }

        @Override
        public void registerReadInterest() {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("endpoint.debug.registerRead", this));
            }
            this.getPoller().add(this, 1);
        }

        @Override
        public void registerWriteInterest() {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("endpoint.debug.registerWrite", this));
            }
            this.getPoller().add(this, 4);
        }

        @Override
        public SendfileDataBase createSendfileData(String filename, long pos, long length) {
            return new SendfileData(filename, pos, length);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileData) {
            this.setSendfileData((SendfileData)sendfileData);
            SelectionKey key = ((NioChannel)this.getSocket()).getIOChannel().keyFor(this.getPoller().getSelector());
            return this.getPoller().processSendfile(key, this, true);
        }

        @Override
        protected void populateRemoteAddr() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getInetAddress();
            if (inetAddr != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
        }

        @Override
        protected void populateRemoteHost() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getInetAddress();
            if (inetAddr != null) {
                this.remoteHost = inetAddr.getHostName();
                if (this.remoteAddr == null) {
                    this.remoteAddr = inetAddr.getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemotePort() {
            this.remotePort = ((NioChannel)this.getSocket()).getIOChannel().socket().getPort();
        }

        @Override
        protected void populateLocalName() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalAddress();
            if (inetAddr != null) {
                this.localName = inetAddr.getHostName();
            }
        }

        @Override
        protected void populateLocalAddr() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalAddress();
            if (inetAddr != null) {
                this.localAddr = inetAddr.getHostAddress();
            }
        }

        @Override
        protected void populateLocalPort() {
            this.localPort = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalPort();
        }

        @Override
        public SSLSupport getSslSupport(String clientCertProvider) {
            SecureNioChannel ch;
            SSLEngine sslEngine;
            if (this.getSocket() instanceof SecureNioChannel && (sslEngine = (ch = (SecureNioChannel)this.getSocket()).getSslEngine()) != null) {
                SSLSession session = sslEngine.getSession();
                return ((NioEndpoint)this.getEndpoint()).getSslImplementation().getSSLSupport(session);
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sslSupport) throws IOException {
            SecureNioChannel sslChannel = (SecureNioChannel)this.getSocket();
            SSLEngine engine = sslChannel.getSslEngine();
            if (!engine.getNeedClientAuth()) {
                engine.setNeedClientAuth(true);
                sslChannel.rehandshake(this.getEndpoint().getConnectionTimeout());
                ((JSSESupport)sslSupport).setSession(engine.getSession());
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler handler) {
            ((NioChannel)this.getSocket()).setAppReadBufHandler(handler);
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean read, ByteBuffer[] buffers, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> completion) {
            return new NioOperationState(read, buffers, offset, length, block, timeout, unit, attachment, check, handler, semaphore, completion);
        }

        private class NioOperationState<A>
        extends SocketWrapperBase.OperationState<A> {
            private volatile boolean inline;

            private NioOperationState(boolean read, ByteBuffer[] buffers, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> completion) {
                super(NioSocketWrapper.this, read, buffers, offset, length, block, timeout, unit, attachment, check, handler, semaphore, completion);
                this.inline = true;
            }

            @Override
            protected boolean isInline() {
                return this.inline;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long nBytes = 0L;
                if (NioSocketWrapper.this.getError() == null) {
                    try {
                        NioOperationState nioOperationState = this;
                        synchronized (nioOperationState) {
                            if (!this.completionDone) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Skip concurrent " + (this.read ? "read" : "write") + " notification");
                                }
                                return;
                            }
                            if (this.read) {
                                if (!NioSocketWrapper.this.socketBufferHandler.isReadBufferEmpty()) {
                                    NioSocketWrapper.this.socketBufferHandler.configureReadBufferForRead();
                                    for (int i2 = 0; i2 < this.length && !NioSocketWrapper.this.socketBufferHandler.isReadBufferEmpty(); ++i2) {
                                        nBytes += (long)SocketWrapperBase.transfer(NioSocketWrapper.this.socketBufferHandler.getReadBuffer(), this.buffers[this.offset + i2]);
                                    }
                                }
                                if (nBytes == 0L) {
                                    nBytes = ((NioChannel)NioSocketWrapper.this.getSocket()).read(this.buffers, this.offset, this.length);
                                    NioSocketWrapper.this.updateLastRead();
                                }
                            } else {
                                boolean doWrite = true;
                                if (!NioSocketWrapper.this.socketBufferHandler.isWriteBufferEmpty()) {
                                    NioSocketWrapper.this.socketBufferHandler.configureWriteBufferForRead();
                                    do {
                                        nBytes = ((NioChannel)NioSocketWrapper.this.getSocket()).write(NioSocketWrapper.this.socketBufferHandler.getWriteBuffer());
                                    } while (!NioSocketWrapper.this.socketBufferHandler.isWriteBufferEmpty() && nBytes > 0L);
                                    if (!NioSocketWrapper.this.socketBufferHandler.isWriteBufferEmpty()) {
                                        doWrite = false;
                                    }
                                    if (nBytes > 0L) {
                                        nBytes = 0L;
                                    }
                                }
                                if (doWrite) {
                                    long n2 = 0L;
                                    do {
                                        if ((n2 = ((NioChannel)NioSocketWrapper.this.getSocket()).write(this.buffers, this.offset, this.length)) == -1L) {
                                            nBytes = n2;
                                            continue;
                                        }
                                        nBytes += n2;
                                    } while (n2 > 0L);
                                    NioSocketWrapper.this.updateLastWrite();
                                }
                            }
                            if (nBytes != 0L) {
                                this.completionDone = false;
                            }
                        }
                    }
                    catch (IOException e2) {
                        NioSocketWrapper.this.setError(e2);
                    }
                }
                if (nBytes > 0L) {
                    this.completion.completed(nBytes, this);
                } else if (nBytes < 0L || NioSocketWrapper.this.getError() != null) {
                    IOException error = NioSocketWrapper.this.getError();
                    if (error == null) {
                        error = new EOFException();
                    }
                    this.completion.failed((Throwable)error, this);
                } else {
                    this.inline = false;
                    if (this.read) {
                        NioSocketWrapper.this.registerReadInterest();
                    } else {
                        NioSocketWrapper.this.registerWriteInterest();
                    }
                }
            }
        }
    }

    public class Poller
    implements Runnable {
        private Selector selector;
        private final SynchronizedQueue<PollerEvent> events = new SynchronizedQueue();
        private volatile boolean close = false;
        private long nextExpiration = 0L;
        private AtomicLong wakeupCounter = new AtomicLong(0L);
        private volatile int keyCount = 0;

        public Poller() throws IOException {
            this.selector = Selector.open();
        }

        public int getKeyCount() {
            return this.keyCount;
        }

        public Selector getSelector() {
            return this.selector;
        }

        protected void destroy() {
            this.close = true;
            this.selector.wakeup();
        }

        private void addEvent(PollerEvent event) {
            this.events.offer(event);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        public void add(NioSocketWrapper socketWrapper, int interestOps) {
            PollerEvent r2 = (PollerEvent)NioEndpoint.this.eventCache.pop();
            if (r2 == null) {
                r2 = new PollerEvent(socketWrapper, interestOps);
            } else {
                r2.reset(socketWrapper, interestOps);
            }
            this.addEvent(r2);
            if (this.close) {
                NioEndpoint.this.processSocket(socketWrapper, SocketEvent.STOP, false);
            }
        }

        public boolean events() {
            boolean result = false;
            PollerEvent pe = null;
            int size = this.events.size();
            for (int i2 = 0; i2 < size && (pe = this.events.poll()) != null; ++i2) {
                result = true;
                NioSocketWrapper socketWrapper = pe.getSocketWrapper();
                SocketChannel sc = ((NioChannel)socketWrapper.getSocket()).getIOChannel();
                int interestOps = pe.getInterestOps();
                if (sc == null) {
                    log.warn(AbstractEndpoint.sm.getString("endpoint.nio.nullSocketChannel"));
                    socketWrapper.close();
                } else if (interestOps == 256) {
                    try {
                        sc.register(this.getSelector(), 1, socketWrapper);
                    }
                    catch (Exception x2) {
                        log.error(AbstractEndpoint.sm.getString("endpoint.nio.registerFail"), x2);
                    }
                } else {
                    SelectionKey key = sc.keyFor(this.getSelector());
                    if (key == null) {
                        socketWrapper.close();
                    } else {
                        NioSocketWrapper attachment = (NioSocketWrapper)key.attachment();
                        if (attachment != null) {
                            try {
                                int ops = key.interestOps() | interestOps;
                                attachment.interestOps(ops);
                                key.interestOps(ops);
                            }
                            catch (CancelledKeyException ckx) {
                                this.cancelledKey(key, socketWrapper);
                            }
                        } else {
                            this.cancelledKey(key, socketWrapper);
                        }
                    }
                }
                if (!NioEndpoint.this.running || NioEndpoint.this.eventCache == null) continue;
                pe.reset();
                NioEndpoint.this.eventCache.push(pe);
            }
            return result;
        }

        public void register(NioSocketWrapper socketWrapper) {
            socketWrapper.setPoller(this);
            socketWrapper.interestOps(1);
            PollerEvent event = null;
            if (NioEndpoint.this.eventCache != null) {
                event = (PollerEvent)NioEndpoint.this.eventCache.pop();
            }
            if (event == null) {
                event = new PollerEvent(socketWrapper, 256);
            } else {
                event.reset(socketWrapper, 256);
            }
            this.addEvent(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelledKey(SelectionKey sk, SocketWrapperBase<NioChannel> socketWrapper) {
            if (JreCompat.isJre11Available() && socketWrapper != null) {
                socketWrapper.close();
            } else {
                try {
                    if (sk != null) {
                        sk.attach(null);
                        if (sk.isValid()) {
                            sk.cancel();
                        }
                    }
                }
                catch (Throwable e2) {
                    ExceptionUtils.handleThrowable(e2);
                    if (log.isDebugEnabled()) {
                        log.error(AbstractEndpoint.sm.getString("endpoint.debug.channelCloseFail"), e2);
                    }
                }
                finally {
                    if (socketWrapper != null) {
                        socketWrapper.close();
                    }
                }
            }
        }

        @Override
        public void run() {
            while (true) {
                Iterator<SelectionKey> iterator;
                boolean hasEvents = false;
                try {
                    if (!this.close) {
                        hasEvents = this.events();
                        this.keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                        this.wakeupCounter.set(0L);
                    }
                    if (this.close) {
                        this.events();
                        this.timeout(0, false);
                        try {
                            this.selector.close();
                        }
                        catch (IOException ioe) {
                            log.error(AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), ioe);
                        }
                        break;
                    }
                }
                catch (Throwable x2) {
                    ExceptionUtils.handleThrowable(x2);
                    log.error("", x2);
                    continue;
                }
                if (this.keyCount == 0) {
                    hasEvents |= this.events();
                }
                Iterator<SelectionKey> iterator2 = iterator = this.keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                while (iterator != null && iterator.hasNext()) {
                    SelectionKey sk = iterator.next();
                    NioSocketWrapper attachment = (NioSocketWrapper)sk.attachment();
                    if (attachment == null) {
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                    this.processKey(sk, attachment);
                }
                this.timeout(this.keyCount, hasEvents);
            }
            if (NioEndpoint.this.getStopLatch() != null) {
                NioEndpoint.this.getStopLatch().countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processKey(SelectionKey sk, NioSocketWrapper socketWrapper) {
            try {
                if (this.close) {
                    this.cancelledKey(sk, socketWrapper);
                } else if (sk.isValid()) {
                    if (sk.isReadable() || sk.isWritable()) {
                        if (socketWrapper.getSendfileData() != null) {
                            this.processSendfile(sk, socketWrapper, false);
                        } else {
                            Object object;
                            this.unreg(sk, socketWrapper, sk.readyOps());
                            boolean closeSocket = false;
                            if (sk.isReadable()) {
                                if (socketWrapper.readOperation != null) {
                                    if (!socketWrapper.readOperation.process()) {
                                        closeSocket = true;
                                    }
                                } else if (socketWrapper.readBlocking) {
                                    object = socketWrapper.readLock;
                                    synchronized (object) {
                                        socketWrapper.readBlocking = false;
                                        socketWrapper.readLock.notify();
                                    }
                                } else if (!NioEndpoint.this.processSocket(socketWrapper, SocketEvent.OPEN_READ, true)) {
                                    closeSocket = true;
                                }
                            }
                            if (!closeSocket && sk.isWritable()) {
                                if (socketWrapper.writeOperation != null) {
                                    if (!socketWrapper.writeOperation.process()) {
                                        closeSocket = true;
                                    }
                                } else if (socketWrapper.writeBlocking) {
                                    object = socketWrapper.writeLock;
                                    synchronized (object) {
                                        socketWrapper.writeBlocking = false;
                                        socketWrapper.writeLock.notify();
                                    }
                                } else if (!NioEndpoint.this.processSocket(socketWrapper, SocketEvent.OPEN_WRITE, true)) {
                                    closeSocket = true;
                                }
                            }
                            if (closeSocket) {
                                this.cancelledKey(sk, socketWrapper);
                            }
                        }
                    }
                } else {
                    this.cancelledKey(sk, socketWrapper);
                }
            }
            catch (CancelledKeyException ckx) {
                this.cancelledKey(sk, socketWrapper);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                log.error("", t2);
            }
        }

        public SendfileState processSendfile(SelectionKey sk, NioSocketWrapper socketWrapper, boolean calledByProcessor) {
            NioChannel sc = null;
            try {
                ScatteringByteChannel wc;
                this.unreg(sk, socketWrapper, sk.readyOps());
                SendfileData sd = socketWrapper.getSendfileData();
                if (log.isTraceEnabled()) {
                    log.trace("Processing send file for: " + sd.fileName);
                }
                if (sd.fchannel == null) {
                    File f2 = new File(sd.fileName);
                    FileInputStream fis = new FileInputStream(f2);
                    sd.fchannel = fis.getChannel();
                }
                ScatteringByteChannel scatteringByteChannel = wc = (sc = (NioChannel)socketWrapper.getSocket()) instanceof SecureNioChannel ? sc : sc.getIOChannel();
                if (sc.getOutboundRemaining() > 0) {
                    if (sc.flushOutbound()) {
                        socketWrapper.updateLastWrite();
                    }
                } else {
                    long written = sd.fchannel.transferTo(sd.pos, sd.length, (WritableByteChannel)((Object)wc));
                    if (written > 0L) {
                        sd.pos += written;
                        sd.length -= written;
                        socketWrapper.updateLastWrite();
                    } else if (sd.fchannel.size() <= sd.pos) {
                        throw new IOException("Sendfile configured to send more data than was available");
                    }
                }
                if (sd.length <= 0L && sc.getOutboundRemaining() <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Send file complete for: " + sd.fileName);
                    }
                    socketWrapper.setSendfileData(null);
                    try {
                        sd.fchannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!calledByProcessor) {
                        switch (sd.keepAliveState) {
                            case NONE: {
                                if (log.isDebugEnabled()) {
                                    log.debug("Send file connection is being closed");
                                }
                                socketWrapper.getPoller().cancelledKey(sk, socketWrapper);
                                break;
                            }
                            case PIPELINED: {
                                if (log.isDebugEnabled()) {
                                    log.debug("Connection is keep alive, processing pipe-lined data");
                                }
                                if (NioEndpoint.this.processSocket(socketWrapper, SocketEvent.OPEN_READ, true)) break;
                                socketWrapper.getPoller().cancelledKey(sk, socketWrapper);
                                break;
                            }
                            case OPEN: {
                                if (log.isDebugEnabled()) {
                                    log.debug("Connection is keep alive, registering back for OP_READ");
                                }
                                this.reg(sk, socketWrapper, 1);
                            }
                        }
                    }
                    return SendfileState.DONE;
                }
                if (log.isDebugEnabled()) {
                    log.debug("OP_WRITE for sendfile: " + sd.fileName);
                }
                if (calledByProcessor) {
                    this.add(socketWrapper, 4);
                } else {
                    this.reg(sk, socketWrapper, 4);
                }
                return SendfileState.PENDING;
            }
            catch (IOException x2) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to complete sendfile request:", x2);
                }
                if (!calledByProcessor && sc != null) {
                    socketWrapper.getPoller().cancelledKey(sk, socketWrapper);
                }
                return SendfileState.ERROR;
            }
            catch (Throwable t2) {
                log.error("", t2);
                if (!calledByProcessor && sc != null) {
                    socketWrapper.getPoller().cancelledKey(sk, socketWrapper);
                }
                return SendfileState.ERROR;
            }
        }

        protected void unreg(SelectionKey sk, NioSocketWrapper attachment, int readyOps) {
            this.reg(sk, attachment, sk.interestOps() & ~readyOps);
        }

        protected void reg(SelectionKey sk, NioSocketWrapper attachment, int intops) {
            sk.interestOps(intops);
            attachment.interestOps(intops);
        }

        protected void timeout(int keyCount, boolean hasEvents) {
            long now = System.currentTimeMillis();
            if (this.nextExpiration > 0L && (keyCount > 0 || hasEvents) && now < this.nextExpiration && !this.close) {
                return;
            }
            int keycount = 0;
            try {
                for (SelectionKey key : this.selector.keys()) {
                    ++keycount;
                    NioSocketWrapper socketWrapper = (NioSocketWrapper)key.attachment();
                    try {
                        long timeout;
                        long delta;
                        if (socketWrapper == null) {
                            this.cancelledKey(key, null);
                            continue;
                        }
                        if (this.close) {
                            key.interestOps(0);
                            socketWrapper.interestOps(0);
                            this.cancelledKey(key, socketWrapper);
                            continue;
                        }
                        if ((socketWrapper.interestOps() & 1) != 1 && (socketWrapper.interestOps() & 4) != 4) continue;
                        boolean isTimedOut = false;
                        if ((socketWrapper.interestOps() & 1) == 1) {
                            delta = now - socketWrapper.getLastRead();
                            timeout = socketWrapper.getReadTimeout();
                            boolean bl = isTimedOut = timeout > 0L && delta > timeout;
                        }
                        if (!isTimedOut && (socketWrapper.interestOps() & 4) == 4) {
                            delta = now - socketWrapper.getLastWrite();
                            timeout = socketWrapper.getWriteTimeout();
                            boolean bl = isTimedOut = timeout > 0L && delta > timeout;
                        }
                        if (!isTimedOut) continue;
                        key.interestOps(0);
                        socketWrapper.interestOps(0);
                        socketWrapper.setError(new SocketTimeoutException());
                        if (NioEndpoint.this.processSocket(socketWrapper, SocketEvent.ERROR, true)) continue;
                        this.cancelledKey(key, socketWrapper);
                    }
                    catch (CancelledKeyException ckx) {
                        this.cancelledKey(key, socketWrapper);
                    }
                }
            }
            catch (ConcurrentModificationException cme) {
                log.warn(AbstractEndpoint.sm.getString("endpoint.nio.timeoutCme"), cme);
            }
            long prevExp = this.nextExpiration;
            this.nextExpiration = System.currentTimeMillis() + NioEndpoint.this.socketProperties.getTimeoutInterval();
            if (log.isTraceEnabled()) {
                log.trace("timeout completed: keys processed=" + keycount + "; now=" + now + "; nextExpiration=" + prevExp + "; keyCount=" + keyCount + "; hasEvents=" + hasEvents + "; eval=" + (now < prevExp && (keyCount > 0 || hasEvents) && !this.close));
            }
        }
    }

    public static class PollerEvent {
        private int interestOps;
        private NioSocketWrapper socketWrapper;

        public PollerEvent(NioSocketWrapper socketWrapper, int intOps) {
            this.reset(socketWrapper, intOps);
        }

        public void reset(NioSocketWrapper socketWrapper, int intOps) {
            this.socketWrapper = socketWrapper;
            this.interestOps = intOps;
        }

        public NioSocketWrapper getSocketWrapper() {
            return this.socketWrapper;
        }

        public int getInterestOps() {
            return this.interestOps;
        }

        public void reset() {
            this.reset(null, 0);
        }

        public String toString() {
            return "Poller event: socket [" + this.socketWrapper.getSocket() + "], socketWrapper [" + this.socketWrapper + "], interestOps [" + this.interestOps + "]";
        }
    }
}

