/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.net.JIoEndpoint;
import com.bes.enterprise.web.util.net.SSLHostConfigCertificate;
import com.bes.enterprise.web.util.net.SSLSupport;
import com.bes.enterprise.web.util.net.SSLUtil;
import com.bes.enterprise.web.util.net.ServerSocketFactory;
import com.bes.enterprise.web.util.net.jsse.JSSEImplementation;
import com.bes.enterprise.web.util.res.StringManager;
import java.net.Socket;
import javax.net.ssl.SSLSession;

public abstract class SSLImplementation {
    private static final Log logger = LogFactory.getLog(SSLImplementation.class);
    private static final StringManager sm = StringManager.getManager(SSLImplementation.class);

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return new JSSEImplementation();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            String msg = sm.getString("sslImplementation.cnfe", className);
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e2);
            }
            throw new ClassNotFoundException(msg, e2);
        }
    }

    public abstract ServerSocketFactory getServerSocketFactory(JIoEndpoint var1);

    public abstract SSLSupport getSSLSupport(Socket var1);

    public abstract SSLSupport getSSLSupport(SSLSession var1);

    public abstract SSLUtil getSSLUtil(SSLHostConfigCertificate var1);

    public abstract boolean isAlpnSupported();
}

