/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.web.util.buf.ByteBufferUtils;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class SocketBufferHandler {
    static SocketBufferHandler EMPTY = new SocketBufferHandler(0, 0, false){

        @Override
        public void expand(int newSize) {
        }

        @Override
        public void unReadReadBuffer(ByteBuffer returnedData) {
        }
    };
    private volatile boolean readBufferConfiguredForWrite = true;
    private volatile ByteBuffer readBuffer;
    private volatile boolean writeBufferConfiguredForWrite = true;
    private volatile ByteBuffer writeBuffer;
    private final boolean direct;

    public SocketBufferHandler(int readBufferSize, int writeBufferSize, boolean direct) {
        this.direct = direct;
        if (direct) {
            this.readBuffer = ByteBuffer.allocateDirect(readBufferSize);
            this.writeBuffer = ByteBuffer.allocateDirect(writeBufferSize);
        } else {
            this.readBuffer = ByteBuffer.allocate(readBufferSize);
            this.writeBuffer = ByteBuffer.allocate(writeBufferSize);
        }
    }

    public void unReadReadBuffer(ByteBuffer returnedData) {
        if (this.isReadBufferEmpty()) {
            this.configureReadBufferForWrite();
            this.readBuffer.put(returnedData);
        } else {
            int bytesReturned = returnedData.remaining();
            if (this.readBufferConfiguredForWrite) {
                int i2;
                if (this.readBuffer.position() + bytesReturned > this.readBuffer.capacity()) {
                    throw new BufferOverflowException();
                }
                for (i2 = 0; i2 < this.readBuffer.position(); ++i2) {
                    this.readBuffer.put(i2 + bytesReturned, this.readBuffer.get(i2));
                }
                for (i2 = 0; i2 < bytesReturned; ++i2) {
                    this.readBuffer.put(i2, returnedData.get());
                }
                this.readBuffer.position(this.readBuffer.position() + bytesReturned);
            } else {
                int insertOffset;
                int i3;
                int shiftRequired = bytesReturned - this.readBuffer.position();
                if (shiftRequired > 0) {
                    if (this.readBuffer.capacity() - this.readBuffer.limit() < shiftRequired) {
                        throw new BufferOverflowException();
                    }
                    int oldLimit = this.readBuffer.limit();
                    this.readBuffer.limit(oldLimit + shiftRequired);
                    for (i3 = this.readBuffer.position(); i3 < oldLimit; ++i3) {
                        this.readBuffer.put(i3 + shiftRequired, this.readBuffer.get(i3));
                    }
                } else {
                    shiftRequired = 0;
                }
                for (i3 = insertOffset = this.readBuffer.position() + shiftRequired - bytesReturned; i3 < bytesReturned + insertOffset; ++i3) {
                    this.readBuffer.put(i3, returnedData.get());
                }
                this.readBuffer.position(insertOffset);
            }
        }
    }

    public void configureReadBufferForWrite() {
        this.setReadBufferConfiguredForWrite(true);
    }

    public void configureReadBufferForRead() {
        this.setReadBufferConfiguredForWrite(false);
    }

    private void setReadBufferConfiguredForWrite(boolean readBufferConFiguredForWrite) {
        if (this.readBufferConfiguredForWrite != readBufferConFiguredForWrite) {
            if (readBufferConFiguredForWrite) {
                int remaining = this.readBuffer.remaining();
                if (remaining == 0) {
                    this.readBuffer.clear();
                } else {
                    this.readBuffer.compact();
                }
            } else {
                this.readBuffer.flip();
            }
            this.readBufferConfiguredForWrite = readBufferConFiguredForWrite;
        }
    }

    public ByteBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public boolean isReadBufferEmpty() {
        if (this.readBufferConfiguredForWrite) {
            return this.readBuffer.position() == 0;
        }
        return this.readBuffer.remaining() == 0;
    }

    public void configureWriteBufferForWrite() {
        this.setWriteBufferConfiguredForWrite(true);
    }

    public void configureWriteBufferForRead() {
        this.setWriteBufferConfiguredForWrite(false);
    }

    private void setWriteBufferConfiguredForWrite(boolean writeBufferConfiguredForWrite) {
        if (this.writeBufferConfiguredForWrite != writeBufferConfiguredForWrite) {
            if (writeBufferConfiguredForWrite) {
                int remaining = this.writeBuffer.remaining();
                if (remaining == 0) {
                    this.writeBuffer.clear();
                } else {
                    this.writeBuffer.compact();
                    this.writeBuffer.position(remaining);
                    this.writeBuffer.limit(this.writeBuffer.capacity());
                }
            } else {
                this.writeBuffer.flip();
            }
            this.writeBufferConfiguredForWrite = writeBufferConfiguredForWrite;
        }
    }

    public boolean isWriteBufferWritable() {
        if (this.writeBufferConfiguredForWrite) {
            return this.writeBuffer.hasRemaining();
        }
        return this.writeBuffer.remaining() == 0;
    }

    public ByteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }

    public boolean isWriteBufferEmpty() {
        if (this.writeBufferConfiguredForWrite) {
            return this.writeBuffer.position() == 0;
        }
        return this.writeBuffer.remaining() == 0;
    }

    public void reset() {
        this.readBuffer.clear();
        this.readBufferConfiguredForWrite = true;
        this.writeBuffer.clear();
        this.writeBufferConfiguredForWrite = true;
    }

    public void expand(int newSize) {
        this.configureReadBufferForWrite();
        this.readBuffer = ByteBufferUtils.expand(this.readBuffer, newSize);
        this.configureWriteBufferForWrite();
        this.writeBuffer = ByteBufferUtils.expand(this.writeBuffer, newSize);
    }

    public void free() {
        if (this.direct) {
            ByteBufferUtils.cleanDirectBuffer(this.readBuffer);
            ByteBufferUtils.cleanDirectBuffer(this.writeBuffer);
        }
    }
}

