/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads;

import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class WorkQueue
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = 1L;
    private volatile transient ThreadPoolExecutor parent = null;
    private Integer forcedRemainingCapacity = null;

    public WorkQueue() {
    }

    public WorkQueue(int capacity) {
        super(capacity);
    }

    public WorkQueue(Collection<? extends Runnable> c2) {
        super(c2);
    }

    public void setParent(ThreadPoolExecutor tp) {
        this.parent = tp;
    }

    public boolean force(Runnable o2) {
        if (this.parent == null || this.parent.isShutdown()) {
            throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
        }
        return super.offer(o2);
    }

    public boolean force(Runnable o2, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.parent == null || this.parent.isShutdown()) {
            throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
        }
        return super.offer(o2, timeout, unit);
    }

    @Override
    public boolean offer(Runnable o2) {
        if (this.parent == null) {
            return super.offer(o2);
        }
        if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
            return super.offer(o2);
        }
        if (this.parent.getSubmittedCount() <= this.parent.getPoolSize()) {
            return super.offer(o2);
        }
        if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(o2);
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        Runnable runnable = (Runnable)super.poll(timeout, unit);
        if (runnable == null && this.parent != null) {
            this.parent.stopCurrentThreadIfNeeded();
        }
        return runnable;
    }

    @Override
    public Runnable take() throws InterruptedException {
        if (this.parent != null && this.parent.currentThreadShouldBeStopped()) {
            return this.poll(this.parent.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        return (Runnable)super.take();
    }

    @Override
    public int remainingCapacity() {
        if (this.forcedRemainingCapacity != null) {
            return this.forcedRemainingCapacity;
        }
        return super.remainingCapacity();
    }

    public void setForcedRemainingCapacity(Integer forcedRemainingCapacity) {
        this.forcedRemainingCapacity = forcedRemainingCapacity;
    }
}

