/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads;

import com.bes.enterprise.web.util.security.PrivilegedSetTccl;
import com.bes.enterprise.web.util.threads.Constants;
import com.bes.enterprise.web.util.threads.WorkThread;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkThreadFactory
implements ThreadFactory {
    protected final ThreadGroup group;
    protected final AtomicInteger threadNumber = new AtomicInteger(1);
    protected final String namePrefix;
    protected final boolean daemon;
    protected final int threadPriority;

    public WorkThreadFactory(String namePrefix, boolean daemon, int priority) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix;
        this.daemon = daemon;
        this.threadPriority = priority;
    }

    public WorkThreadFactory(String groupName, String namePrefix, boolean daemon, int priority) {
        SecurityManager s2;
        this.group = groupName != null ? new ThreadGroup(groupName) : ((s2 = System.getSecurityManager()) != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup());
        this.namePrefix = namePrefix;
        this.daemon = daemon;
        this.threadPriority = priority;
    }

    @Override
    public Thread newThread(Runnable r2) {
        WorkThread t2 = this.createThread(r2);
        t2.setDaemon(this.daemon);
        t2.setPriority(this.threadPriority);
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedSetTccl pa = new PrivilegedSetTccl(t2, this.getClass().getClassLoader());
            AccessController.doPrivileged(pa);
        } else {
            t2.setContextClassLoader(this.getClass().getClassLoader());
        }
        return t2;
    }

    protected WorkThread createThread(Runnable r2) {
        return new WorkThread(this.group, r2, this.namePrefix + this.threadNumber.getAndIncrement());
    }
}

