/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads.trace;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.threads.WorkThread;
import com.bes.enterprise.web.util.threads.trace.TracedThreadPoolExecutor;

public class TracedThread
extends WorkThread {
    private static final Log log = LogFactory.getLog(TracedThreadPoolExecutor.class);
    private String threadPoolName;

    public TracedThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public TracedThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            super.run();
            if (!log.isInfoEnabled()) return;
        }
        catch (Throwable throwable) {
            if (!log.isInfoEnabled()) throw throwable;
            String name = this.getName();
            log.info(String.format("The thread pool %s destoryed thread %s.", this.threadPoolName, name));
            throw throwable;
        }
        String name = this.getName();
        log.info(String.format("The thread pool %s destoryed thread %s.", this.threadPoolName, name));
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }
}

