/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads.trace;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TracedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Log log = LogFactory.getLog(TracedThreadPoolExecutor.class);
    private String threadPoolName;

    public TracedThreadPoolExecutor(String threadPoolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.threadPoolName = threadPoolName;
    }

    public TracedThreadPoolExecutor(String threadPoolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.threadPoolName = threadPoolName;
    }

    public TracedThreadPoolExecutor(String threadPoolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.threadPoolName = threadPoolName;
    }

    public TracedThreadPoolExecutor(String threadPoolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.threadPoolName = threadPoolName;
    }

    @Override
    protected void beforeExecute(Thread t2, Runnable r2) {
        if (log.isInfoEnabled()) {
            String name = t2.getName();
            log.info(String.format("The thread pool %s allocated thread %s.", this.threadPoolName, name));
        }
        super.beforeExecute(t2, r2);
    }

    @Override
    protected void afterExecute(Runnable r2, Throwable t2) {
        if (log.isInfoEnabled()) {
            String name = Thread.currentThread().getName();
            log.info(String.format("The thread pool %s recycled thread %s.", this.threadPoolName, name));
        }
        super.afterExecute(r2, t2);
    }
}

