/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads.trace;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.threads.WorkThread;
import com.bes.enterprise.web.util.threads.WorkThreadFactory;
import com.bes.enterprise.web.util.threads.trace.TracedThread;
import com.bes.enterprise.web.util.threads.trace.TracedThreadPoolExecutor;

public class TracedWorkThreadFactory
extends WorkThreadFactory {
    private static final Log log = LogFactory.getLog(TracedThreadPoolExecutor.class);
    private String threadPoolName;

    public TracedWorkThreadFactory(String threadPoolName, String namePrefix, boolean daemon, int priority) {
        super(namePrefix, daemon, priority);
        this.threadPoolName = threadPoolName;
    }

    public TracedWorkThreadFactory(String threadPoolName, String groupName, String namePrefix, boolean daemon, int priority) {
        super(groupName, namePrefix, daemon, priority);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public Thread newThread(Runnable r2) {
        Thread thread = super.newThread(r2);
        if (log.isInfoEnabled()) {
            String name = thread.getName();
            log.info(String.format("The thread pool %s created thread %s.", this.threadPoolName, name));
        }
        return thread;
    }

    @Override
    protected WorkThread createThread(Runnable r2) {
        TracedThread tracedThread = new TracedThread(this.group, r2, this.namePrefix + this.threadNumber.getAndIncrement());
        tracedThread.setThreadPoolName(this.threadPoolName);
        return tracedThread;
    }
}

