/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.authenticator;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.authenticator.DigestAuthenticator;
import com.bes.enterprise.webtier.realm.RealmBase;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BESDigestAuthenticator
extends DigestAuthenticator {
    protected static final String INITIATOR_HEADER_NAME = "BES-Digest-Initiator";
    protected static final String HASH_HEADER_NAME = "BES-Digest-Hash";

    @Override
    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, String nonce, boolean isNonceStale) {
        super.setAuthenticateHeader(request, response, nonce, isNonceStale);
        String initiator = request.getHeader(INITIATOR_HEADER_NAME);
        if (StringUtils.isBlank(initiator)) {
            return;
        }
        Realm realm = this.context.getRealm();
        if (!(realm instanceof RealmBase)) {
            return;
        }
        String realmName = BESDigestAuthenticator.getRealmName(this.context);
        String digest = ((RealmBase)RealmBase.class.cast(realm)).getDigest(initiator, realmName);
        response.setHeader(HASH_HEADER_NAME, digest == null ? "" : digest);
    }
}

