/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.connector;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.security.SecurityUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class BufferedInputStream
extends ServletInputStream {
    protected static final StringManager sm = StringManager.getManager(BufferedInputStream.class);
    private ByteArrayInputStream postCached;

    protected BufferedInputStream(ByteArrayInputStream data) {
        this.postCached = data;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public int read() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = BufferedInputStream.this.postCached.read();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.postCached.read();
    }

    @Override
    public int available() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = BufferedInputStream.this.postCached.available();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.postCached.available();
    }

    @Override
    public int read(final byte[] b2) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = BufferedInputStream.this.postCached.read(b2, 0, b2.length);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.postCached.read(b2, 0, b2.length);
    }

    @Override
    public int read(final byte[] b2, final int off, final int len) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = BufferedInputStream.this.postCached.read(b2, off, len);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.postCached.read(b2, off, len);
    }

    @Override
    public int readLine(byte[] b2, int off, int len) throws IOException {
        return super.readLine(b2, off, len);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isFinished() {
        return this.postCached.available() <= 0;
    }

    @Override
    public boolean isReady() {
        return this.isFinished();
    }

    @Override
    public void setReadListener(ReadListener listener) {
        throw new UnsupportedOperationException();
    }
}

