/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.connector;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.Adapter;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import com.bes.enterprise.web.crane.http11.AbstractHttp11JsseProtocol;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.buf.B2CConverter;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.web.util.net.openssl.OpenSSLImplementation;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.connector.CoyoteAdapter;
import com.bes.enterprise.webtier.connector.Request;
import com.bes.enterprise.webtier.connector.Response;
import com.bes.enterprise.webtier.core.NativeLifecycleListener;
import com.bes.enterprise.webtier.mapper.Mapper;
import com.bes.enterprise.webtier.mapper.MapperListener;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.management.ObjectName;

public class Connector
extends LifecycleMBeanBase {
    private static final Log log = LogFactory.getLog(Connector.class);
    public static final boolean RECYCLE_FACADES = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.webtier.connector.RECYCLE_FACADES", "false"));
    protected String name = null;
    protected Service service = null;
    protected boolean allowTrace = false;
    protected long asyncTimeout = 30000L;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = false;
    protected int port = -1;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected static final StringManager sm = StringManager.getManager(Connector.class);
    private int maxCookieCount = 200;
    protected int maxParameterCount = 10000;
    private int maxPartCount = Integer.MAX_VALUE;
    private int maxPartHeaderSize = Integer.MAX_VALUE;
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected String parseBodyMethods = "POST";
    protected HashSet<String> parseBodyMethodsSet;
    protected boolean useIPVHosts = false;
    protected String defaultVirtualServer = "localhost";
    protected String protocolHandlerClassName = "com.bes.enterprise.web.crane.http11.Http11NioProtocol";
    protected final ProtocolHandler protocolHandler;
    protected Mapper mapper = new Mapper();
    protected MapperListener mapperListener = new MapperListener(this.mapper, this);
    protected Adapter adapter = null;
    @Deprecated
    protected String URIEncoding = null;
    @Deprecated
    protected String URIEncodingLower = null;
    private Charset uriCharset = StandardCharsets.UTF_8;
    protected boolean useBodyEncodingForURI = false;
    private Charset defaultRequestCharacterEncoding;
    private Charset defaultResponseCharacterEncoding;
    protected static final HashMap<String, String> replacements = new HashMap();

    public Connector() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector(String protocol) {
        this.setProtocol(protocol);
        ProtocolHandler p2 = null;
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            p2 = (ProtocolHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            log.error(sm.getString("coyoteConnector.protocolHandlerInstantiationFailed"), e2);
        }
        finally {
            this.protocolHandler = p2;
        }
        this.uriCharset = Globals.STRICT_SERVLET_COMPLIANCE ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8;
        this.setThrowOnFailure(Boolean.getBoolean("com.bes.enterprise.startup.ExitOnInitFailure"));
    }

    public Object getProperty(String name) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.getProperty(this.protocolHandler, repl);
    }

    public boolean setProperty(String name, String value) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.setProperty(this.protocolHandler, repl, value);
    }

    public Object getAttribute(String name) {
        return this.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        this.setProperty(name, String.valueOf(value));
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
        this.mapperListener.setService(service);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setProperty("connectorName", name);
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
        this.setProperty("asyncTimeout", String.valueOf(asyncTimeout));
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int maxCookieCount) {
        this.maxCookieCount = maxCookieCount;
    }

    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public void setMaxParameterCount(int maxParameterCount) {
        this.maxParameterCount = maxParameterCount;
        this.setProperty("maxParameterCount", String.valueOf(maxParameterCount));
    }

    public int getMaxPartCount() {
        return this.maxPartCount;
    }

    public void setMaxPartCount(int maxPartCount) {
        this.maxPartCount = maxPartCount;
    }

    public int getMaxPartHeaderSize() {
        return this.maxPartHeaderSize;
    }

    public void setMaxPartHeaderSize(int maxPartHeaderSize) {
        this.maxPartHeaderSize = maxPartHeaderSize;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
        this.setProperty("maxPostSize", String.valueOf(maxPostSize));
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
        this.setProperty("maxSavePostSize", String.valueOf(maxSavePostSize));
    }

    public String getParseBodyMethods() {
        return this.parseBodyMethods;
    }

    public void setParseBodyMethods(String methods) {
        HashSet<String> methodSet = new HashSet<String>();
        if (null != methods) {
            methodSet.addAll(Arrays.asList(methods.split("\\s*,\\s*")));
        }
        if (methodSet.contains("TRACE")) {
            throw new IllegalArgumentException(sm.getString("coyoteConnector.parseBodyMethodNoTrace"));
        }
        this.parseBodyMethods = methods;
        this.parseBodyMethodsSet = methodSet;
        this.setProperty("parseBodyMethods", methods);
    }

    protected boolean isParseBodyMethod(String method) {
        return this.parseBodyMethodsSet.contains(method);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public int getLocalPort() {
        return (Integer)this.getProperty("localPort");
    }

    public String getProtocol() {
        if ("com.bes.enterprise.web.crane.http11.Http11NioProtocol".equals(this.getProtocolHandlerClassName()) && (!NativeLifecycleListener.isNativeAvailable() || !NativeLifecycleListener.getUseNativeConnector()) || "com.bes.enterprise.web.crane.http11.Http11NativeProtocol".equals(this.getProtocolHandlerClassName()) && NativeLifecycleListener.getUseNativeConnector()) {
            return "HTTP/1.1";
        }
        if ("com.bes.enterprise.web.crane.ajp.AjpNioProtocol".equals(this.getProtocolHandlerClassName()) && (!NativeLifecycleListener.isNativeAvailable() || !NativeLifecycleListener.getUseNativeConnector()) || "com.bes.enterprise.web.crane.ajp.AjpNativeProtocol".equals(this.getProtocolHandlerClassName()) && NativeLifecycleListener.getUseNativeConnector()) {
            return "AJP/1.3";
        }
        return this.getProtocolHandlerClassName();
    }

    @Deprecated
    public void setProtocol(String protocol) {
        boolean NativeConnector;
        if ("com.bes.enterprise.web.crane.http11.Http11NativeProtocol".equals(protocol)) {
            new NativeLifecycleListener();
        }
        boolean bl = NativeConnector = NativeLifecycleListener.isNativeAvailable() && NativeLifecycleListener.getUseNativeConnector();
        if ("HTTP/1.1".equals(protocol) || protocol == null) {
            if (NativeConnector) {
                this.setProtocolHandlerClassName("com.bes.enterprise.web.crane.http11.Http11NativeProtocol");
            } else {
                this.setProtocolHandlerClassName("com.bes.enterprise.web.crane.http11.Http11NioProtocol");
            }
        } else if ("AJP/1.3".equals(protocol)) {
            if (NativeConnector) {
                this.setProtocolHandlerClassName("com.bes.enterprise.web.crane.ajp.AjpNativeProtocol");
            } else {
                this.setProtocolHandlerClassName("com.bes.enterprise.web.crane.ajp.AjpNioProtocol");
            }
        } else {
            this.setProtocolHandlerClassName(protocol);
        }
    }

    public String getDefaultVirtualServer() {
        return this.defaultVirtualServer;
    }

    public void setDefaultVirtualServer(String defaultVirtualHost) {
        this.defaultVirtualServer = defaultVirtualHost;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    @Deprecated
    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName != null && proxyName.length() > 0 ? proxyName : null;
        this.setProperty("proxyName", this.proxyName);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", Boolean.toString(secure));
    }

    public String getURIEncoding() {
        return this.uriCharset.name();
    }

    @Deprecated
    public String getURIEncodingLower() {
        return this.uriCharset.name().toLowerCase(Locale.ENGLISH);
    }

    public Charset getURICharset() {
        return this.uriCharset;
    }

    public void setURIEncoding(String URIEncoding) {
        try {
            this.uriCharset = B2CConverter.getCharset(URIEncoding);
        }
        catch (UnsupportedEncodingException e2) {
            log.warn(sm.getString("coyoteConnector.invalidEncoding", URIEncoding, this.uriCharset.name()), e2);
        }
        this.setProperty("uRIEncoding", URIEncoding);
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
        this.setProperty("useBodyEncodingForURI", String.valueOf(useBodyEncodingForURI));
    }

    public Charset getDefaultRequestCharacterEncoding() {
        return this.defaultRequestCharacterEncoding;
    }

    public void setDefaultRequestCharacterEncoding(String requestCharacterEncoding) {
        if (requestCharacterEncoding != null) {
            try {
                this.defaultRequestCharacterEncoding = Charset.forName(requestCharacterEncoding);
            }
            catch (UnsupportedCharsetException e2) {
                log.error("Not supported charset: " + requestCharacterEncoding);
            }
        }
    }

    public Charset getDefaultResponseCharacterEncoding() {
        return this.defaultResponseCharacterEncoding;
    }

    public void setDefaultResponseCharacterEncoding(String responseCharacterEncoding) {
        if (responseCharacterEncoding != null) {
            try {
                this.defaultResponseCharacterEncoding = Charset.forName(responseCharacterEncoding);
            }
            catch (UnsupportedCharsetException e2) {
                log.error("Not supported charset: " + responseCharacterEncoding);
            }
        }
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.useIPVHosts = useIPVHosts;
        this.setProperty("useIPVHosts", String.valueOf(useIPVHosts));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public String getExecutorName() {
        java.util.concurrent.Executor obj = this.protocolHandler.getExecutor();
        if (obj instanceof Executor) {
            return ((Executor)obj).getName();
        }
        return "Internal";
    }

    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.protocolHandler.addSslHostConfig(sslHostConfig);
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.protocolHandler.findSslHostConfigs();
    }

    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.protocolHandler.addUpgradeProtocol(upgradeProtocol);
    }

    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.protocolHandler.findUpgradeProtocols();
    }

    public Request createRequest() {
        Request request = new Request();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    public String createObjectNameKeyProperties(String type) {
        Object addressObj = this.getProperty("address");
        StringBuilder sb = new StringBuilder("type=");
        sb.append(type);
        sb.append(",port=");
        int port = this.getPort();
        if (port > 0) {
            sb.append(port);
        } else {
            sb.append("auto-");
            sb.append(this.getProperty("nameIndex"));
        }
        String address = "";
        if (addressObj instanceof InetAddress) {
            address = ((InetAddress)addressObj).getHostAddress();
        } else if (addressObj != null) {
            address = addressObj.toString();
        }
        if (address.length() > 0) {
            sb.append(",address=");
            sb.append(ObjectName.quote(address));
        }
        return sb.toString();
    }

    public void pause() {
        try {
            this.protocolHandler.pause();
        }
        catch (Exception e2) {
            log.error(sm.getString("coyoteConnector.protocolHandlerPauseFailed"), e2);
        }
    }

    public void resume() {
        try {
            this.protocolHandler.resume();
        }
        catch (Exception e2) {
            log.error(sm.getString("coyoteConnector.protocolHandlerResumeFailed"), e2);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        AbstractHttp11JsseProtocol jsseProtocolHandler;
        super.initInternal();
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        if (null == this.parseBodyMethodsSet) {
            this.setParseBodyMethods(this.getParseBodyMethods());
        }
        if (this.protocolHandler.isNativeRequired() && !NativeLifecycleListener.isNativeAvailable()) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerNoNative", this.getProtocolHandlerClassName()));
        }
        if (NativeLifecycleListener.isNativeAvailable() && NativeLifecycleListener.getUseOpenSSL() && this.protocolHandler instanceof AbstractHttp11JsseProtocol && (jsseProtocolHandler = (AbstractHttp11JsseProtocol)this.protocolHandler).isSSLEnabled() && jsseProtocolHandler.getSslImplementationName() == null) {
            jsseProtocolHandler.setSslImplementationName(OpenSSLImplementation.class.getName());
        }
        try {
            this.protocolHandler.init(this.name);
        }
        catch (Exception e2) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerInitializationFailed"), e2);
        }
        this.mapperListener.init();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.getPort() < 0) {
            throw new LifecycleException(sm.getString("coyoteConnector.invalidPort", this.getPort()));
        }
        this.setState(LifecycleState.STARTING);
        try {
            this.protocolHandler.start();
        }
        catch (Exception e2) {
            String errPrefix = "";
            if (this.service != null) {
                errPrefix = errPrefix + "service.getName(): \"" + this.service.getName() + "\"; ";
            }
            throw new LifecycleException(errPrefix + " " + sm.getString("coyoteConnector.protocolHandlerStartFailed"), e2);
        }
        finally {
            this.mapperListener.start();
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        try {
            this.protocolHandler.stop();
        }
        catch (Exception e2) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerStopFailed"), e2);
        }
        this.mapperListener.stop();
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.mapperListener.destroy();
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e2) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerDestroyFailed"), e2);
        }
        if (this.getService() != null) {
            this.getService().removeConnector(this);
        }
        super.destroyInternal();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Connector[");
        sb.append(this.getProtocol());
        sb.append('-');
        int port = this.getPort();
        if (port > 0) {
            sb.append(port);
        } else {
            sb.append("auto-");
            sb.append(this.getProperty("nameIndex"));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected String getDomainInternal() {
        Service s2 = this.getService();
        if (s2 == null) {
            return null;
        }
        return this.service.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.createObjectNameKeyProperties("Connector");
    }

    static {
        replacements.put("rootFile", "rootfile");
    }
}

