/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.connector;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.crane.BadRequestException;
import com.bes.enterprise.web.crane.Constants;
import com.bes.enterprise.web.crane.ContainerThreadMarker;
import com.bes.enterprise.web.util.buf.B2CConverter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.CharChunk;
import com.bes.enterprise.web.util.collections.SynchronizedStack;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.connector.ClientAbortException;
import com.bes.enterprise.webtier.connector.Request;
import com.bes.enterprise.webtier.connector.Response;
import com.bes.enterprise.webtier.security.SecurityUtil;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ReadListener;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel,
CharChunk.CharOutputChannel {
    protected static final StringManager sm = StringManager.getManager(InputBuffer.class);
    private static final Log log = LogFactory.getLog(InputBuffer.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private static final ConcurrentMap<Charset, SynchronizedStack<B2CConverter>> encoders = new ConcurrentHashMap<Charset, SynchronizedStack<B2CConverter>>();
    private ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private boolean closed = false;
    private String enc;
    protected B2CConverter conv;
    private com.bes.enterprise.web.crane.Request coyoteRequest;
    private int markPos = -1;
    private final int size;

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int size) {
        this.size = size;
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteInputChannel(this);
        this.cb = new CharChunk(size);
        this.cb.setLimit(size);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharInputChannel(this);
        this.cb.setCharOutputChannel(this);
    }

    public void setRequest(com.bes.enterprise.web.crane.Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
    }

    public void recycle() {
        this.state = 0;
        if (this.cb.getChars().length > this.size) {
            this.cb = new CharChunk(this.size);
            this.cb.setLimit(this.size);
            this.cb.setOptimizedWrite(false);
            this.cb.setCharInputChannel(this);
            this.cb.setCharOutputChannel(this);
        } else {
            this.cb.recycle();
        }
        this.markPos = -1;
        this.bb.recycle();
        this.closed = false;
        if (this.conv != null) {
            this.conv.recycle();
            ((SynchronizedStack)encoders.get(this.conv.getCharset())).push(this.conv);
            this.conv = null;
        }
        this.enc = null;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public int available() {
        int available = this.availableInThisBuffer();
        if (available == 0) {
            this.coyoteRequest.action(ActionCode.AVAILABLE, this.coyoteRequest.getReadListener() != null);
            available = this.coyoteRequest.getAvailable() > 0 ? 1 : 0;
        }
        return available;
    }

    private int availableInThisBuffer() {
        int available = 0;
        if (this.state == 2) {
            available = this.bb.getLength();
        } else if (this.state == 1) {
            available = this.cb.getLength();
        }
        return available;
    }

    public void setReadListener(ReadListener listener) {
        this.coyoteRequest.setReadListener(listener);
        if (!this.coyoteRequest.isFinished() && this.isReady()) {
            this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
            if (!ContainerThreadMarker.isContainerThread()) {
                this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
            }
        }
    }

    public boolean isFinished() {
        int available = 0;
        if (this.state == 2) {
            available = this.bb.getLength();
        } else if (this.state == 1) {
            available = this.cb.getLength();
        }
        if (available > 0) {
            return false;
        }
        return this.coyoteRequest.isFinished();
    }

    public boolean isReady() {
        if (this.coyoteRequest.getReadListener() == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("inputBuffer.requiresNonBlocking"));
            }
            return false;
        }
        if (this.isFinished()) {
            if (!ContainerThreadMarker.isContainerThread()) {
                this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
            }
            return false;
        }
        if (this.availableInThisBuffer() > 0) {
            return true;
        }
        AtomicBoolean result = new AtomicBoolean();
        this.coyoteRequest.action(ActionCode.NB_READ_INTEREST, result);
        return result.get();
    }

    boolean isBlocking() {
        return this.coyoteRequest.getReadListener() == null;
    }

    @Override
    public int realReadBytes() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.coyoteRequest == null) {
            return -1;
        }
        if (this.state == 0) {
            this.state = 2;
        }
        try {
            return this.coyoteRequest.doRead(this.bb);
        }
        catch (BadRequestException bre) {
            this.handleReadException(bre);
            throw bre;
        }
        catch (IOException ioe) {
            this.handleReadException(ioe);
            throw new ClientAbortException(ioe);
        }
    }

    private void handleReadException(Exception e2) throws IOException {
        Request request = (Request)this.coyoteRequest.getNote(1);
        Response response = request.getResponse();
        request.setAttribute("javax.servlet.error.exception", e2);
        response.sendError(400);
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.checkByteBufferEof()) {
            return -1;
        }
        return this.bb.substract();
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.checkByteBufferEof()) {
            return -1;
        }
        return this.bb.substract(b2, off, len);
    }

    public int read(ByteBuffer to) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.checkByteBufferEof()) {
            return -1;
        }
        return this.bb.substract(to);
    }

    @Deprecated
    public void setEncoding(String s2) {
        this.enc = s2;
    }

    @Override
    public int realReadChars() throws IOException {
        int nRead;
        this.checkConverter();
        boolean eof = false;
        if (this.bb.getLength() <= 0 && (nRead = this.realReadBytes()) < 0) {
            eof = true;
        }
        if (this.markPos == -1) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else {
            this.cb.makeSpace(this.bb.getLength());
            if (this.cb.getBuffer().length - this.cb.getEnd() == 0 && this.bb.getLength() != 0) {
                this.cb.setOffset(0);
                this.cb.setEnd(0);
                this.markPos = -1;
            }
        }
        this.state = 1;
        this.conv.convert(this.bb, this.cb, eof);
        if (this.cb.getLength() == 0 && eof) {
            return -1;
        }
        return this.cb.getLength();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.checkCharBufferEof()) {
            return -1;
        }
        return this.cb.substract();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.checkCharBufferEof()) {
            return -1;
        }
        return this.cb.substract(cbuf, off, len);
    }

    @Override
    public long skip(long n2) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (n2 < 0L) {
            throw new IllegalArgumentException();
        }
        long nRead = 0L;
        while (nRead < n2) {
            if ((long)this.cb.getLength() >= n2) {
                this.cb.setOffset(this.cb.getStart() + (int)n2);
                nRead = n2;
                continue;
            }
            nRead += (long)this.cb.getLength();
            this.cb.setOffset(this.cb.getEnd());
            int nb = this.realReadChars();
            if (nb >= 0) continue;
            break;
        }
        return nRead;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 0) {
            this.state = 1;
        }
        return this.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.cb.getLength() <= 0) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else if (this.cb.getBuffer().length > 2 * this.size && this.cb.getLength() < this.cb.getStart()) {
            System.arraycopy(this.cb.getBuffer(), this.cb.getStart(), this.cb.getBuffer(), 0, this.cb.getLength());
            this.cb.setEnd(this.cb.getLength());
            this.cb.setOffset(0);
        }
        this.cb.setLimit(this.cb.getStart() + readAheadLimit + this.size);
        this.markPos = this.cb.getStart();
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 1) {
            if (this.markPos < 0) {
                this.cb.recycle();
                this.markPos = -1;
                throw new IOException();
            }
            this.cb.setOffset(this.markPos);
        } else {
            this.bb.recycle();
        }
    }

    public void checkConverter() throws IOException {
        SynchronizedStack stack;
        if (this.conv != null) {
            return;
        }
        Charset charset = null;
        if (this.coyoteRequest != null) {
            charset = this.coyoteRequest.getCharset();
        }
        if (charset == null) {
            charset = this.enc == null ? Constants.DEFAULT_BODY_CHARSET : B2CConverter.getCharset(this.enc);
        }
        if ((stack = (SynchronizedStack)encoders.get(charset)) == null) {
            stack = new SynchronizedStack();
            encoders.putIfAbsent(charset, stack);
            stack = (SynchronizedStack)encoders.get(charset);
        }
        this.conv = (B2CConverter)stack.pop();
        if (this.conv == null) {
            this.conv = InputBuffer.createConverter(charset);
        }
    }

    private static B2CConverter createConverter(final Charset charset) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<B2CConverter>(){

                    @Override
                    public B2CConverter run() throws IOException {
                        return new B2CConverter(charset);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception e2 = ex.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new IOException(e2);
            }
        }
        return new B2CConverter(charset);
    }

    private boolean checkByteBufferEof() throws IOException {
        int n2;
        return this.bb.getLength() == 0 && (n2 = this.realReadBytes()) < 0;
    }

    private boolean checkCharBufferEof() throws IOException {
        int n2;
        return this.cb.getLength() == 0 && (n2 = this.realReadChars()) < 0;
    }

    @Override
    public void realWriteChars(char[] buf, int off, int len) throws IOException {
        this.markPos = -1;
        this.cb.setOffset(-1);
        this.cb.setEnd(0);
    }
}

