/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.CharChunk;
import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.buf.UDecoder;
import com.bes.enterprise.web.util.descriptor.web.FilterDef;
import com.bes.enterprise.web.util.http.RequestUtil;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.ApplicationContextFacade;
import com.bes.enterprise.webtier.core.ApplicationDispatcher;
import com.bes.enterprise.webtier.core.ApplicationFilterRegistration;
import com.bes.enterprise.webtier.core.ApplicationMapping;
import com.bes.enterprise.webtier.core.ApplicationServletRegistration;
import com.bes.enterprise.webtier.core.ApplicationSessionCookieConfig;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.mapper.MappingData;
import com.bes.enterprise.webtier.servlet4preview.http.HttpServletMapping;
import com.bes.enterprise.webtier.util.Introspection;
import com.bes.enterprise.webtier.util.ServerInfo;
import com.bes.enterprise.webtier.util.URLEncoder;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class ApplicationContext
implements com.bes.enterprise.webtier.servlet4preview.ServletContext {
    protected static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    protected static final boolean GET_RESOURCE_REQUIRE_SLASH;
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> readOnlyAttributes = new ConcurrentHashMap<String, String>();
    private final DefaultContext context;
    private final Service service;
    private static final List<String> emptyString;
    private static final List<Servlet> emptyServlet;
    private final ServletContext facade = new ApplicationContextFacade(this);
    private final ConcurrentMap<String, String> parameters = new ConcurrentHashMap<String, String>();
    private static final StringManager sm;
    private final ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private SessionCookieConfig sessionCookieConfig;
    private Set<SessionTrackingMode> sessionTrackingModes = null;
    private Set<SessionTrackingMode> defaultSessionTrackingModes = null;
    private Set<SessionTrackingMode> supportedSessionTrackingModes = null;
    private boolean newServletContextListenerAllowed = true;

    public ApplicationContext(DefaultContext context) {
        this.context = context;
        this.service = ((Engine)context.getParent().getParent()).getService();
        this.sessionCookieConfig = new ApplicationSessionCookieConfig(context);
        if (context.getBesWebJspPageEncoding() != null) {
            this.setAttribute("com.bes.enterprise.web.jsp.defaultEncoding", context.getBesWebJspPageEncoding());
        }
        this.populateSessionTrackingModes();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.attributes.keySet());
        return Collections.enumeration(names);
    }

    @Override
    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        Context child = null;
        try {
            Container host = this.context.getParent();
            child = (Context)host.findChild(uri);
            if (child != null && !child.getState().isAvailable()) {
                child = null;
            }
            if (child == null) {
                int i2 = uri.indexOf("##");
                if (i2 > -1) {
                    uri = uri.substring(0, i2);
                }
                MessageBytes hostMB = MessageBytes.newInstance();
                hostMB.setString(host.getName());
                MessageBytes pathMB = MessageBytes.newInstance();
                pathMB.setString(uri);
                MappingData mappingData = new MappingData();
                for (Connector connector : this.service.findConnectors()) {
                    connector.getMapper().map(hostMB, pathMB, null, mappingData);
                    if (mappingData.context != null) break;
                    mappingData.recycle();
                }
                child = mappingData.context;
            }
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            return null;
        }
        if (child == null) {
            return null;
        }
        if (this.context.getCrossContext()) {
            return child.getServletContext();
        }
        if (child == this.context) {
            return this.context.getServletContext();
        }
        return null;
    }

    @Override
    public String getContextPath() {
        return this.context.getPath();
    }

    @Override
    public String getInitParameter(String name) {
        if ("com.bes.enterprise.web.jasper.XML_VALIDATE_TLD".equals(name) && this.context.getTldValidation()) {
            return "true";
        }
        if ("com.bes.enterprise.web.jasper.XML_BLOCK_EXTERNAL".equals(name) && !this.context.getXmlBlockExternal()) {
            return "false";
        }
        return (String)this.parameters.get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        HashSet<Object> names = new HashSet<Object>();
        names.addAll(this.parameters.keySet());
        if (this.context.getTldValidation()) {
            names.add("com.bes.enterprise.web.jasper.XML_VALIDATE_TLD");
        }
        if (!this.context.getXmlBlockExternal()) {
            names.add("com.bes.enterprise.web.jasper.XML_BLOCK_EXTERNAL");
        }
        return Collections.enumeration(names);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(extension);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(name);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationDispatcher(wrapper, null, null, null, null, null, name);
    }

    @Override
    public String getRealPath(String path) {
        String validatedPath = this.validateResourcePath(path, true);
        return this.context.getRealPath(validatedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        String queryString;
        String uri;
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        int pos = path.indexOf(63);
        if (pos >= 0) {
            uri = path.substring(0, pos);
            queryString = path.substring(pos + 1);
        } else {
            uri = path;
            queryString = null;
        }
        String uriNoParams = ApplicationContext.stripPathParams(uri);
        String normalizedUri = RequestUtil.normalize(uriNoParams);
        if (normalizedUri == null) {
            return null;
        }
        if (this.getContext().getDispatchersUseEncodedPaths()) {
            String decodedUri = UDecoder.URLDecode(normalizedUri);
            if (!decodedUri.equals(normalizedUri = RequestUtil.normalize(decodedUri))) {
                this.getContext().getLogger().warn(sm.getString("applicationContext.illegalDispatchPath", path), new IllegalArgumentException());
                return null;
            }
            uri = URLEncoder.DEFAULT.encode(this.getContextPath(), StandardCharsets.UTF_8) + uri;
        } else {
            uri = URLEncoder.DEFAULT.encode(this.getContextPath() + uri, StandardCharsets.UTF_8);
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        }
        MessageBytes uriMB = dd.uriMB;
        uriMB.recycle();
        MappingData mappingData = dd.mappingData;
        try {
            block19: {
                CharChunk uriCC = uriMB.getCharChunk();
                try {
                    uriCC.append(this.context.getPath());
                    uriCC.append(normalizedUri);
                    if (this.context.getParent() instanceof DefaultHost) break block19;
                    RequestDispatcher requestDispatcher = null;
                    return requestDispatcher;
                }
                catch (Exception e2) {
                    this.log(sm.getString("applicationContext.mapping.error"), e2);
                    RequestDispatcher requestDispatcher = null;
                    return requestDispatcher;
                }
            }
            DefaultHost host = (DefaultHost)this.context.getParent();
            for (Connector connector : this.service.findConnectors()) {
                if (!this.match(connector, host)) continue;
                connector.getMapper().map(this.context, uriMB, mappingData);
                break;
            }
            if (mappingData.wrapper == null) {
                Connector[] connectorArray = null;
                return connectorArray;
            }
            Wrapper wrapper = mappingData.wrapper;
            String wrapperPath = mappingData.wrapperPath.toString();
            String pathInfo = mappingData.pathInfo.toString();
            HttpServletMapping mapping = new ApplicationMapping(mappingData).getHttpServletMapping();
            ApplicationDispatcher applicationDispatcher = new ApplicationDispatcher(wrapper, uri, wrapperPath, pathInfo, queryString, mapping, null);
            return applicationDispatcher;
        }
        finally {
            mappingData.recycle();
        }
    }

    static String stripPathParams(String input) {
        if (input.indexOf(59) < 0) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        int pos = 0;
        int limit = input.length();
        while (pos < limit) {
            int nextSemiColon = input.indexOf(59, pos);
            if (nextSemiColon < 0) {
                nextSemiColon = limit;
            }
            sb.append(input.substring(pos, nextSemiColon));
            int followingSlash = input.indexOf(47, nextSemiColon);
            if (followingSlash < 0) {
                pos = limit;
                continue;
            }
            pos = followingSlash;
        }
        return sb.toString();
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        String validatedPath = this.validateResourcePath(path, false);
        if (validatedPath == null) {
            throw new MalformedURLException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        WebResourceRoot resources = this.context.getResources();
        if (resources != null) {
            return resources.getResource(validatedPath).getURL();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        String validatedPath = this.validateResourcePath(path, false);
        if (validatedPath == null) {
            return null;
        }
        WebResourceRoot resources = this.context.getResources();
        if (resources != null) {
            return resources.getResource(validatedPath).getInputStream();
        }
        return null;
    }

    private String validateResourcePath(String path, boolean allowEmptyPath) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0 && allowEmptyPath) {
            return path;
        }
        if (!path.startsWith("/")) {
            if (GET_RESOURCE_REQUIRE_SLASH) {
                return null;
            }
            return "/" + path;
        }
        return path;
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.resourcePaths.iae", path));
        }
        WebResourceRoot resources = this.context.getResources();
        if (resources != null) {
            return resources.listWebAppPaths(path);
        }
        return null;
    }

    @Override
    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    @Override
    @Deprecated
    public Servlet getServlet(String name) {
        return null;
    }

    @Override
    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    @Override
    @Deprecated
    public Enumeration<String> getServletNames() {
        return Collections.enumeration(emptyString);
    }

    @Override
    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return Collections.enumeration(emptyServlet);
    }

    @Override
    public void log(String message) {
        this.context.getLogger().info(message);
    }

    @Override
    @Deprecated
    public void log(Exception exception, String message) {
        this.context.getLogger().error(message, exception);
    }

    @Override
    public void log(String message, Throwable throwable) {
        this.context.getLogger().error(message, throwable);
    }

    @Override
    public void removeAttribute(String name) {
        Object value = null;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        value = this.attributes.remove(name);
        if (value == null) {
            return;
        }
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (Object obj : listeners) {
            if (!(obj instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)obj;
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                this.log(sm.getString("applicationContext.attributeEvent"), t2);
            }
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        Object oldValue = this.attributes.put(name, value);
        boolean replaced = oldValue != null;
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (Object obj : listeners) {
            if (!(obj instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)obj;
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), t2);
            }
        }
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.addFilter(filterName, className, null);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.addFilter(filterName, null, filter);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.addFilter(filterName, filterClass.getName(), null);
    }

    private FilterRegistration.Dynamic addFilter(String filterName, String filterClass, Filter filter) throws IllegalStateException {
        if (filterName == null || filterName.equals("")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.invalidFilterName", filterName));
        }
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.addFilter.ise", this.getContextPath()));
        }
        FilterDef filterDef = this.context.findFilterDef(filterName);
        if (filterDef == null) {
            filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            this.context.addFilterDef(filterDef);
        } else if (filterDef.getFilterName() != null && filterDef.getFilterClass() != null) {
            return null;
        }
        if (filter == null) {
            filterDef.setFilterClass(filterClass);
        } else {
            filterDef.setFilterClass(filter.getClass().getName());
            filterDef.setFilter(filter);
        }
        return new ApplicationFilterRegistration(filterDef, this.context);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> c2) throws ServletException {
        try {
            Filter filter = (Filter)this.context.getInstanceManager().newInstance(c2.getName());
            return (T)filter;
        }
        catch (InvocationTargetException e2) {
            ExceptionUtils.handleThrowable(e2.getCause());
            throw new ServletException(e2);
        }
        catch (ReflectiveOperationException | NamingException e3) {
            throw new ServletException(e3);
        }
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        FilterDef filterDef = this.context.findFilterDef(filterName);
        if (filterDef == null) {
            return null;
        }
        return new ApplicationFilterRegistration(filterDef, this.context);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.addServlet(servletName, className, null, null);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.addServlet(servletName, null, servlet, null);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.addServlet(servletName, servletClass.getName(), null, null);
    }

    @Override
    public ServletRegistration.Dynamic addJspFile(String jspName, String jspFile) {
        if (jspFile == null || !jspFile.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addJspFile.iae", jspFile));
        }
        String jspServletClassName = null;
        HashMap<String, String> jspFileInitParams = new HashMap<String, String>();
        Wrapper jspServlet = (Wrapper)this.context.findChild("jsp");
        if (jspServlet == null) {
            jspServletClassName = "com.bes.enterprise.web.jasper.servlet.JspServlet";
        } else {
            String[] params;
            jspServletClassName = jspServlet.getServletClass();
            for (String param : params = jspServlet.findInitParameters()) {
                jspFileInitParams.put(param, jspServlet.findInitParameter(param));
            }
        }
        jspFileInitParams.put("jspFile", jspFile);
        return this.addServlet(jspName, jspServletClassName, null, jspFileInitParams);
    }

    private ServletRegistration.Dynamic addServlet(String servletName, String servletClass, Servlet servlet, Map<String, String> initParams) throws IllegalStateException {
        if (servletName == null || servletName.equals("")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.invalidServletName", servletName));
        }
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.addServlet.ise", this.getContextPath()));
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(servletName);
        if (wrapper == null) {
            wrapper = this.context.createWrapper();
            wrapper.setName(servletName);
            this.context.addChild(wrapper);
        } else if (wrapper.getName() != null && wrapper.getServletClass() != null) {
            if (wrapper.isOverridable()) {
                wrapper.setOverridable(false);
            } else {
                return null;
            }
        }
        ServletSecurity annotation = null;
        if (servlet == null) {
            wrapper.setServletClass(servletClass);
            Class<?> clazz = Introspection.loadClass(this.context, servletClass);
            if (clazz != null) {
                annotation = clazz.getAnnotation(ServletSecurity.class);
            }
        } else {
            wrapper.setServletClass(servlet.getClass().getName());
            wrapper.setServlet(servlet);
            if (this.context.wasCreatedDynamicServlet(servlet)) {
                annotation = servlet.getClass().getAnnotation(ServletSecurity.class);
            }
        }
        if (initParams != null) {
            for (Map.Entry entry : initParams.entrySet()) {
                wrapper.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        ApplicationServletRegistration registration = new ApplicationServletRegistration(wrapper, this.context);
        if (annotation != null) {
            registration.setServletSecurity(new ServletSecurityElement(annotation));
        }
        return registration;
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> c2) throws ServletException {
        try {
            Servlet servlet = (Servlet)this.context.getInstanceManager().newInstance(c2.getName());
            this.context.dynamicServletCreated(servlet);
            return (T)servlet;
        }
        catch (InvocationTargetException e2) {
            ExceptionUtils.handleThrowable(e2.getCause());
            throw new ServletException(e2);
        }
        catch (ReflectiveOperationException | NamingException e3) {
            throw new ServletException(e3);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        Wrapper wrapper = (Wrapper)this.context.findChild(servletName);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationServletRegistration(wrapper, this.context);
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.defaultSessionTrackingModes;
    }

    private void populateSessionTrackingModes() {
        Connector[] connectors;
        this.defaultSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL);
        this.supportedSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL);
        if (this.context.getCookies()) {
            this.defaultSessionTrackingModes.add(SessionTrackingMode.COOKIE);
            this.supportedSessionTrackingModes.add(SessionTrackingMode.COOKIE);
        }
        Service s2 = ((Engine)this.context.getParent().getParent()).getService();
        for (Connector connector : connectors = s2.findConnectors()) {
            if (!Boolean.TRUE.equals(connector.getAttribute("SSLEnabled"))) continue;
            this.supportedSessionTrackingModes.add(SessionTrackingMode.SSL);
            if (!Globals.STRICT_SERVLET_COMPLIANCE) break;
            this.defaultSessionTrackingModes.add(SessionTrackingMode.SSL);
            break;
        }
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.sessionTrackingModes != null) {
            return this.sessionTrackingModes;
        }
        return this.defaultSessionTrackingModes;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.setSessionTracking.ise", this.getContextPath()));
        }
        for (SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            if (this.supportedSessionTrackingModes.contains((Object)sessionTrackingMode)) continue;
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae.invalid", sessionTrackingMode.toString(), this.getContextPath()));
        }
        if (sessionTrackingModes.contains((Object)SessionTrackingMode.SSL) && sessionTrackingModes.size() > 1) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae.ssl", this.getContextPath()));
        }
        this.sessionTrackingModes = sessionTrackingModes;
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.setInitParam.ise", this.getContextPath()));
        }
        return this.parameters.putIfAbsent(name, value) == null;
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        EventListener listener;
        try {
            listener = this.createListener(listenerClass);
        }
        catch (ServletException e2) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.init", listenerClass.getName()), e2);
        }
        this.addListener(listener);
    }

    @Override
    public void addListener(String className) {
        try {
            if (this.context.getInstanceManager() != null) {
                Object obj = this.context.getInstanceManager().newInstance(className);
                if (!(obj instanceof EventListener)) {
                    throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", className));
                }
                EventListener listener = (EventListener)obj;
                this.addListener(listener);
            }
        }
        catch (InvocationTargetException e2) {
            ExceptionUtils.handleThrowable(e2.getCause());
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.cnfe", className), e2);
        }
        catch (ReflectiveOperationException | NamingException e3) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.cnfe", className), e3);
        }
    }

    @Override
    public <T extends EventListener> void addListener(T t2) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.addListener.ise", this.getContextPath()));
        }
        boolean match = false;
        if (t2 instanceof ServletContextAttributeListener || t2 instanceof ServletRequestListener || t2 instanceof ServletRequestAttributeListener || t2 instanceof HttpSessionIdListener || t2 instanceof HttpSessionAttributeListener) {
            this.context.addApplicationEventListener(t2);
            match = true;
        }
        if (t2 instanceof HttpSessionListener || t2 instanceof ServletContextListener && this.newServletContextListenerAllowed) {
            this.context.addApplicationLifecycleListener(t2);
            match = true;
        }
        if (match) {
            return;
        }
        if (t2 instanceof ServletContextListener) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.sclNotAllowed", t2.getClass().getName()));
        }
        throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", t2.getClass().getName()));
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> c2) throws ServletException {
        try {
            EventListener listener = (EventListener)this.context.getInstanceManager().newInstance(c2);
            if (listener instanceof ServletContextListener || listener instanceof ServletContextAttributeListener || listener instanceof ServletRequestListener || listener instanceof ServletRequestAttributeListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener || listener instanceof HttpSessionAttributeListener) {
                return (T)listener;
            }
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", listener.getClass().getName()));
        }
        catch (InvocationTargetException e2) {
            ExceptionUtils.handleThrowable(e2.getCause());
            throw new ServletException(e2);
        }
        catch (ReflectiveOperationException | NamingException e3) {
            throw new ServletException(e3);
        }
    }

    @Override
    public void declareRoles(String ... roleNames) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.addRole.ise", this.getContextPath()));
        }
        if (roleNames == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.roles.iae", this.getContextPath()));
        }
        for (String role : roleNames) {
            if (role == null || "".equals(role)) {
                throw new IllegalArgumentException(sm.getString("applicationContext.role.iae", this.getContextPath()));
            }
            this.context.addSecurityRole(role);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader result = this.context.getLoader().getClassLoader();
        if (Globals.IS_SECURITY_ENABLED) {
            ClassLoader parent;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            for (parent = result; parent != null && parent != tccl; parent = parent.getParent()) {
            }
            if (parent == null) {
                System.getSecurityManager().checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        return result;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        FilterDef[] filterDefs;
        HashMap<String, ApplicationFilterRegistration> result = new HashMap<String, ApplicationFilterRegistration>();
        for (FilterDef filterDef : filterDefs = this.context.findFilterDefs()) {
            result.put(filterDef.getFilterName(), new ApplicationFilterRegistration(filterDef, this.context));
        }
        return result;
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        Container[] wrappers;
        HashMap<String, ApplicationServletRegistration> result = new HashMap<String, ApplicationServletRegistration>();
        for (Container wrapper : wrappers = this.context.findChildren()) {
            result.put(((Wrapper)wrapper).getName(), new ApplicationServletRegistration((Wrapper)wrapper, this.context));
        }
        return result;
    }

    @Override
    public String getVirtualServerName() {
        Container host = this.context.getParent();
        Container engine = host.getParent();
        return engine.getName() + "/" + host.getName();
    }

    @Override
    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.setSessionTimeout.ise", this.getContextPath()));
        }
        this.context.setSessionTimeout(sessionTimeout);
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.setRequestEncoding.ise", this.getContextPath()));
        }
        this.context.setRequestCharacterEncoding(encoding);
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationContext.setResponseEncoding.ise", this.getContextPath()));
        }
        this.context.setResponseCharacterEncoding(encoding);
    }

    protected DefaultContext getContext() {
        return this.context;
    }

    protected void clearAttributes() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s2 : this.attributes.keySet()) {
            list.add(s2);
        }
        for (String key : list) {
            this.removeAttribute(key);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    void setAttributeReadOnly(String name) {
        if (this.attributes.containsKey(name)) {
            this.readOnlyAttributes.put(name, name);
        }
    }

    protected void setNewServletContextListenerAllowed(boolean allowed) {
        this.newServletContextListenerAllowed = allowed;
    }

    private boolean match(Connector connector, DefaultHost host) {
        if (Arrays.asList(host.getHttpListeners()).contains(connector.getName())) {
            return true;
        }
        String defaultHost = connector.getDefaultVirtualServer();
        if (defaultHost == null || defaultHost.isEmpty()) {
            return false;
        }
        if (defaultHost.equalsIgnoreCase(host.getName())) {
            return true;
        }
        for (String alias : host.findAliases()) {
            if (!defaultHost.equalsIgnoreCase(alias)) continue;
            return true;
        }
        return false;
    }

    static {
        String requireSlash = System.getProperty("com.bes.enterprise.webtier.core.ApplicationContext.GET_RESOURCE_REQUIRE_SLASH");
        GET_RESOURCE_REQUIRE_SLASH = requireSlash == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(requireSlash);
        emptyString = Collections.emptyList();
        emptyServlet = Collections.emptyList();
        sm = StringManager.getManager("com.bes.enterprise.webtier.core");
    }

    private static final class DispatchData {
        public MessageBytes uriMB = MessageBytes.newInstance();
        public MappingData mappingData;

        public DispatchData() {
            CharChunk uriCC = this.uriMB.getCharChunk();
            uriCC.setLimit(-1);
            this.mappingData = new MappingData();
        }
    }
}

