/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.descriptor.web.ErrorPage;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.connector.ClientAbortException;
import com.bes.enterprise.webtier.connector.Request;
import com.bes.enterprise.webtier.connector.Response;
import com.bes.enterprise.webtier.valves.ValveBase;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

final class DefaultHostValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(DefaultHostValve.class);
    private static final ClassLoader MY_CLASSLOADER = DefaultHostValve.class.getClassLoader();
    static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    static final boolean ACCESS_SESSION;
    private static boolean closeConnectionWhenException;
    private static final StringManager sm;

    public DefaultHostValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(context.getPipeline().isAsyncSupported());
        }
        boolean asyncAtStart = request.isAsync();
        try {
            block18: {
                context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
                if (!asyncAtStart && !context.fireRequestInitEvent(request.getRequest())) {
                    return;
                }
                try {
                    if (!response.isErrorReportRequired()) {
                        context.getPipeline().getFirst().invoke(request, response);
                    }
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                    this.container.getLogger().error("Exception Processing " + request.getRequestURI(), t2);
                    if (response.isErrorReportRequired()) break block18;
                    request.setAttribute("javax.servlet.error.exception", t2);
                    this.throwable(request, response, t2);
                }
            }
            response.setSuspended(false);
            Throwable t3 = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (!context.getState().isAvailable()) {
                return;
            }
            if (response.isErrorReportRequired()) {
                AtomicBoolean result = new AtomicBoolean(false);
                response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, result);
                if (result.get()) {
                    if (t3 != null) {
                        this.throwable(request, response, t3);
                    } else {
                        this.status(request, response);
                    }
                }
            }
            if (!request.isAsync() && !asyncAtStart) {
                context.fireRequestDestroyEvent(request.getRequest());
            }
        }
        finally {
            if (ACCESS_SESSION) {
                request.getSession(false);
            }
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void status(Request request, Response response) {
        int statusCode = response.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage == null) {
            errorPage = context.findErrorPage(0);
        }
        if (errorPage != null && response.isErrorReportRequired()) {
            response.setAppCommitted(false);
            request.setAttribute("javax.servlet.error.status_code", statusCode);
            String message = response.getMessage();
            if (message == null) {
                message = "";
            }
            request.setAttribute("javax.servlet.error.message", message);
            request.setAttribute("com.bes.enterprise.webtier.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("com.bes.enterprise.webtier.core.DISPATCHER_TYPE", (Object)DispatcherType.ERROR);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            if (this.custom(request, response, errorPage)) {
                response.setErrorReported();
                try {
                    response.finishResponse();
                }
                catch (ClientAbortException clientAbortException) {
                }
                catch (IOException e2) {
                    this.container.getLogger().warn("Exception Processing " + errorPage, e2);
                }
            }
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("standardHost.clientAbort", realError.getCause().getMessage()));
            }
            return;
        }
        ErrorPage errorPage = context.findErrorPage(throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = context.findErrorPage(realError);
        }
        if (errorPage != null) {
            if (response.setErrorReported()) {
                response.setAppCommitted(false);
                request.setAttribute("com.bes.enterprise.webtier.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
                request.setAttribute("com.bes.enterprise.webtier.core.DISPATCHER_TYPE", (Object)DispatcherType.ERROR);
                request.setAttribute("javax.servlet.error.status_code", 500);
                request.setAttribute("javax.servlet.error.message", throwable.getMessage());
                request.setAttribute("javax.servlet.error.exception", realError);
                Wrapper wrapper = request.getWrapper();
                if (wrapper != null) {
                    request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
                }
                request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.error.exception_type", realError.getClass());
                if (this.custom(request, response, errorPage)) {
                    try {
                        response.finishResponse();
                    }
                    catch (IOException e2) {
                        this.container.getLogger().warn("Exception Processing " + errorPage, e2);
                    }
                }
            }
            if (closeConnectionWhenException) {
                response.getCoyoteResponse().action(ActionCode.CLOSE_NOW, null);
            }
        } else {
            if (response.getStatus() < 400) {
                response.setStatus(500);
            }
            response.setError();
            this.status(request, response);
        }
    }

    private boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug("Processing " + errorPage);
        }
        try {
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            if (rd == null) {
                this.container.getLogger().error(sm.getString("standardHostValue.customStatusFailed", errorPage.getLocation()));
                return false;
            }
            if (response.isCommitted()) {
                rd.include(request.getRequest(), response.getResponse());
            } else {
                response.resetBuffer(true);
                response.setContentLength(-1);
                rd.forward(request.getRequest(), response.getResponse());
                response.setSuspended(false);
            }
            return true;
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            this.container.getLogger().error("Exception Processing " + errorPage, t2);
            return false;
        }
    }

    static {
        String accessSession = System.getProperty("com.bes.enterprise.webtier.core.DefaultHostValve.ACCESS_SESSION");
        ACCESS_SESSION = accessSession == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(accessSession);
        closeConnectionWhenException = Boolean.getBoolean("com.bes.enterprise.web.closeConnectionWhenException");
        sm = StringManager.getManager("com.bes.enterprise.webtier.core");
    }
}

