/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.ContainerEvent;
import com.bes.enterprise.webtier.ContainerListener;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.WorkThreadExecutor;
import java.util.concurrent.Executor;

public class ThreadLocalLeakPreventionListener
implements LifecycleListener,
ContainerListener {
    private static final Log log = LogFactory.getLog(ThreadLocalLeakPreventionListener.class);
    private volatile boolean serverStopping = false;
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.core");

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            Lifecycle lifecycle = event.getLifecycle();
            if ("after_start".equals(event.getType()) && lifecycle instanceof Server) {
                Server server = (Server)lifecycle;
                this.registerListenersForServer(server);
            }
            if ("before_stop".equals(event.getType()) && lifecycle instanceof Server) {
                this.serverStopping = true;
            }
            if ("after_stop".equals(event.getType()) && lifecycle instanceof Context) {
                this.stopIdleThreads((Context)lifecycle);
            }
        }
        catch (Exception e2) {
            String msg = sm.getString("threadLocalLeakPreventionListener.lifecycleEvent.error", event);
            log.error(msg, e2);
        }
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        try {
            String type = event.getType();
            if ("addChild".equals(type)) {
                this.processContainerAddChild(event.getContainer(), (Container)event.getData());
            } else if ("removeChild".equals(type)) {
                this.processContainerRemoveChild(event.getContainer(), (Container)event.getData());
            }
        }
        catch (Exception e2) {
            String msg = sm.getString("threadLocalLeakPreventionListener.containerEvent.error", event);
            log.error(msg, e2);
        }
    }

    private void registerListenersForServer(Server server) {
        for (Service service : server.findServices()) {
            Engine engine = service.getContainer();
            if (engine == null) continue;
            engine.addContainerListener(this);
            this.registerListenersForEngine(engine);
        }
    }

    private void registerListenersForEngine(Engine engine) {
        for (Container hostContainer : engine.findChildren()) {
            Host host = (Host)hostContainer;
            host.addContainerListener(this);
            this.registerListenersForHost(host);
        }
    }

    private void registerListenersForHost(Host host) {
        for (Container contextContainer : host.findChildren()) {
            Context context = (Context)contextContainer;
            this.registerContextListener(context);
        }
    }

    private void registerContextListener(Context context) {
        context.addLifecycleListener(this);
    }

    protected void processContainerAddChild(Container parent, Container child) {
        if (log.isDebugEnabled()) {
            log.debug("Process addChild[parent=" + parent + ",child=" + child + "]");
        }
        if (child instanceof Context) {
            this.registerContextListener((Context)child);
        } else if (child instanceof Engine) {
            this.registerListenersForEngine((Engine)child);
        } else if (child instanceof Host) {
            this.registerListenersForHost((Host)child);
        }
    }

    protected void processContainerRemoveChild(Container parent, Container child) {
        if (log.isDebugEnabled()) {
            log.debug("Process removeChild[parent=" + parent + ",child=" + child + "]");
        }
        if (child instanceof Context) {
            Context context = (Context)child;
            context.removeLifecycleListener(this);
        } else if (child instanceof Host || child instanceof Engine) {
            child.removeContainerListener(this);
        }
    }

    private void stopIdleThreads(Context context) {
        if (this.serverStopping) {
            return;
        }
        if (!(context instanceof DefaultContext) || !((DefaultContext)context).getRenewThreadsWhenStoppingContext()) {
            log.debug("Not renewing threads when the context is stopping. It is not configured to do it.");
            return;
        }
        Engine engine = (Engine)context.getParent().getParent();
        Service service = engine.getService();
        Connector[] connectors = service.findConnectors();
        if (connectors != null) {
            for (Connector connector : connectors) {
                ProtocolHandler handler = connector.getProtocolHandler();
                Executor executor = null;
                if (handler != null) {
                    executor = handler.getExecutor();
                }
                if (executor instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                    threadPoolExecutor.contextStopping();
                    continue;
                }
                if (!(executor instanceof WorkThreadExecutor)) continue;
                WorkThreadExecutor stdThreadExecutor = (WorkThreadExecutor)executor;
                stdThreadExecutor.contextStopping();
            }
        }
    }
}

