/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.filters;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.http.Parameters;
import com.bes.enterprise.webtier.filters.FilterBase;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FailedRequestFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(FailedRequestFilter.class);

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isGoodRequest(request)) {
            int status;
            Parameters.FailReason reason = (Parameters.FailReason)((Object)request.getAttribute("com.bes.enterprise.webtier.parameter_parse_failed_reason"));
            switch (reason) {
                case IO_ERROR: {
                    status = 500;
                    break;
                }
                case POST_TOO_LARGE: {
                    status = 413;
                    break;
                }
                default: {
                    status = 400;
                }
            }
            ((HttpServletResponse)response).sendError(status);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isGoodRequest(ServletRequest request) {
        request.getParameter("none");
        return request.getAttribute("com.bes.enterprise.webtier.parameter_parse_failed") == null;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }
}

