/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.ContainerListener;
import com.bes.enterprise.webtier.JmxEnabled;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.core.ContainerBase;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.mbeans.BaseHeavenMBean;
import com.bes.enterprise.webtier.startup.BESContextConfig;
import com.bes.enterprise.webtier.startup.HostConfig;
import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ContainerMBean
extends BaseHeavenMBean<ContainerBase> {
    public void addChild(String type, String name) throws MBeanException {
        LifecycleListener config;
        Container contained = (Container)ContainerMBean.newInstance(type);
        contained.setName(name);
        if (contained instanceof DefaultHost) {
            config = new HostConfig();
            contained.addLifecycleListener(config);
        } else if (contained instanceof DefaultContext) {
            config = new BESContextConfig();
            contained.addLifecycleListener(config);
        }
        boolean oldValue = true;
        ContainerBase container = (ContainerBase)this.doGetManagedResource();
        try {
            oldValue = container.getStartChildren();
            container.setStartChildren(false);
            container.addChild(contained);
            contained.init();
        }
        catch (LifecycleException e2) {
            throw new MBeanException(e2);
        }
        finally {
            if (container != null) {
                container.setStartChildren(oldValue);
            }
        }
    }

    public void removeChild(String name) throws MBeanException {
        if (name != null) {
            Container container = (Container)this.doGetManagedResource();
            Container contained = container.findChild(name);
            container.removeChild(contained);
        }
    }

    public String addValve(String valveType) throws MBeanException {
        Valve valve = (Valve)ContainerMBean.newInstance(valveType);
        Container container = (Container)this.doGetManagedResource();
        container.getPipeline().addValve(valve);
        if (valve instanceof JmxEnabled) {
            return ((JmxEnabled)((Object)valve)).getObjectName().toString();
        }
        return null;
    }

    public void removeValve(String valveName) throws MBeanException {
        ObjectName oname;
        Container container = (Container)this.doGetManagedResource();
        try {
            oname = new ObjectName(valveName);
        }
        catch (MalformedObjectNameException e2) {
            throw new MBeanException(e2);
        }
        catch (NullPointerException e3) {
            throw new MBeanException(e3);
        }
        if (container != null) {
            Valve[] valves = container.getPipeline().getValves();
            for (int i2 = 0; i2 < valves.length; ++i2) {
                ObjectName voname;
                if (!(valves[i2] instanceof JmxEnabled) || !(voname = ((JmxEnabled)((Object)valves[i2])).getObjectName()).equals(oname)) continue;
                container.getPipeline().removeValve(valves[i2]);
            }
        }
    }

    public void addLifecycleListener(String type) throws MBeanException {
        LifecycleListener listener = (LifecycleListener)ContainerMBean.newInstance(type);
        Container container = (Container)this.doGetManagedResource();
        container.addLifecycleListener(listener);
    }

    public void removeLifecycleListeners(String type) throws MBeanException {
        LifecycleListener[] listeners;
        Container container = (Container)this.doGetManagedResource();
        for (LifecycleListener listener : listeners = container.findLifecycleListeners()) {
            if (!listener.getClass().getName().equals(type)) continue;
            container.removeLifecycleListener(listener);
        }
    }

    public String[] findLifecycleListenerNames() throws MBeanException {
        LifecycleListener[] listeners;
        Container container = (Container)this.doGetManagedResource();
        ArrayList<String> result = new ArrayList<String>();
        for (LifecycleListener listener : listeners = container.findLifecycleListeners()) {
            result.add(listener.getClass().getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] findContainerListenerNames() throws MBeanException {
        ContainerListener[] listeners;
        Container container = (Container)this.doGetManagedResource();
        ArrayList<String> result = new ArrayList<String>();
        for (ContainerListener listener : listeners = container.findContainerListeners()) {
            result.add(listener.getClass().getName());
        }
        return result.toArray(new String[result.size()]);
    }
}

