/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.JmxEnabled;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultEngine;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.core.DefaultService;
import com.bes.enterprise.webtier.loader.WebappLoader;
import com.bes.enterprise.webtier.mbeans.MBeanUtils;
import com.bes.enterprise.webtier.realm.DataSourceRealm;
import com.bes.enterprise.webtier.realm.JDBCRealm;
import com.bes.enterprise.webtier.realm.JNDIRealm;
import com.bes.enterprise.webtier.realm.MemoryRealm;
import com.bes.enterprise.webtier.realm.UserDatabaseRealm;
import com.bes.enterprise.webtier.session.DefaultManager;
import com.bes.enterprise.webtier.startup.BESContextConfig;
import com.bes.enterprise.webtier.startup.HostConfig;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import java.io.File;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanFactory {
    private static final Log log = LogFactory.getLog(MBeanFactory.class);
    protected static final StringManager sm = StringManager.getManager(MBeanFactory.class);
    private static final MBeanServer mserver = MBeanUtils.createServer();
    private Object container;

    public void setContainer(Object container) {
        this.container = container;
    }

    private final String getPathStr(String t2) {
        if (t2 == null || t2.equals("/")) {
            return "";
        }
        return t2;
    }

    private Container getParentContainerFromParent(ObjectName pname) throws Exception {
        String type = pname.getKeyProperty("type");
        String j2eeType = pname.getKeyProperty("j2eeType");
        Service service = this.getService(pname);
        DefaultEngine engine = (DefaultEngine)service.getContainer();
        if (j2eeType != null && j2eeType.equals("WebModule")) {
            String name = pname.getKeyProperty("name");
            name = name.substring(2);
            int i2 = name.indexOf(47);
            String hostName = name.substring(0, i2);
            String path = name.substring(i2);
            Container host = engine.findChild(hostName);
            String pathStr = this.getPathStr(path);
            Container context = host.findChild(pathStr);
            return context;
        }
        if (type != null) {
            if (type.equals("Engine")) {
                return engine;
            }
            if (type.equals("Host")) {
                String hostName = pname.getKeyProperty("host");
                Container host = engine.findChild(hostName);
                return host;
            }
        }
        return null;
    }

    private Container getParentContainerFromChild(ObjectName oname) throws Exception {
        String hostName = oname.getKeyProperty("host");
        String path = oname.getKeyProperty("path");
        Service service = this.getService(oname);
        Engine engine = service.getContainer();
        if (hostName == null) {
            return engine;
        }
        if (path == null) {
            Container host = engine.findChild(hostName);
            return host;
        }
        Container host = engine.findChild(hostName);
        path = this.getPathStr(path);
        Container context = host.findChild(path);
        return context;
    }

    private Service getService(ObjectName oname) throws Exception {
        if (this.container instanceof Service) {
            return (Service)this.container;
        }
        LifecycleMBeanBase service = null;
        String domain = oname.getDomain();
        if (this.container instanceof Server) {
            Service[] services = ((Server)this.container).findServices();
            for (int i2 = 0; i2 < services.length && !domain.equals((service = (DefaultService)services[i2]).getObjectName().getDomain()); ++i2) {
            }
        }
        if (service == null || !service.getObjectName().getDomain().equals(domain)) {
            throw new Exception("Service with the domain is not found");
        }
        return service;
    }

    public String createAjpConnector(String parent, String address, int port) throws Exception {
        return this.createConnector(parent, address, port, true, false);
    }

    public String createDataSourceRealm(String parent, String dataSourceName, String roleNameCol, String userCredCol, String userNameCol, String userRoleTable, String userTable) throws Exception {
        DataSourceRealm realm = new DataSourceRealm();
        realm.setDataSourceName(dataSourceName);
        realm.setRoleNameCol(roleNameCol);
        realm.setUserCredCol(userCredCol);
        realm.setUserNameCol(userNameCol);
        realm.setUserRoleTable(userRoleTable);
        realm.setUserTable(userTable);
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        container.setRealm(realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createHttpConnector(String parent, String address, int port) throws Exception {
        return this.createConnector(parent, address, port, false, false);
    }

    private String createConnector(String parent, String address, int port, boolean isAjp, boolean isSSL) throws Exception {
        String protocol = isAjp ? "AJP/1.3" : "HTTP/1.1";
        Connector retobj = new Connector(protocol);
        if (address != null && address.length() > 0) {
            retobj.setProperty("address", address);
        }
        retobj.setPort(port);
        retobj.setSecure(isSSL);
        retobj.setScheme(isSSL ? "https" : "http");
        ObjectName pname = new ObjectName(parent);
        Service service = this.getService(pname);
        service.addConnector(retobj);
        ObjectName coname = retobj.getObjectName();
        return coname.toString();
    }

    public String createHttpsConnector(String parent, String address, int port) throws Exception {
        return this.createConnector(parent, address, port, false, true);
    }

    public String createJDBCRealm(String parent, String driverName, String connectionName, String connectionPassword, String connectionURL) throws Exception {
        JDBCRealm realm = new JDBCRealm();
        realm.setDriverName(driverName);
        realm.setConnectionName(connectionName);
        realm.setConnectionPassword(connectionPassword);
        realm.setConnectionURL(connectionURL);
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        container.setRealm(realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createJNDIRealm(String parent) throws Exception {
        JNDIRealm realm = new JNDIRealm();
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        container.setRealm(realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createMemoryRealm(String parent) throws Exception {
        MemoryRealm realm = new MemoryRealm();
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        container.setRealm(realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createDefaultContext(String parent, String path, String docBase) throws Exception {
        return this.createDefaultContext(parent, path, docBase, false, false);
    }

    public String createDefaultContext(String parent, String path, String docBase, boolean xmlValidation, boolean xmlNamespaceAware) throws Exception {
        DefaultContext context = new DefaultContext();
        path = this.getPathStr(path);
        context.setPath(path);
        context.setDocBase(docBase);
        context.setXmlValidation(xmlValidation);
        context.setXmlNamespaceAware(xmlNamespaceAware);
        BESContextConfig contextConfig = new BESContextConfig();
        context.addLifecycleListener(contextConfig);
        ObjectName pname = new ObjectName(parent);
        ObjectName deployer = new ObjectName(pname.getDomain() + ":type=Deployer,host=" + pname.getKeyProperty("host"));
        if (mserver.isRegistered(deployer)) {
            String contextName = context.getName();
            mserver.invoke(deployer, "addServiced", new Object[]{contextName}, new String[]{"java.lang.String"});
            String configPath = (String)mserver.getAttribute(deployer, "configBaseName");
            String baseName = context.getBaseName();
            File configFile = new File(new File(configPath), baseName + ".xml");
            if (configFile.isFile()) {
                context.setConfigFile(configFile.toURI().toURL());
            }
            mserver.invoke(deployer, "manageApp", new Object[]{context}, new String[]{"com.bes.enterprise.webtier.Context"});
            mserver.invoke(deployer, "removeServiced", new Object[]{contextName}, new String[]{"java.lang.String"});
        } else {
            log.warn("Deployer not found for " + pname.getKeyProperty("host"));
            Service service = this.getService(pname);
            Engine engine = service.getContainer();
            Host host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.addChild(context);
        }
        return context.getObjectName().toString();
    }

    public String createDefaultHost(String parent, String name, String appBase, boolean autoDeploy, boolean deployOnStartup, boolean deployXML, boolean unpackWARs) throws Exception {
        DefaultHost host = new DefaultHost();
        host.setName(name);
        host.setAppBase(appBase);
        host.setAutoDeploy(autoDeploy);
        host.setDeployOnStartup(deployOnStartup);
        host.setDeployXML(deployXML);
        host.setUnpackWARs(unpackWARs);
        HostConfig hostConfig = new HostConfig();
        host.addLifecycleListener(hostConfig);
        ObjectName pname = new ObjectName(parent);
        Service service = this.getService(pname);
        Engine engine = service.getContainer();
        engine.addChild(host);
        return host.getObjectName().toString();
    }

    public String createDefaultServiceEngine(String domain, String defaultHost, String baseDir) throws Exception {
        if (!(this.container instanceof Server)) {
            throw new Exception("Container not Server");
        }
        DefaultEngine engine = new DefaultEngine();
        engine.setDomain(domain);
        engine.setName(domain);
        engine.setDefaultHost(defaultHost);
        DefaultService service = new DefaultService();
        service.setContainer(engine);
        service.setName(domain);
        ((Server)this.container).addService(service);
        return engine.getObjectName().toString();
    }

    public String createDefaultManager(String parent) throws Exception {
        DefaultManager manager = new DefaultManager();
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        if (!(container instanceof Context)) {
            throw new Exception(sm.getString("mBeanFactory.managerContext"));
        }
        ((Context)container).setManager(manager);
        ObjectName oname = manager.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createUserDatabaseRealm(String parent, String resourceName) throws Exception {
        UserDatabaseRealm realm = new UserDatabaseRealm();
        realm.setResourceName(resourceName);
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        container.setRealm(realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createValve(String className, String parent) throws Exception {
        ObjectName parentName = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(parentName);
        if (container == null) {
            throw new IllegalArgumentException();
        }
        Valve valve = (Valve)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        container.getPipeline().addValve(valve);
        if (valve instanceof JmxEnabled) {
            return ((JmxEnabled)((Object)valve)).getObjectName().toString();
        }
        return null;
    }

    public String createWebappLoader(String parent) throws Exception {
        WebappLoader loader = new WebappLoader();
        ObjectName pname = new ObjectName(parent);
        Container container = this.getParentContainerFromParent(pname);
        if (container instanceof Context) {
            ((Context)container).setLoader(loader);
        }
        ObjectName oname = MBeanUtils.createObjectName(pname.getDomain(), loader);
        return oname.toString();
    }

    public void removeConnector(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Service service = this.getService(oname);
        String port = oname.getKeyProperty("port");
        String address = oname.getKeyProperty("address");
        if (address != null) {
            address = ObjectName.unquote(address);
        }
        Connector[] conns = service.findConnectors();
        for (int i2 = 0; i2 < conns.length; ++i2) {
            String connAddress = null;
            Object objConnAddress = conns[i2].getProperty("address");
            if (objConnAddress != null) {
                connAddress = ((InetAddress)objConnAddress).getHostAddress();
            }
            String connPort = "" + conns[i2].getPort();
            if (address == null) {
                if (connAddress != null || !port.equals(connPort)) continue;
                service.removeConnector(conns[i2]);
                conns[i2].destroy();
                break;
            }
            if (!address.equals(connAddress) || !port.equals(connPort)) continue;
            service.removeConnector(conns[i2]);
            conns[i2].destroy();
            break;
        }
    }

    public void removeContext(String contextName) throws Exception {
        ObjectName oname = new ObjectName(contextName);
        String domain = oname.getDomain();
        DefaultService service = (DefaultService)this.getService(oname);
        Engine engine = service.getContainer();
        String name = oname.getKeyProperty("name");
        name = name.substring(2);
        int i2 = name.indexOf(47);
        String hostName = name.substring(0, i2);
        String path = name.substring(i2);
        ObjectName deployer = new ObjectName(domain + ":type=Deployer,host=" + hostName);
        String pathStr = this.getPathStr(path);
        if (mserver.isRegistered(deployer)) {
            mserver.invoke(deployer, "addServiced", new Object[]{pathStr}, new String[]{"java.lang.String"});
            mserver.invoke(deployer, "unmanageApp", new Object[]{pathStr}, new String[]{"java.lang.String"});
            mserver.invoke(deployer, "removeServiced", new Object[]{pathStr}, new String[]{"java.lang.String"});
        } else {
            log.warn("Deployer not found for " + hostName);
            Host host = (Host)engine.findChild(hostName);
            Context context = (Context)host.findChild(pathStr);
            host.removeChild(context);
            if (context instanceof DefaultContext) {
                try {
                    ((DefaultContext)context).destroy();
                }
                catch (Exception e2) {
                    log.warn("Error during context [" + context.getName() + "] destroy ", e2);
                }
            }
        }
    }

    public void removeHost(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String hostName = oname.getKeyProperty("host");
        Service service = this.getService(oname);
        Engine engine = service.getContainer();
        Host host = (Host)engine.findChild(hostName);
        if (host != null) {
            engine.removeChild(host);
        }
    }

    public void removeLoader(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Container container = this.getParentContainerFromChild(oname);
        if (container instanceof Context) {
            ((Context)container).setLoader(null);
        }
    }

    public void removeManager(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Container container = this.getParentContainerFromChild(oname);
        if (container instanceof Context) {
            ((Context)container).setManager(null);
        }
    }

    public void removeRealm(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Container container = this.getParentContainerFromChild(oname);
        container.setRealm(null);
    }

    public void removeService(String name) throws Exception {
        if (!(this.container instanceof Server)) {
            throw new Exception();
        }
        ObjectName oname = new ObjectName(name);
        Service service = this.getService(oname);
        ((Server)this.container).removeService(service);
    }

    public void removeValve(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Container container = this.getParentContainerFromChild(oname);
        Valve[] valves = container.getPipeline().getValves();
        for (int i2 = 0; i2 < valves.length; ++i2) {
            ObjectName voname = ((JmxEnabled)((Object)valves[i2])).getObjectName();
            if (!voname.equals(oname)) continue;
            container.getPipeline().removeValve(valves[i2]);
        }
    }
}

