/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.web.util.descriptor.web.ContextEnvironment;
import com.bes.enterprise.web.util.descriptor.web.ContextResource;
import com.bes.enterprise.web.util.descriptor.web.ContextResourceLink;
import com.bes.enterprise.web.util.modeler.ManagedBean;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.Loader;
import com.bes.enterprise.webtier.Role;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.User;
import com.bes.enterprise.webtier.UserDatabase;
import com.bes.enterprise.webtier.util.ContextName;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanUtils {
    private static final String[][] exceptions = new String[][]{{"com.bes.enterprise.webtier.users.MemoryGroup", "Group"}, {"com.bes.enterprise.webtier.users.MemoryRole", "Role"}, {"com.bes.enterprise.webtier.users.MemoryUser", "User"}};
    private static Registry registry = MBeanUtils.createRegistry();
    private static MBeanServer mserver = MBeanUtils.createServer();

    static String createManagedName(Object component) {
        String className = component.getClass().getName();
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            if (!className.equals(exceptions[i2][0])) continue;
            return exceptions[i2][1];
        }
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className;
    }

    public static DynamicMBean createMBean(ContextEnvironment environment) throws Exception {
        String mname = MBeanUtils.createManagedName(environment);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(environment);
        ObjectName oname = MBeanUtils.createObjectName(domain, environment);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    public static DynamicMBean createMBean(ContextResource resource) throws Exception {
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(resource);
        ObjectName oname = MBeanUtils.createObjectName(domain, resource);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    public static DynamicMBean createMBean(ContextResourceLink resourceLink) throws Exception {
        String mname = MBeanUtils.createManagedName(resourceLink);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(resourceLink);
        ObjectName oname = MBeanUtils.createObjectName(domain, resourceLink);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static DynamicMBean createMBean(Group group) throws Exception {
        String mname = MBeanUtils.createManagedName(group);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(group);
        ObjectName oname = MBeanUtils.createObjectName(domain, group);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static DynamicMBean createMBean(Role role) throws Exception {
        String mname = MBeanUtils.createManagedName(role);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(role);
        ObjectName oname = MBeanUtils.createObjectName(domain, role);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static DynamicMBean createMBean(User user) throws Exception {
        String mname = MBeanUtils.createManagedName(user);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(user);
        ObjectName oname = MBeanUtils.createObjectName(domain, user);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static DynamicMBean createMBean(UserDatabase userDatabase) throws Exception {
        String mname = MBeanUtils.createManagedName(userDatabase);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e2 = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e2);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        DynamicMBean mbean = managed.createMBean(userDatabase);
        ObjectName oname = MBeanUtils.createObjectName(domain, userDatabase);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    public static ObjectName createObjectName(String domain, ContextEnvironment environment) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = environment.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Environment,resourcetype=Global,name=" + environment.getName());
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName cn = new ContextName(context.getName(), false);
            Container host = context.getParent();
            name = new ObjectName(domain + ":type=Environment,resourcetype=Context,host=" + host.getName() + ",context=" + cn.getDisplayName() + ",name=" + environment.getName());
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResource resource) throws MalformedObjectNameException {
        ObjectName name = null;
        String quotedResourceName = ObjectName.quote(resource.getName());
        Object container = resource.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Resource,resourcetype=Global,class=" + resource.getType() + ",name=" + quotedResourceName);
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName cn = new ContextName(context.getName(), false);
            Container host = context.getParent();
            name = new ObjectName(domain + ":type=Resource,resourcetype=Context,host=" + host.getName() + ",context=" + cn.getDisplayName() + ",class=" + resource.getType() + ",name=" + quotedResourceName);
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResourceLink resourceLink) throws MalformedObjectNameException {
        ObjectName name = null;
        String quotedResourceLinkName = ObjectName.quote(resourceLink.getName());
        Object container = resourceLink.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=ResourceLink,resourcetype=Global,name=" + quotedResourceLinkName);
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName cn = new ContextName(context.getName(), false);
            Container host = context.getParent();
            name = new ObjectName(domain + ":type=ResourceLink,resourcetype=Context,host=" + host.getName() + ",context=" + cn.getDisplayName() + ",name=" + quotedResourceLinkName);
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Group group) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Group,groupname=" + ObjectName.quote(group.getGroupname()) + ",database=" + group.getUserDatabase().getId());
        return name;
    }

    static ObjectName createObjectName(String domain, Loader loader) throws MalformedObjectNameException {
        ObjectName name = null;
        Context context = loader.getContext();
        ContextName cn = new ContextName(context.getName(), false);
        Container host = context.getParent();
        name = new ObjectName(domain + ":type=Loader,host=" + host.getName() + ",context=" + cn.getDisplayName());
        return name;
    }

    static ObjectName createObjectName(String domain, Role role) throws MalformedObjectNameException {
        ObjectName name = new ObjectName(domain + ":type=Role,rolename=" + ObjectName.quote(role.getRolename()) + ",database=" + role.getUserDatabase().getId());
        return name;
    }

    static ObjectName createObjectName(String domain, User user) throws MalformedObjectNameException {
        ObjectName name = new ObjectName(domain + ":type=User,username=" + ObjectName.quote(user.getUsername()) + ",database=" + user.getUserDatabase().getId());
        return name;
    }

    static ObjectName createObjectName(String domain, UserDatabase userDatabase) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=UserDatabase,database=" + userDatabase.getId());
        return name;
    }

    public static synchronized Registry createRegistry() {
        if (registry == null) {
            registry = Registry.getRegistry(null, null);
            ClassLoader cl = MBeanUtils.class.getClassLoader();
            registry.loadDescriptors("com.bes.enterprise.webtier.mbeans", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.authenticator", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.core", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.deploy", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.loader", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.realm", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.session", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.startup", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.users", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.ha", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.connector", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.valves", cl);
            registry.loadDescriptors("com.bes.enterprise.webtier.storeconfig", cl);
            registry.loadDescriptors("com.bes.enterprise.web.util.descriptor.web", cl);
        }
        return registry;
    }

    public static synchronized MBeanServer createServer() {
        if (mserver == null) {
            mserver = Registry.getRegistry(null, null).getMBeanServer();
        }
        return mserver;
    }

    public static void destroyMBean(ContextEnvironment environment) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(environment);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, environment))) {
            mserver.unregisterMBean(oname);
        }
    }

    public static void destroyMBean(ContextResource resource) throws Exception {
        ObjectName oname;
        String mname;
        ManagedBean managed;
        if ("com.bes.enterprise.webtier.UserDatabase".equals(resource.getType())) {
            MBeanUtils.destroyMBeanUserDatabase(resource.getName());
        }
        if ((managed = registry.findManagedBean(mname = MBeanUtils.createManagedName(resource))) == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resource))) {
            mserver.unregisterMBean(oname);
        }
    }

    public static void destroyMBean(ContextResourceLink resourceLink) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resourceLink);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resourceLink))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Group group) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(group);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, group))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Role role) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(role);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, role))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(User user) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(user);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, user))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBeanUserDatabase(String userDatabase) throws Exception {
        ObjectName query = null;
        Set<ObjectName> results = null;
        query = new ObjectName("Users:type=Group,database=" + userDatabase + ",*");
        results = mserver.queryNames(query, null);
        for (ObjectName result : results) {
            mserver.unregisterMBean(result);
        }
        query = new ObjectName("Users:type=Role,database=" + userDatabase + ",*");
        results = mserver.queryNames(query, null);
        for (ObjectName result : results) {
            mserver.unregisterMBean(result);
        }
        query = new ObjectName("Users:type=User,database=" + userDatabase + ",*");
        results = mserver.queryNames(query, null);
        for (ObjectName result : results) {
            mserver.unregisterMBean(result);
        }
        ObjectName db = new ObjectName("Users:type=UserDatabase,database=" + userDatabase);
        if (mserver.isRegistered(db)) {
            mserver.unregisterMBean(db);
        }
    }
}

