/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.web.util.descriptor.web.ContextEnvironment;
import com.bes.enterprise.web.util.descriptor.web.ContextResource;
import com.bes.enterprise.web.util.descriptor.web.ContextResourceLink;
import com.bes.enterprise.web.util.modeler.BaseModelMBean;
import com.bes.enterprise.web.util.modeler.ManagedBean;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.webtier.deploy.NamingResourcesImpl;
import com.bes.enterprise.webtier.mbeans.MBeanUtils;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class NamingResourcesMBean
extends BaseModelMBean {
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("NamingResources");

    public String[] getEnvironments() {
        ContextEnvironment[] envs = ((NamingResourcesImpl)this.resource).findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        for (int i2 = 0; i2 < envs.length; ++i2) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), envs[i2]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e2) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for environment " + envs[i2]);
                iae.initCause(e2);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResources() {
        ContextResource[] resources = ((NamingResourcesImpl)this.resource).findResources();
        ArrayList<String> results = new ArrayList<String>();
        for (int i2 = 0; i2 < resources.length; ++i2) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), resources[i2]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e2) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + resources[i2]);
                iae.initCause(e2);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] resourceLinks = ((NamingResourcesImpl)this.resource).findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        for (int i2 = 0; i2 < resourceLinks.length; ++i2) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), resourceLinks[i2]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e2) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + resourceLinks[i2]);
                iae.initCause(e2);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type, String value) throws MalformedObjectNameException {
        NamingResourcesImpl nresources = (NamingResourcesImpl)this.resource;
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type);
        env.setValue(value);
        nresources.addEnvironment(env);
        ManagedBean managed = this.registry.findManagedBean("ContextEnvironment");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), env);
        return oname.toString();
    }

    public String addResource(String resourceName, String type) throws MalformedObjectNameException {
        NamingResourcesImpl nresources = (NamingResourcesImpl)this.resource;
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type);
        nresources.addResource(resource);
        ManagedBean managed = this.registry.findManagedBean("ContextResource");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resource);
        return oname.toString();
    }

    public String addResourceLink(String resourceLinkName, String type) throws MalformedObjectNameException {
        NamingResourcesImpl nresources = (NamingResourcesImpl)this.resource;
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type);
        nresources.addResourceLink(resourceLink);
        ManagedBean managed = this.registry.findManagedBean("ContextResourceLink");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resourceLink);
        return oname.toString();
    }

    public void removeEnvironment(String envName) {
        NamingResourcesImpl nresources = (NamingResourcesImpl)this.resource;
        if (nresources == null) {
            return;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + envName + "'");
        }
        nresources.removeEnvironment(envName);
    }

    public void removeResource(String resourceName) {
        resourceName = ObjectName.unquote(resourceName);
        NamingResourcesImpl nresources = (NamingResourcesImpl)this.resource;
        if (nresources == null) {
            return;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + resourceName + "'");
        }
        nresources.removeResource(resourceName);
    }

    public void removeResourceLink(String resourceLinkName) {
        resourceLinkName = ObjectName.unquote(resourceLinkName);
        NamingResourcesImpl nresources = (NamingResourcesImpl)this.resource;
        if (nresources == null) {
            return;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink == null) {
            throw new IllegalArgumentException("Invalid resource Link name '" + resourceLinkName + "'");
        }
        nresources.removeResourceLink(resourceLinkName);
    }
}

