/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.realm;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.realm.JAASRealm;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class JAASCallbackHandler
implements CallbackHandler {
    protected static final StringManager sm = StringManager.getManager(JAASCallbackHandler.class);
    protected final String password;
    protected final JAASRealm realm;
    protected final String username;
    protected final String nonce;
    protected final String nc;
    protected final String cnonce;
    protected final String qop;
    protected final String realmName;
    protected final String md5a2;
    protected final String authMethod;

    public JAASCallbackHandler(JAASRealm realm, String username, String password) {
        this(realm, username, password, null, null, null, null, null, null, null);
    }

    public JAASCallbackHandler(JAASRealm realm, String username, String password, String nonce, String nc, String cnonce, String qop, String realmName, String md5a2, String authMethod) {
        this.realm = realm;
        this.username = username;
        this.password = realm.hasMessageDigest() ? realm.getCredentialHandler().mutate(password) : password;
        this.nonce = nonce;
        this.nc = nc;
        this.cnonce = cnonce;
        this.qop = qop;
        this.realmName = realmName;
        this.md5a2 = md5a2;
        this.authMethod = authMethod;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i2 = 0; i2 < callbacks.length; ++i2) {
            if (callbacks[i2] instanceof NameCallback) {
                if (this.realm.getContainer().getLogger().isTraceEnabled()) {
                    this.realm.getContainer().getLogger().trace(sm.getString("jaasCallback.username", this.username));
                }
                ((NameCallback)callbacks[i2]).setName(this.username);
                continue;
            }
            if (callbacks[i2] instanceof PasswordCallback) {
                char[] passwordcontents = this.password != null ? this.password.toCharArray() : new char[]{};
                ((PasswordCallback)callbacks[i2]).setPassword(passwordcontents);
                continue;
            }
            if (callbacks[i2] instanceof TextInputCallback) {
                TextInputCallback cb = (TextInputCallback)callbacks[i2];
                if (cb.getPrompt().equals("nonce")) {
                    cb.setText(this.nonce);
                    continue;
                }
                if (cb.getPrompt().equals("nc")) {
                    cb.setText(this.nc);
                    continue;
                }
                if (cb.getPrompt().equals("cnonce")) {
                    cb.setText(this.cnonce);
                    continue;
                }
                if (cb.getPrompt().equals("qop")) {
                    cb.setText(this.qop);
                    continue;
                }
                if (cb.getPrompt().equals("realmName")) {
                    cb.setText(this.realmName);
                    continue;
                }
                if (cb.getPrompt().equals("md5a2")) {
                    cb.setText(this.md5a2);
                    continue;
                }
                if (cb.getPrompt().equals("authMethod")) {
                    cb.setText(this.authMethod);
                    continue;
                }
                if (cb.getPrompt().equals("heavenBase")) {
                    cb.setText(this.realm.getContainer().getHeavenBase().getAbsolutePath());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i2]);
            }
            throw new UnsupportedCallbackException(callbacks[i2]);
        }
    }
}

