/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.realm;

import com.bes.enterprise.webtier.realm.GenericPrincipal;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class LdapPrincipal
extends GenericPrincipal {
    private static final long serialVersionUID = 1L;
    protected final String dn;

    public LdapPrincipal(String dn, String name, String password, List<String> roles) {
        this(dn, name, password, roles, null);
    }

    public LdapPrincipal(String dn, String name, String password, List<String> roles, Principal userPrincipal) {
        this(dn, name, password, roles, userPrincipal, null);
    }

    public LdapPrincipal(String dn, String name, String password, List<String> roles, Principal userPrincipal, LoginContext loginContext) {
        this(dn, name, password, roles, userPrincipal, loginContext, null);
    }

    public LdapPrincipal(String dn, String name, String password, List<String> roles, Principal userPrincipal, LoginContext loginContext, GSSCredential gssCredential) {
        super(name, password, roles, userPrincipal, loginContext, gssCredential);
        this.dn = dn;
    }

    public String getDn() {
        return this.dn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LdapPrincipal[");
        sb.append(this.dn);
        sb.append("],");
        sb.append(super.toString());
        return sb.toString();
    }

    private Object writeReplace() {
        return new SerializableLdapPrincipal(this.dn, this.name, this.password, this.roles, this.userPrincipal);
    }

    private static class SerializableLdapPrincipal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String dn;
        private final String name;
        private final String password;
        private final String[] roles;
        private final Principal principal;

        public SerializableLdapPrincipal(String dn, String name, String password, String[] roles, Principal principal) {
            this.dn = dn;
            this.name = name;
            this.password = password;
            this.roles = roles;
            this.principal = principal instanceof Serializable ? principal : null;
        }

        private Object readResolve() {
            return new LdapPrincipal(this.dn, this.name, this.password, Arrays.asList(this.roles), this.principal);
        }
    }
}

