/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.realm;

import com.bes.enterprise.appserver.common.security.RoleMapper;
import com.bes.enterprise.appserver.common.security.RoleMapperFactory;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.buf.B2CConverter;
import com.bes.enterprise.web.util.buf.HexUtils;
import com.bes.enterprise.web.util.descriptor.web.SecurityCollection;
import com.bes.enterprise.web.util.descriptor.web.SecurityConstraint;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.security.ConcurrentMessageDigest;
import com.bes.enterprise.web.util.security.MD5Encoder;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.CredentialHandler;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.GSSRealm;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.connector.Request;
import com.bes.enterprise.webtier.connector.Response;
import com.bes.enterprise.webtier.realm.DigestCredentialHandlerBase;
import com.bes.enterprise.webtier.realm.GenericPrincipal;
import com.bes.enterprise.webtier.realm.MessageDigestCredentialHandler;
import com.bes.enterprise.webtier.realm.SecretKeyCredentialHandler;
import com.bes.enterprise.webtier.realm.UserDatabaseRealm;
import com.bes.enterprise.webtier.realm.X509SubjectDnRetriever;
import com.bes.enterprise.webtier.realm.X509UsernameRetriever;
import com.bes.enterprise.webtier.users.MemoryUser;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import com.bes.enterprise.webtier.util.SessionConfig;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.annotation.ServletSecurity;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class RealmBase
extends LifecycleMBeanBase
implements GSSRealm {
    private static final Log log = LogFactory.getLog(RealmBase.class);
    private static final List<Class<? extends DigestCredentialHandlerBase>> credentialHandlerClasses = new ArrayList<Class<? extends DigestCredentialHandlerBase>>();
    private static List<String> whiteList = null;
    protected Container container = null;
    protected Log containerLog = null;
    private CredentialHandler credentialHandler;
    protected static final StringManager sm;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected String x509UsernameRetrieverClassName;
    protected X509UsernameRetriever x509UsernameRetriever;
    protected AllRolesMode allRolesMode = AllRolesMode.STRICT_MODE;
    protected boolean stripRealmForGss = true;
    private int transportGuaranteeRedirectStatus = 302;
    protected String realmPath = "/realm0";

    public int getTransportGuaranteeRedirectStatus() {
        return this.transportGuaranteeRedirectStatus;
    }

    public void setTransportGuaranteeRedirectStatus(int transportGuaranteeRedirectStatus) {
        this.transportGuaranteeRedirectStatus = transportGuaranteeRedirectStatus;
    }

    @Override
    public CredentialHandler getCredentialHandler() {
        return this.credentialHandler;
    }

    @Override
    public void setCredentialHandler(CredentialHandler credentialHandler) {
        this.credentialHandler = credentialHandler;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getAllRolesMode() {
        return this.allRolesMode.toString();
    }

    public void setAllRolesMode(String allRolesMode) {
        this.allRolesMode = AllRolesMode.toMode(allRolesMode);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getX509UsernameRetrieverClassName() {
        return this.x509UsernameRetrieverClassName;
    }

    public void setX509UsernameRetrieverClassName(String className) {
        this.x509UsernameRetrieverClassName = className;
    }

    public boolean isStripRealmForGss() {
        return this.stripRealmForGss;
    }

    public void setStripRealmForGss(boolean stripRealmForGss) {
        this.stripRealmForGss = stripRealmForGss;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Principal authenticate(String username) {
        if (username == null) {
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace(sm.getString("realmBase.authenticateSuccess", username));
        }
        return this.getPrincipal(username);
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        if (username == null || credentials == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("realmBase.authenticateFailure", username));
            }
            return null;
        }
        String serverCredentials = this.getPassword(username);
        if (this instanceof UserDatabaseRealm) {
            serverCredentials = ((UserDatabaseRealm)this).getPassword(username, credentials);
        }
        if (serverCredentials == null) {
            this.getCredentialHandler().mutate(credentials);
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("realmBase.authenticateFailure", username));
            }
            return null;
        }
        boolean validated = this.getCredentialHandler().matches(credentials, serverCredentials);
        if (validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("realmBase.authenticateSuccess", username));
            }
            return this.getPrincipal(username);
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace(sm.getString("realmBase.authenticateFailure", username));
        }
        return null;
    }

    @Override
    public Principal authenticate(String username, String clientDigest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        md5a1 = md5a1.toLowerCase(Locale.ENGLISH);
        String serverDigestValue = qop == null ? md5a1 + ":" + nonce + ":" + md5a2 : md5a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        byte[] valueBytes = null;
        try {
            valueBytes = serverDigestValue.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Illegal digestEncoding: " + this.getDigestEncoding(), uee);
            throw new IllegalArgumentException(uee.getMessage());
        }
        String serverDigest = MD5Encoder.encode(ConcurrentMessageDigest.digestMD5(new byte[][]{valueBytes}));
        if (log.isDebugEnabled()) {
            log.debug("Digest : " + clientDigest + " Username:" + username + " ClientDigest:" + clientDigest + " nonce:" + nonce + " nc:" + nc + " cnonce:" + cnonce + " qop:" + qop + " realm:" + realm + "md5a2:" + md5a2 + " Server digest:" + serverDigest);
        }
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i2 = 0; i2 < certs.length; ++i2) {
                if (log.isDebugEnabled()) {
                    log.debug(" Checking validity for '" + certs[i2].getSubjectDN().getName() + "'");
                }
                try {
                    certs[i2].checkValidity();
                    continue;
                }
                catch (Exception e2) {
                    if (log.isDebugEnabled()) {
                        log.debug("  Validity exception", e2);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(certs[0]);
    }

    @Override
    public Principal authenticate(GSSContext gssContext, boolean storeCred) {
        if (gssContext.isEstablished()) {
            GSSName gssName = null;
            try {
                gssName = gssContext.getSrcName();
            }
            catch (GSSException e2) {
                log.warn(sm.getString("realmBase.gssNameFail"), e2);
            }
            if (gssName != null) {
                GSSCredential gssCredential = null;
                if (storeCred) {
                    if (gssContext.getCredDelegState()) {
                        try {
                            gssCredential = gssContext.getDelegCred();
                        }
                        catch (GSSException e3) {
                            log.warn(sm.getString("realmBase.delegatedCredentialFail", gssName), e3);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug(sm.getString("realmBase.credentialNotDelegated", gssName));
                    }
                }
                return this.getPrincipal(gssName, gssCredential);
            }
        } else {
            log.error(sm.getString("realmBase.gssContextNotEstablished"));
        }
        return null;
    }

    @Override
    public Principal authenticate(GSSName gssName, GSSCredential gssCredential) {
        if (gssName == null) {
            return null;
        }
        return this.getPrincipal(gssName, gssCredential);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        String pattern;
        int k2;
        boolean matched;
        int i2;
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug("  No applicable constraints defined");
            }
            return null;
        }
        String uri = request.getRequestPathMB().toString();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        String method = request.getMethod();
        boolean found = false;
        for (i2 = 0; i2 < constraints.length; ++i2) {
            SecurityCollection[] collection = constraints[i2].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("  Checking constraint '" + constraints[i2] + "' against " + method + " " + uri + " --> " + constraints[i2].included(uri, method));
            }
            for (int j2 = 0; j2 < collection.length; ++j2) {
                String[] patterns = collection[j2].findPatterns();
                if (patterns == null) continue;
                for (int k3 = 0; k3 < patterns.length; ++k3) {
                    if (!uri.equals(patterns[k3]) && (patterns[k3].length() != 0 || !uri.equals("/"))) continue;
                    found = true;
                    if (!collection[j2].findMethod(method)) continue;
                    if (results == null) {
                        results = new ArrayList<SecurityConstraint>();
                    }
                    results.add(constraints[i2]);
                }
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        int longest = -1;
        for (i2 = 0; i2 < constraints.length; ++i2) {
            SecurityCollection[] collection = constraints[i2].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("  Checking constraint '" + constraints[i2] + "' against " + method + " " + uri + " --> " + constraints[i2].included(uri, method));
            }
            for (int j3 = 0; j3 < collection.length; ++j3) {
                String[] patterns = collection[j3].findPatterns();
                if (patterns == null) continue;
                matched = false;
                int length = -1;
                for (k2 = 0; k2 < patterns.length; ++k2) {
                    pattern = patterns[k2];
                    if (!pattern.startsWith("/") || !pattern.endsWith("/*") || pattern.length() < longest) continue;
                    if (pattern.length() == 2) {
                        matched = true;
                        length = pattern.length();
                        continue;
                    }
                    if (!pattern.regionMatches(0, uri, 0, pattern.length() - 1) && (pattern.length() - 2 != uri.length() || !pattern.regionMatches(0, uri, 0, pattern.length() - 2))) continue;
                    matched = true;
                    length = pattern.length();
                }
                if (!matched) continue;
                if (length > longest) {
                    found = false;
                    if (results != null) {
                        results.clear();
                    }
                    longest = length;
                }
                if (!collection[j3].findMethod(method)) continue;
                found = true;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i2]);
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i2 = 0; i2 < constraints.length; ++i2) {
            SecurityCollection[] collection = constraints[i2].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("  Checking constraint '" + constraints[i2] + "' against " + method + " " + uri + " --> " + constraints[i2].included(uri, method));
            }
            boolean matched2 = false;
            int pos = -1;
            for (int j4 = 0; j4 < collection.length; ++j4) {
                String[] patterns = collection[j4].findPatterns();
                if (patterns == null) continue;
                for (k2 = 0; k2 < patterns.length && !matched2; ++k2) {
                    pattern = patterns[k2];
                    if (!pattern.startsWith("*.")) continue;
                    int slash = uri.lastIndexOf(47);
                    int dot = uri.lastIndexOf(46);
                    if (slash < 0 || dot <= slash || dot == uri.length() - 1 || uri.length() - dot != pattern.length() - 1 || !pattern.regionMatches(1, uri, dot, uri.length() - dot)) continue;
                    matched2 = true;
                    pos = j4;
                }
            }
            if (!matched2) continue;
            found = true;
            if (!collection[pos].findMethod(method)) continue;
            if (results == null) {
                results = new ArrayList();
            }
            results.add(constraints[i2]);
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i2 = 0; i2 < constraints.length; ++i2) {
            SecurityCollection[] collection = constraints[i2].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("  Checking constraint '" + constraints[i2] + "' against " + method + " " + uri + " --> " + constraints[i2].included(uri, method));
            }
            for (int j5 = 0; j5 < collection.length; ++j5) {
                String[] patterns = collection[j5].findPatterns();
                if (patterns == null) continue;
                matched = false;
                for (int k4 = 0; k4 < patterns.length && !matched; ++k4) {
                    String pattern2 = patterns[k4];
                    if (!pattern2.equals("/")) continue;
                    matched = true;
                }
                if (!matched) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i2]);
            }
        }
        if (results == null && log.isDebugEnabled()) {
            log.debug("  No applicable constraint located");
        }
        return this.resultsToArray(results);
    }

    private SecurityConstraint[] resultsToArray(ArrayList<SecurityConstraint> results) {
        if (results == null || results.size() == 0) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        results.toArray(array);
        return array;
    }

    @Override
    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        String[] roles;
        SecurityConstraint constraint;
        int i2;
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        Principal principal = request.getPrincipal();
        boolean status = false;
        boolean denyfromall = false;
        for (i2 = 0; i2 < constraints.length; ++i2) {
            constraint = constraints[i2];
            roles = constraint.getAllRoles() ? request.getContext().findSecurityRoles() : constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (log.isDebugEnabled()) {
                log.debug("  Checking roles " + principal);
            }
            if (constraint.getAuthenticatedUsers() && principal != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Passing all authenticated users");
                }
                status = true;
                continue;
            }
            if (roles.length == 0 && !constraint.getAllRoles() && !constraint.getAuthenticatedUsers()) {
                if (constraint.getAuthConstraint()) {
                    if (log.isDebugEnabled()) {
                        log.debug("No roles");
                    }
                    status = false;
                    denyfromall = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Passing all access");
                }
                status = true;
                continue;
            }
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("  No user authenticated, cannot grant access");
                continue;
            }
            for (int j2 = 0; j2 < roles.length; ++j2) {
                if (this.hasRole(request.getWrapper(), principal, roles[j2]) || context != null && this.checkRoleMapping(context.getName(), roles[j2], principal)) {
                    status = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Role found:  " + roles[j2]);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("No role found:  " + roles[j2]);
            }
        }
        if (!denyfromall && this.allRolesMode != AllRolesMode.STRICT_MODE && !status && principal != null) {
            if (log.isDebugEnabled()) {
                log.debug("Checking for all roles mode: " + this.allRolesMode);
            }
            for (i2 = 0; i2 < constraints.length; ++i2) {
                constraint = constraints[i2];
                if (!constraint.getAllRoles()) continue;
                if (this.allRolesMode == AllRolesMode.AUTH_ONLY_MODE) {
                    if (log.isDebugEnabled()) {
                        log.debug("Granting access for role-name=*, auth-only");
                    }
                    status = true;
                    break;
                }
                roles = request.getContext().findSecurityRoles();
                if (roles.length != 0 || this.allRolesMode != AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Granting access for role-name=*, strict auth-only");
                }
                status = true;
                break;
            }
        }
        if (!status) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return status;
    }

    protected boolean checkRoleMapping(String contextName, String role, Principal principal) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        RoleMapper roleMapper = RoleMapperFactory.getInstance().getRoleMapper(contextName);
        if (roleMapper.mappingPrincipal(role, principal.getName())) {
            return true;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        Principal userPrincipal = gp.getUserPrincipal();
        if (userPrincipal == null || !(userPrincipal instanceof MemoryUser)) {
            return false;
        }
        MemoryUser user = (MemoryUser)userPrincipal;
        HashSet<String> groups = new HashSet<String>();
        Iterator<Group> iterator = user.getGroups();
        while (iterator.hasNext()) {
            groups.add(iterator.next().getGroupname());
        }
        return roleMapper.mappingGroup(role, groups);
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        Context context;
        String realRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        boolean result = gp.hasRole(role);
        if (!result && wrapper != null && this.checkRoleMapping((context = (Context)wrapper.getParent()).getName(), role, principal)) {
            result = true;
        }
        if (!result) {
            result = this.hasRoleInternal(principal, role);
        }
        if (log.isDebugEnabled()) {
            String name = principal.getName();
            if (result) {
                log.debug(sm.getString("realmBase.hasRoleSuccess", name, role));
            } else {
                log.debug(sm.getString("realmBase.hasRoleFailure", name, role));
            }
        }
        return result;
    }

    protected boolean hasRoleInternal(Principal principal, String role) {
        if (!(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        return gp.hasRole(role);
    }

    @Override
    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        String queryString;
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug("  No applicable security constraint defined");
            }
            return true;
        }
        for (int i2 = 0; i2 < constraints.length; ++i2) {
            SecurityConstraint constraint = constraints[i2];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null) {
                if (log.isDebugEnabled()) {
                    log.debug("  No applicable user data constraint defined");
                }
                return true;
            }
            if (!userConstraint.equals(ServletSecurity.TransportGuarantee.NONE.name())) continue;
            if (log.isDebugEnabled()) {
                log.debug("  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug("  User data constraint already satisfied");
            }
            return true;
        }
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuilder file = new StringBuilder();
        String protocol = "https";
        String host = request.getServerName();
        if (whiteList != null && whiteList.size() > 0 && !whiteList.contains(host)) {
            if (log.isDebugEnabled()) {
                log.debug("  SSL redirect is forbidden");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        file.append(protocol).append("://").append(host);
        if (redirectPort != 443) {
            file.append(':').append(redirectPort);
        }
        file.append(request.getRequestURI());
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId != null && request.isRequestedSessionIdFromURL()) {
            file.append(";");
            file.append(SessionConfig.getSessionUriParamName(request.getContext()));
            file.append("=");
            file.append(requestedSessionId);
        }
        if ((queryString = request.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        if (log.isDebugEnabled()) {
            log.debug("  Redirecting to " + file.toString());
        }
        response.sendRedirect(file.toString(), this.transportGuaranteeRedirectStatus);
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.containerLog = this.container.getLogger();
        }
        this.x509UsernameRetriever = RealmBase.createUsernameRetriever(this.x509UsernameRetrieverClassName);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.credentialHandler == null) {
            this.credentialHandler = new MessageDigestCredentialHandler();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Realm[");
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    protected boolean hasMessageDigest() {
        CredentialHandler ch = this.credentialHandler;
        if (ch instanceof MessageDigestCredentialHandler) {
            return ((MessageDigestCredentialHandler)ch).getAlgorithm() != null;
        }
        return false;
    }

    public String getDigest(String username, String realmName) {
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        String digestValue = username + ":" + realmName + ":" + this.getPassword(username);
        byte[] valueBytes = null;
        try {
            valueBytes = digestValue.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Illegal digestEncoding: " + this.getDigestEncoding(), uee);
            throw new IllegalArgumentException(uee.getMessage());
        }
        return MD5Encoder.encode(ConcurrentMessageDigest.digestMD5(new byte[][]{valueBytes}));
    }

    private String getDigestEncoding() {
        CredentialHandler ch = this.credentialHandler;
        if (ch instanceof MessageDigestCredentialHandler) {
            return ((MessageDigestCredentialHandler)ch).getEncoding();
        }
        return null;
    }

    private Charset getDigestCharset() throws UnsupportedEncodingException {
        String charset = this.getDigestEncoding();
        if (charset == null) {
            return StandardCharsets.ISO_8859_1;
        }
        return B2CConverter.getCharset(charset);
    }

    @Deprecated
    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected Principal getPrincipal(X509Certificate usercert) {
        String username = this.x509UsernameRetriever.getUsername(usercert);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("realmBase.gotX509Username", username));
        }
        return this.getPrincipal(username);
    }

    protected abstract Principal getPrincipal(String var1);

    @Deprecated
    protected Principal getPrincipal(String username, GSSCredential gssCredential) {
        Principal p2 = this.getPrincipal(username);
        if (p2 instanceof GenericPrincipal) {
            ((GenericPrincipal)p2).setGssCredential(gssCredential);
        }
        return p2;
    }

    protected Principal getPrincipal(GSSName gssName, GSSCredential gssCredential) {
        Principal p2;
        int i2;
        String name = gssName.toString();
        if (this.isStripRealmForGss() && (i2 = name.indexOf(64)) > 0) {
            name = name.substring(0, i2);
        }
        if ((p2 = this.getPrincipal(name)) instanceof GenericPrincipal) {
            ((GenericPrincipal)p2).setGssCredential(gssCredential);
        }
        return p2;
    }

    protected Server getServer() {
        Service s2;
        Container c2 = this.container;
        if (c2 instanceof Context) {
            c2 = c2.getParent();
        }
        if (c2 instanceof Host) {
            c2 = c2.getParent();
        }
        if (c2 instanceof Engine && (s2 = ((Engine)c2).getService()) != null) {
            return s2.getServer();
        }
        return null;
    }

    @Deprecated
    public static final String Digest(String credentials, String algorithm, String encoding) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            if (encoding == null) {
                md.update(credentials.getBytes());
            } else {
                md.update(credentials.getBytes(encoding));
            }
            return HexUtils.toHexString(md.digest());
        }
        catch (Exception ex) {
            log.error(ex);
            return credentials;
        }
    }

    public static void main(String[] args) {
        int saltLength = -1;
        int iterations = -1;
        int keyLength = -1;
        String encoding = Charset.defaultCharset().name();
        String algorithm = null;
        String handlerClassName = null;
        if (args.length == 0) {
            RealmBase.usage();
            return;
        }
        int argIndex = 0;
        while (args.length > argIndex + 2 && args[argIndex].length() == 2 && args[argIndex].charAt(0) == '-') {
            switch (args[argIndex].charAt(1)) {
                case 'a': {
                    algorithm = args[argIndex + 1];
                    break;
                }
                case 'e': {
                    encoding = args[argIndex + 1];
                    break;
                }
                case 'i': {
                    iterations = Integer.parseInt(args[argIndex + 1]);
                    break;
                }
                case 's': {
                    saltLength = Integer.parseInt(args[argIndex + 1]);
                    break;
                }
                case 'k': {
                    keyLength = Integer.parseInt(args[argIndex + 1]);
                    break;
                }
                case 'h': {
                    handlerClassName = args[argIndex + 1];
                    break;
                }
                default: {
                    RealmBase.usage();
                    return;
                }
            }
            argIndex += 2;
        }
        if (algorithm == null && handlerClassName == null) {
            algorithm = "SHA-512";
        }
        CredentialHandler handler = null;
        if (handlerClassName == null) {
            for (Class<? extends DigestCredentialHandlerBase> clazz : credentialHandlerClasses) {
                try {
                    handler = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!IntrospectionUtils.setProperty(handler, "algorithm", algorithm)) continue;
                    break;
                }
                catch (ReflectiveOperationException e2) {
                    throw new RuntimeException(e2);
                }
            }
        } else {
            try {
                Class<?> clazz = Class.forName(handlerClassName);
                handler = (DigestCredentialHandlerBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                IntrospectionUtils.setProperty(handler, "algorithm", algorithm);
            }
            catch (ReflectiveOperationException e3) {
                throw new RuntimeException(e3);
            }
        }
        if (handler == null) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm));
        }
        IntrospectionUtils.setProperty(handler, "encoding", encoding);
        if (iterations > 0) {
            IntrospectionUtils.setProperty(handler, "iterations", Integer.toString(iterations));
        }
        if (saltLength > -1) {
            IntrospectionUtils.setProperty(handler, "saltLength", Integer.toString(saltLength));
        }
        if (keyLength > 0) {
            IntrospectionUtils.setProperty(handler, "keyLength", Integer.toString(keyLength));
        }
        while (argIndex < args.length) {
            String credential = args[argIndex];
            System.out.print(credential + ":");
            System.out.println(handler.mutate(credential));
            ++argIndex;
        }
    }

    private static void usage() {
        System.out.println("Usage: RealmBase [-a <algorithm>] [-e <encoding>] [-i <iterations>] [-s <salt-length>] [-k <key-length>] [-h <handler-class-name>] <credentials>");
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("type=Realm");
        keyProperties.append(this.getRealmSuffix());
        keyProperties.append(this.container.getMBeanKeyProperties());
        return keyProperties.toString();
    }

    @Override
    public String getDomainInternal() {
        return this.container.getDomain();
    }

    public String getRealmPath() {
        return this.realmPath;
    }

    public void setRealmPath(String theRealmPath) {
        this.realmPath = theRealmPath;
    }

    protected String getRealmSuffix() {
        return ",realmPath=" + this.getRealmPath();
    }

    private static X509UsernameRetriever createUsernameRetriever(String className) throws LifecycleException {
        if (null == className || "".equals(className.trim())) {
            return new X509SubjectDnRetriever();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (X509UsernameRetriever)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e2) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.newInstance", className), e2);
        }
        catch (ClassCastException e3) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.ClassCastException", className), e3);
        }
    }

    @Override
    public String[] getRoles(Principal principal) {
        if (principal instanceof GenericPrincipal) {
            return ((GenericPrincipal)principal).getRoles();
        }
        String className = principal.getClass().getSimpleName();
        throw new IllegalStateException(sm.getString("realmBase.cannotGetRoles", className));
    }

    static {
        credentialHandlerClasses.add(MessageDigestCredentialHandler.class);
        credentialHandlerClasses.add(SecretKeyCredentialHandler.class);
        String whites = System.getProperty("com.bes.enterprise.webtier.whiteList");
        if (whites != null && !whites.equals("")) {
            whiteList = Arrays.asList(whites.split(","));
        }
        sm = StringManager.getManager(RealmBase.class);
    }

    protected static class AllRolesMode {
        private final String name;
        public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
        public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
        public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

        static AllRolesMode toMode(String name) {
            AllRolesMode mode;
            if (name.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
                mode = STRICT_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
                mode = AUTH_ONLY_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
                mode = STRICT_AUTH_ONLY_MODE;
            } else {
                throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
            }
            return mode;
        }

        private AllRolesMode(String name) {
            this.name = name;
        }

        public boolean equals(Object o2) {
            boolean equals = false;
            if (o2 instanceof AllRolesMode) {
                AllRolesMode mode = (AllRolesMode)o2;
                equals = this.name.equals(mode.name);
            }
            return equals;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

