/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.security;

public final class SecurityClassLoad {
    public static void securityClassLoad(ClassLoader loader) throws Exception {
        SecurityClassLoad.securityClassLoad(loader, true);
    }

    static void securityClassLoad(ClassLoader loader, boolean requireSecurityManager) throws Exception {
        if (requireSecurityManager && System.getSecurityManager() == null) {
            return;
        }
        SecurityClassLoad.loadCorePackage(loader);
        SecurityClassLoad.loadCoyotePackage(loader);
        SecurityClassLoad.loadLoaderPackage(loader);
        SecurityClassLoad.loadRealmPackage(loader);
        SecurityClassLoad.loadServletsPackage(loader);
        SecurityClassLoad.loadSessionPackage(loader);
        SecurityClassLoad.loadUtilPackage(loader);
        SecurityClassLoad.loadJavaxPackage(loader);
        SecurityClassLoad.loadConnectorPackage(loader);
        SecurityClassLoad.loadAppServerPackage(loader);
    }

    private static final void loadCorePackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.core.";
        loader.loadClass("com.bes.enterprise.webtier.core.AccessLogAdapter");
        loader.loadClass("com.bes.enterprise.webtier.core.ApplicationContextFacade$PrivilegedExecuteMethod");
        loader.loadClass("com.bes.enterprise.webtier.core.ApplicationDispatcher$PrivilegedForward");
        loader.loadClass("com.bes.enterprise.webtier.core.ApplicationDispatcher$PrivilegedInclude");
        loader.loadClass("com.bes.enterprise.webtier.core.ApplicationPushBuilder");
        loader.loadClass("com.bes.enterprise.webtier.core.AsyncContextImpl");
        loader.loadClass("com.bes.enterprise.webtier.core.AsyncContextImpl$AsyncRunnable");
        loader.loadClass("com.bes.enterprise.webtier.core.AsyncContextImpl$DebugException");
        loader.loadClass("com.bes.enterprise.webtier.core.AsyncListenerWrapper");
        loader.loadClass("com.bes.enterprise.webtier.core.ContainerBase$PrivilegedAddChild");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.core.DefaultInstanceManager");
        loader.loadClass("com.bes.enterprise.webtier.core.DefaultInstanceManager$AnnotationCacheEntry");
        loader.loadClass("com.bes.enterprise.webtier.core.DefaultInstanceManager$AnnotationCacheEntryType");
        loader.loadClass("com.bes.enterprise.webtier.core.ApplicationHttpRequest$AttributeNamesEnumerator");
    }

    private static final void loadLoaderPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.loader.";
        loader.loadClass("com.bes.enterprise.webtier.loader.WebappClassLoaderBase$PrivilegedFindClassByName");
        loader.loadClass("com.bes.enterprise.webtier.loader.WebappClassLoaderBase$PrivilegedHasLoggingConfig");
    }

    private static final void loadRealmPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.realm.";
        loader.loadClass("com.bes.enterprise.webtier.realm.LockOutRealm$LockRecord");
    }

    private static final void loadServletsPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.servlets.";
        loader.loadClass("com.bes.enterprise.webtier.servlets.DefaultServlet");
    }

    private static final void loadSessionPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.session.";
        loader.loadClass("com.bes.enterprise.webtier.session.DefaultSession");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.session.DefaultSession");
        loader.loadClass("com.bes.enterprise.webtier.session.DefaultManager$PrivilegedDoUnload");
    }

    private static final void loadUtilPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.util.";
        loader.loadClass("com.bes.enterprise.webtier.util.ParameterMap");
        loader.loadClass("com.bes.enterprise.webtier.util.RequestUtil");
        loader.loadClass("com.bes.enterprise.webtier.util.TLSUtil");
    }

    private static final void loadCoyotePackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.web.crane.";
        loader.loadClass("com.bes.enterprise.web.crane.http11.Constants");
        Class<?> clazz = loader.loadClass("com.bes.enterprise.web.crane.Constants");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        loader.loadClass("com.bes.enterprise.web.crane.http2.Stream$PrivilegedPush");
    }

    private static final void loadJavaxPackage(ClassLoader loader) throws Exception {
        loader.loadClass("javax.servlet.http.Cookie");
    }

    private static final void loadConnectorPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.webtier.connector.";
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetAttributePrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetParameterMapPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetRequestDispatcherPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetParameterPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetParameterNamesPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetParameterValuePrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetCharacterEncodingPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetHeadersPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetHeaderNamesPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetCookiesPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetLocalePrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetLocalesPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.ResponseFacade$SetContentTypePrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.ResponseFacade$DateHeaderPrivilegedAction");
        loader.loadClass("com.bes.enterprise.webtier.connector.RequestFacade$GetSessionPrivilegedAction");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.connector.ResponseFacade");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.connector.OutputBuffer");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.connector.CoyoteInputStream");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.connector.InputBuffer");
        SecurityClassLoad.loadAnonymousInnerClasses(loader, "com.bes.enterprise.webtier.connector.Response");
    }

    private static final void loadAppServerPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.bes.enterprise.web.";
        loader.loadClass("com.bes.enterprise.web.util.buf.B2CConverter");
        loader.loadClass("com.bes.enterprise.web.util.buf.ByteBufferUtils");
        loader.loadClass("com.bes.enterprise.web.util.buf.C2BConverter");
        loader.loadClass("com.bes.enterprise.web.util.buf.HexUtils");
        loader.loadClass("com.bes.enterprise.web.util.buf.StringCache");
        loader.loadClass("com.bes.enterprise.web.util.buf.StringCache$ByteEntry");
        loader.loadClass("com.bes.enterprise.web.util.buf.StringCache$CharEntry");
        loader.loadClass("com.bes.enterprise.web.util.buf.UriUtil");
        Class<?> clazz = loader.loadClass("com.bes.enterprise.web.util.collections.CaseInsensitiveKeyMap");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        loader.loadClass("com.bes.enterprise.web.util.collections.CaseInsensitiveKeyMap$EntryImpl");
        loader.loadClass("com.bes.enterprise.web.util.collections.CaseInsensitiveKeyMap$EntryIterator");
        loader.loadClass("com.bes.enterprise.web.util.collections.CaseInsensitiveKeyMap$EntrySet");
        loader.loadClass("com.bes.enterprise.web.util.collections.CaseInsensitiveKeyMap$Key");
        loader.loadClass("com.bes.enterprise.web.util.http.CookieProcessor");
        loader.loadClass("com.bes.enterprise.web.util.http.NamesEnumerator");
        clazz = loader.loadClass("com.bes.enterprise.web.util.http.FastHttpDateFormat");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        loader.loadClass("com.bes.enterprise.web.util.http.parser.HttpParser");
        loader.loadClass("com.bes.enterprise.web.util.http.parser.MediaType");
        loader.loadClass("com.bes.enterprise.web.util.http.parser.MediaTypeCache");
        loader.loadClass("com.bes.enterprise.web.util.http.parser.SkipResult");
        loader.loadClass("com.bes.enterprise.web.util.net.Constants");
        loader.loadClass("com.bes.enterprise.web.util.net.DispatchType");
        loader.loadClass("com.bes.enterprise.web.util.net.NativeEndpoint$NativeSocketWrapper$NativeOperationState");
        loader.loadClass("com.bes.enterprise.web.util.net.NioEndpoint$NioSocketWrapper$NioOperationState");
        loader.loadClass("com.bes.enterprise.web.util.net.Nio2Endpoint$Nio2SocketWrapper$Nio2OperationState");
        loader.loadClass("com.bes.enterprise.web.util.net.SocketWrapperBase$BlockingMode");
        loader.loadClass("com.bes.enterprise.web.util.net.SocketWrapperBase$CompletionCheck");
        loader.loadClass("com.bes.enterprise.web.util.net.SocketWrapperBase$CompletionHandlerCall");
        loader.loadClass("com.bes.enterprise.web.util.net.SocketWrapperBase$CompletionState");
        loader.loadClass("com.bes.enterprise.web.util.net.SocketWrapperBase$VectoredIOCompletionHandler");
        loader.loadClass("com.bes.enterprise.web.util.security.PrivilegedGetTccl");
        loader.loadClass("com.bes.enterprise.web.util.security.PrivilegedSetTccl");
    }

    private static final void loadAnonymousInnerClasses(ClassLoader loader, String enclosingClass) {
        try {
            int i2 = 1;
            while (true) {
                loader.loadClass(enclosingClass + '$' + i2);
                ++i2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

