/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.session;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Loader;
import com.bes.enterprise.webtier.Session;
import com.bes.enterprise.webtier.security.SecurityUtil;
import com.bes.enterprise.webtier.session.DefaultSession;
import com.bes.enterprise.webtier.session.ManagerBase;
import com.bes.enterprise.webtier.util.CustomObjectInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;

public class DefaultManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(DefaultManager.class);
    protected static final String name = "DefaultManager";
    protected String pathname = "SESSIONS.ser";

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoad());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unreported exception in load() ", exception);
                }
            }
        } else {
            this.doLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doLoad() throws ClassNotFoundException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException(sm.getString("standardManager.loading.notFile", file.getAbsoluteFile()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.loading", this.pathname));
        }
        Loader loader = null;
        ClassLoader classLoader = null;
        Log logger = null;
        try (FileInputStream fis = new FileInputStream(file.getAbsolutePath());
             BufferedInputStream bis = new BufferedInputStream(fis);){
            Context c2 = this.getContext();
            loader = c2.getLoader();
            logger = c2.getLogger();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Map map = this.sessions;
            synchronized (map) {
                block54: {
                    try {
                        try (CustomObjectInputStream ois = new CustomObjectInputStream(bis, classLoader, logger, this.getSessionAttributeValueClassNamePattern(), this.getWarnOnSessionAttributeFilterFailure());){
                            Integer count = (Integer)ois.readObject();
                            int n2 = count;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Loading " + n2 + " persisted sessions");
                            }
                            for (int i2 = 0; i2 < n2; ++this.sessionCounter, ++i2) {
                                DefaultSession session = this.getNewSession();
                                session.readObjectData(ois);
                                session.setManager(this);
                                this.sessions.put(session.getIdInternal(), session);
                                session.activate();
                                if (session.isValidInternal()) continue;
                                session.setValid(true);
                                session.expire();
                            }
                        }
                        if (!file.exists() || file.delete()) break block54;
                    }
                    catch (Throwable throwable) {
                        if (file.exists() && !file.delete()) {
                            this.log.warn(sm.getString("standardManager.deletePersistedFileFail", file));
                        }
                        throw throwable;
                    }
                    this.log.warn(sm.getString("standardManager.deletePersistedFileFail", file));
                }
            }
        }
        catch (FileNotFoundException e2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No persisted data file found");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finish: Loading persisted sessions");
        }
    }

    @Override
    public void unload() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unreported exception in unLoad()", exception);
                }
            }
        } else {
            this.doUnload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.unloading.debug"));
        }
        if (this.sessions.isEmpty()) {
            this.log.debug(sm.getString("standardManager.unloading.nosessions"));
            return;
        }
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("standardManager.unloading", this.pathname));
        }
        ArrayList<DefaultSession> list = new ArrayList<DefaultSession>();
        try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            Map map = this.sessions;
            synchronized (map) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unloading " + this.sessions.size() + " sessions");
                }
                oos.writeObject(this.sessions.size());
                for (Session s2 : this.sessions.values()) {
                    DefaultSession session = (DefaultSession)s2;
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Expiring " + list.size() + " persisted sessions");
        }
        for (DefaultSession session : list) {
            try {
                session.expire(false);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
            }
            finally {
                session.recycle();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unloading complete");
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            this.load();
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            this.log.error(sm.getString("standardManager.managerLoad"), t2);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.unload();
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            this.log.error(sm.getString("standardManager.managerUnload"), t2);
        }
        Session[] sessions = this.findSessions();
        for (int i2 = 0; i2 < sessions.length; ++i2) {
            Session session = sessions[i2];
            try {
                if (!session.isValid()) continue;
                session.expire();
                continue;
            }
            catch (Throwable t3) {
                ExceptionUtils.handleThrowable(t3);
                continue;
            }
            finally {
                session.recycle();
            }
        }
        super.stopInternal();
    }

    protected File file() {
        Context context;
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && (tempdir = (File)(servletContext = (context = this.getContext()).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoUnload() {
        }

        @Override
        public Void run() throws Exception {
            DefaultManager.this.doUnload();
            return null;
        }
    }

    private class PrivilegedDoLoad
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoLoad() {
        }

        @Override
        public Void run() throws Exception {
            DefaultManager.this.doLoad();
            return null;
        }
    }
}

