/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.session;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Manager;
import com.bes.enterprise.webtier.Store;
import com.bes.enterprise.webtier.session.DefaultSession;
import com.bes.enterprise.webtier.session.ManagerBase;
import com.bes.enterprise.webtier.session.PersistentManagerBase;
import com.bes.enterprise.webtier.util.CustomObjectInputStream;
import com.bes.enterprise.webtier.util.LifecycleBase;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public abstract class StoreBase
extends LifecycleBase
implements Store {
    protected static final String storeName = "StoreBase";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected static final StringManager sm = StringManager.getManager(StoreBase.class);
    protected Manager manager;

    public String getStoreName() {
        return storeName;
    }

    @Override
    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String[] expiredKeys() throws IOException {
        return this.keys();
    }

    public void processExpires() {
        String[] keys = null;
        if (!this.getState().isAvailable()) {
            return;
        }
        try {
            keys = this.expiredKeys();
        }
        catch (IOException e2) {
            this.manager.getContext().getLogger().error("Error getting keys", e2);
            return;
        }
        if (this.manager.getContext().getLogger().isDebugEnabled()) {
            this.manager.getContext().getLogger().debug(this.getStoreName() + ": processExpires check number of " + keys.length + " sessions");
        }
        long timeNow = System.currentTimeMillis();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            try {
                int timeIdle;
                DefaultSession session = (DefaultSession)this.load(keys[i2]);
                if (session == null || (timeIdle = (int)((timeNow - session.getThisAccessedTime()) / 1000L)) < session.getMaxInactiveInterval()) continue;
                if (this.manager.getContext().getLogger().isDebugEnabled()) {
                    this.manager.getContext().getLogger().debug(this.getStoreName() + ": processExpires expire store session " + keys[i2]);
                }
                boolean isLoaded = false;
                if (this.manager instanceof PersistentManagerBase) {
                    isLoaded = ((PersistentManagerBase)this.manager).isLoaded(keys[i2]);
                } else {
                    try {
                        if (this.manager.findSession(keys[i2]) != null) {
                            isLoaded = true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (isLoaded) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(keys[i2]);
                continue;
            }
            catch (Exception e3) {
                this.manager.getContext().getLogger().error("Session: " + keys[i2] + "; ", e3);
                try {
                    this.remove(keys[i2]);
                    continue;
                }
                catch (IOException e2) {
                    this.manager.getContext().getLogger().error("Error removing key", e2);
                }
            }
        }
    }

    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        CustomObjectInputStream ois;
        BufferedInputStream bis = new BufferedInputStream(is);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.manager instanceof ManagerBase) {
            ManagerBase managerBase = (ManagerBase)this.manager;
            ois = new CustomObjectInputStream(bis, classLoader, this.manager.getContext().getLogger(), managerBase.getSessionAttributeValueClassNamePattern(), managerBase.getWarnOnSessionAttributeFilterFailure());
        } else {
            ois = new CustomObjectInputStream(bis, classLoader);
        }
        return ois;
    }

    @Override
    protected void initInternal() {
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected void destroyInternal() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.manager == null) {
            sb.append("Manager is null");
        } else {
            sb.append(this.manager);
        }
        sb.append(']');
        return sb.toString();
    }
}

