/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.digester.RuleSetBase;
import com.bes.enterprise.webtier.startup.CredentialHandlerRuleSet;

public class RealmRuleSet
extends RuleSetBase {
    private static final int MAX_NESTED_REALM_LEVELS = Integer.getInteger("com.bes.enterprise.webtier.startup.RealmRuleSet.MAX_NESTED_REALM_LEVELS", 3);
    protected final String prefix;

    public RealmRuleSet() {
        this("");
    }

    public RealmRuleSet(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void addRuleInstances(Digester digester) {
        StringBuilder pattern = new StringBuilder(this.prefix);
        for (int i2 = 0; i2 < MAX_NESTED_REALM_LEVELS; ++i2) {
            if (i2 > 0) {
                pattern.append('/');
            }
            pattern.append("Realm");
            this.addRuleInstances(digester, pattern.toString(), i2 == 0 ? "setRealm" : "addRealm");
        }
    }

    private void addRuleInstances(Digester digester, String pattern, String methodName) {
        digester.addObjectCreate(pattern, null, "className");
        digester.addSetProperties(pattern);
        digester.addSetNext(pattern, methodName, "com.bes.enterprise.webtier.Realm");
        digester.addRuleSet(new CredentialHandlerRuleSet(pattern + "/"));
    }
}

