/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.appserver.startup.ClassLoaderFactory;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class Tool {
    private static final Log log = LogFactory.getLog(Tool.class);
    private static boolean ant = false;
    private static final String heavenHome = System.getProperty("bes.home");
    private static boolean common = false;
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] args) {
        if (heavenHome == null) {
            log.error("Must set 'bes.home' system property");
            System.exit(1);
        }
        int index = 0;
        while (true) {
            if (index == args.length) {
                Tool.usage();
                System.exit(1);
            }
            if ("-ant".equals(args[index])) {
                ant = true;
            } else if ("-common".equals(args[index])) {
                common = true;
            } else if ("-server".equals(args[index])) {
                server = true;
            } else {
                if (!"-shared".equals(args[index])) break;
                shared = true;
            }
            ++index;
        }
        if (index > args.length) {
            Tool.usage();
            System.exit(1);
        }
        if (ant) {
            System.setProperty("ant.home", heavenHome);
        }
        ClassLoader classLoader = null;
        try {
            ArrayList<File> packed = new ArrayList<File>();
            ArrayList<File> unpacked = new ArrayList<File>();
            unpacked.add(new File(heavenHome, "classes"));
            packed.add(new File(heavenHome, "lib"));
            if (common) {
                unpacked.add(new File(heavenHome, "common" + File.separator + "classes"));
                packed.add(new File(heavenHome, "common" + File.separator + "lib"));
            }
            if (server) {
                unpacked.add(new File(heavenHome, "server" + File.separator + "classes"));
                packed.add(new File(heavenHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                unpacked.add(new File(heavenHome, "shared" + File.separator + "classes"));
                packed.add(new File(heavenHome, "shared" + File.separator + "lib"));
            }
            classLoader = ClassLoaderFactory.createClassLoader(unpacked.toArray(new File[0]), packed.toArray(new File[0]), null);
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error("Class loader creation threw exception", t2);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> clazz = null;
        String className = args[index++];
        try {
            if (log.isDebugEnabled()) {
                log.debug("Loading application class " + className);
            }
            clazz = classLoader.loadClass(className);
        }
        catch (Throwable t3) {
            ExceptionUtils.handleThrowable(t3);
            log.error("Exception creating instance of " + className, t3);
            System.exit(1);
        }
        Method method = null;
        String[] params = new String[args.length - index];
        System.arraycopy(args, index, params, 0, params.length);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Identifying main() method");
            }
            String methodName = "main";
            Class[] paramTypes = new Class[]{params.getClass()};
            method = clazz.getMethod(methodName, paramTypes);
        }
        catch (Throwable t4) {
            ExceptionUtils.handleThrowable(t4);
            log.error("Exception locating main() method", t4);
            System.exit(1);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Calling main() method");
            }
            Object[] paramValues = new Object[]{params};
            method.invoke(null, paramValues);
        }
        catch (Throwable t5) {
            t5 = ExceptionUtils.unwrapInvocationTargetException(t5);
            ExceptionUtils.handleThrowable(t5);
            log.error("Exception calling main() method", t5);
            System.exit(1);
        }
    }

    private static void usage() {
        log.info("Usage:  java com.bes.enterprise.webtier.startup.Tool [<options>] <class> [<arguments>]");
    }
}

